/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import com.google.common.base.Objects;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.network.wired.IWiredElement;
import dan200.computercraft.api.network.wired.IWiredNode;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralTile;
import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wired.BlockWiredModemFull;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemElement;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemLocalPeripheral;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemPeripheral;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import net.minecraft.class_5250;

public class TileWiredModemFull
extends TileGeneric
implements IPeripheralTile {
    private static final String NBT_PERIPHERAL_ENABLED = "PeripheralAccess";
    private final WiredModemPeripheral[] modems = new WiredModemPeripheral[6];
    private boolean peripheralAccessAllowed = false;
    private final WiredModemLocalPeripheral[] peripherals = new WiredModemLocalPeripheral[6];
    private boolean destroyed = false;
    private boolean connectionsFormed = false;
    private final ModemState modemState = new ModemState(() -> TickScheduler.schedule(this));
    private final WiredModemElement element = new FullElement(this);
    private final IWiredNode node = this.element.getNode();
    private int invalidSides = 0;

    public TileWiredModemFull(class_2591<TileWiredModemFull> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        for (int i = 0; i < this.peripherals.length; ++i) {
            class_2350 facing = class_2350.method_10143((int)i);
            this.peripherals[i] = new WiredModemLocalPeripheral(() -> this.queueRefreshPeripheral(facing));
        }
    }

    private void doRemove() {
        if (this.field_11863 == null || !this.field_11863.field_9236) {
            this.node.remove();
            this.connectionsFormed = false;
        }
    }

    @Override
    public void destroy() {
        if (!this.destroyed) {
            this.destroyed = true;
            this.doRemove();
        }
        super.destroy();
    }

    @Override
    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.doRemove();
    }

    public void method_11012() {
        super.method_11012();
        this.doRemove();
    }

    @Override
    public void onNeighbourChange(@Nonnull class_2338 neighbour) {
        this.onNeighbourTileEntityChange(neighbour);
    }

    @Override
    public void onNeighbourTileEntityChange(@Nonnull class_2338 neighbour) {
        if (!this.field_11863.field_9236 && this.peripheralAccessAllowed) {
            for (class_2350 facing : DirectionUtil.FACINGS) {
                if (!this.method_11016().method_10093(facing).equals((Object)neighbour)) continue;
                this.queueRefreshPeripheral(facing);
            }
        }
    }

    private void queueRefreshPeripheral(@Nonnull class_2350 facing) {
        if (this.invalidSides == 0) {
            TickScheduler.schedule(this);
        }
        this.invalidSides |= 1 << facing.ordinal();
    }

    private void refreshPeripheral(@Nonnull class_2350 facing) {
        this.invalidSides &= ~(1 << facing.ordinal());
        WiredModemLocalPeripheral peripheral = this.peripherals[facing.ordinal()];
        if (this.field_11863 != null && !this.method_11015() && peripheral.attach(this.field_11863, this.method_11016(), facing)) {
            this.updateConnectedPeripherals();
        }
    }

    @Override
    @Nonnull
    public class_1269 onActivate(class_1657 player, class_1268 hand, class_3965 hit) {
        if (player.method_18276() || !player.method_7294()) {
            return class_1269.field_5811;
        }
        if (this.method_10997().field_9236) {
            return class_1269.field_5812;
        }
        Set<String> oldPeriphNames = this.getConnectedPeripheralNames();
        this.togglePeripheralAccess();
        Set<String> periphNames = this.getConnectedPeripheralNames();
        if (!Objects.equal(periphNames, oldPeriphNames)) {
            TileWiredModemFull.sendPeripheralChanges(player, "chat.computercraft.wired_modem.peripheral_disconnected", oldPeriphNames);
            TileWiredModemFull.sendPeripheralChanges(player, "chat.computercraft.wired_modem.peripheral_connected", periphNames);
        }
        return class_1269.field_5812;
    }

    private static void sendPeripheralChanges(class_1657 player, String kind, Collection<String> peripherals) {
        if (peripherals.isEmpty()) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>(peripherals);
        names.sort(Comparator.naturalOrder());
        class_5250 base = class_2561.method_43470((String)"");
        for (int i = 0; i < names.size(); ++i) {
            if (i > 0) {
                base.method_27693(", ");
            }
            base.method_10852((class_2561)ChatHelpers.copy((String)names.get(i)));
        }
        player.method_7353((class_2561)class_2561.method_43469((String)kind, (Object[])new Object[]{base}), false);
    }

    public void method_11014(@Nonnull class_2487 nbt) {
        super.method_11014(nbt);
        this.peripheralAccessAllowed = nbt.method_10577(NBT_PERIPHERAL_ENABLED);
        for (int i = 0; i < this.peripherals.length; ++i) {
            this.peripherals[i].read(nbt, Integer.toString(i));
        }
    }

    public void method_11007(class_2487 nbt) {
        nbt.method_10556(NBT_PERIPHERAL_ENABLED, this.peripheralAccessAllowed);
        for (int i = 0; i < this.peripherals.length; ++i) {
            this.peripherals[i].write(nbt, Integer.toString(i));
        }
        super.method_11007(nbt);
    }

    private void updateBlockState() {
        class_2680 state = this.method_11010();
        boolean modemOn = this.modemState.isOpen();
        boolean peripheralOn = this.peripheralAccessAllowed;
        if ((Boolean)state.method_11654((class_2769)BlockWiredModemFull.MODEM_ON) == modemOn && (Boolean)state.method_11654((class_2769)BlockWiredModemFull.PERIPHERAL_ON) == peripheralOn) {
            return;
        }
        this.method_10997().method_8501(this.method_11016(), (class_2680)((class_2680)state.method_11657((class_2769)BlockWiredModemFull.MODEM_ON, (Comparable)Boolean.valueOf(modemOn))).method_11657((class_2769)BlockWiredModemFull.PERIPHERAL_ON, (Comparable)Boolean.valueOf(peripheralOn)));
    }

    public void method_10996() {
        super.method_10996();
        TickScheduler.schedule(this);
    }

    @Override
    public void blockTick() {
        if (this.method_10997().field_9236) {
            return;
        }
        if (this.invalidSides != 0) {
            for (class_2350 direction : DirectionUtil.FACINGS) {
                if ((this.invalidSides & 1 << direction.ordinal()) == 0) continue;
                this.refreshPeripheral(direction);
            }
        }
        if (this.modemState.pollChanged()) {
            this.updateBlockState();
        }
        if (!this.connectionsFormed) {
            this.connectionsFormed = true;
            this.connectionsChanged();
            if (this.peripheralAccessAllowed) {
                for (class_2350 facing : DirectionUtil.FACINGS) {
                    this.peripherals[facing.ordinal()].attach(this.field_11863, this.method_11016(), facing);
                }
                this.updateConnectedPeripherals();
            }
        }
    }

    private void connectionsChanged() {
        if (this.method_10997().field_9236) {
            return;
        }
        class_1937 world = this.method_10997();
        class_2338 current = this.method_11016();
        for (class_2350 facing : DirectionUtil.FACINGS) {
            IWiredElement element;
            class_2338 offset = current.method_10093(facing);
            if (!world.method_8477(offset) || (element = ComputerCraftAPI.getWiredElementAt((class_1922)world, offset, facing.method_10153())) == null) continue;
            this.node.connectTo(element.getNode());
        }
    }

    private void togglePeripheralAccess() {
        if (!this.peripheralAccessAllowed) {
            boolean hasAny = false;
            for (class_2350 facing : DirectionUtil.FACINGS) {
                WiredModemLocalPeripheral peripheral = this.peripherals[facing.ordinal()];
                peripheral.attach(this.field_11863, this.method_11016(), facing);
                hasAny |= peripheral.hasPeripheral();
            }
            if (!hasAny) {
                return;
            }
            this.peripheralAccessAllowed = true;
            this.node.updatePeripherals(this.getConnectedPeripherals());
        } else {
            this.peripheralAccessAllowed = false;
            for (WiredModemLocalPeripheral peripheral : this.peripherals) {
                peripheral.detach();
            }
            this.node.updatePeripherals(Collections.emptyMap());
        }
        this.updateBlockState();
    }

    private Set<String> getConnectedPeripheralNames() {
        if (!this.peripheralAccessAllowed) {
            return Collections.emptySet();
        }
        HashSet<String> peripherals = new HashSet<String>(6);
        for (WiredModemLocalPeripheral peripheral : this.peripherals) {
            String name = peripheral.getConnectedName();
            if (name == null) continue;
            peripherals.add(name);
        }
        return peripherals;
    }

    private Map<String, IPeripheral> getConnectedPeripherals() {
        if (!this.peripheralAccessAllowed) {
            return Collections.emptyMap();
        }
        HashMap<String, IPeripheral> peripherals = new HashMap<String, IPeripheral>(6);
        for (WiredModemLocalPeripheral peripheral : this.peripherals) {
            peripheral.extendMap(peripherals);
        }
        return peripherals;
    }

    private void updateConnectedPeripherals() {
        Map<String, IPeripheral> peripherals = this.getConnectedPeripherals();
        if (peripherals.isEmpty()) {
            this.peripheralAccessAllowed = false;
            this.updateBlockState();
        }
        this.node.updatePeripherals(peripherals);
    }

    public IWiredElement getElement() {
        return this.element;
    }

    @Override
    @Nullable
    public IPeripheral getPeripheral(final @Nonnull class_2350 side) {
        WiredModemPeripheral peripheral = this.modems[side.ordinal()];
        if (peripheral != null) {
            return peripheral;
        }
        final WiredModemLocalPeripheral localPeripheral = this.peripherals[side.ordinal()];
        WiredModemPeripheral wiredModemPeripheral = new WiredModemPeripheral(this.modemState, this.element){

            @Override
            @Nonnull
            protected WiredModemLocalPeripheral getLocalPeripheral() {
                return localPeripheral;
            }

            @Override
            @Nonnull
            public class_243 getPosition() {
                return class_243.method_24953((class_2382)TileWiredModemFull.this.method_11016().method_10093(side));
            }

            @Override
            @Nonnull
            public Object getTarget() {
                return TileWiredModemFull.this;
            }
        };
        this.modems[side.ordinal()] = wiredModemPeripheral;
        return wiredModemPeripheral;
    }

    private static final class FullElement
    extends WiredModemElement {
        private final TileWiredModemFull entity;

        private FullElement(TileWiredModemFull entity) {
            this.entity = entity;
        }

        @Override
        protected void attachPeripheral(String name, IPeripheral peripheral) {
            for (int i = 0; i < 6; ++i) {
                WiredModemPeripheral modem = this.entity.modems[i];
                if (modem == null) continue;
                modem.attachPeripheral(name, peripheral);
            }
        }

        @Override
        protected void detachPeripheral(String name) {
            for (int i = 0; i < 6; ++i) {
                WiredModemPeripheral modem = this.entity.modems[i];
                if (modem == null) continue;
                modem.detachPeripheral(name);
            }
        }

        @Override
        @Nonnull
        public class_1937 getLevel() {
            return this.entity.method_10997();
        }

        @Override
        @Nonnull
        public class_243 getPosition() {
            return class_243.method_24953((class_2382)this.entity.method_11016());
        }
    }
}

