/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import dan200.computercraft.ComputerCraft;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.fabricmc.loader.api.FabricLoader;
import org.lwjgl.opengl.GL;

public enum MonitorRenderer {
    BEST,
    TBO,
    VBO;

    private static final List<String> shaderModIds;
    private static boolean shaderMod;
    public static final boolean canvasModPresent;

    @Nonnull
    public static MonitorRenderer current() {
        MonitorRenderer current = ComputerCraft.monitorRenderer;
        if (current == BEST) {
            current = ComputerCraft.monitorRenderer = MonitorRenderer.best();
        }
        return current;
    }

    private static MonitorRenderer best() {
        if (!GL.getCapabilities().OpenGL31) {
            ComputerCraft.log.warn("Texture buffers are not supported on your graphics card. Falling back to VBO monitor renderer.");
            return VBO;
        }
        if (shaderMod) {
            ComputerCraft.log.warn("Shader mod detected. Falling back to VBO monitor renderer.");
            return VBO;
        }
        return TBO;
    }

    static {
        shaderModIds = Arrays.asList("iris", "canvas", "optifabric");
        shaderMod = FabricLoader.getInstance().getAllMods().stream().map(modContainer -> modContainer.getMetadata().getId()).anyMatch(shaderModIds::contains);
        canvasModPresent = FabricLoader.getInstance().isModLoaded("canvas");
    }
}

