/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.common.ServerTerminal;
import dan200.computercraft.shared.peripheral.monitor.TileMonitor;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.concurrent.atomic.AtomicBoolean;

public class ServerMonitor
extends ServerTerminal {
    private final TileMonitor origin;
    private int textScale = 2;
    private final AtomicBoolean resized = new AtomicBoolean(false);
    private final AtomicBoolean changed = new AtomicBoolean(false);

    public ServerMonitor(boolean colour, TileMonitor origin) {
        super(colour);
        this.origin = origin;
    }

    public synchronized void rebuild() {
        Terminal oldTerm = this.getTerminal();
        int oldWidth = oldTerm == null ? -1 : oldTerm.getWidth();
        int oldHeight = oldTerm == null ? -1 : oldTerm.getHeight();
        double textScale = (double)this.textScale * 0.5;
        int termWidth = (int)Math.max((double)Math.round(((double)this.origin.getWidth() - 0.3125) / (textScale * 6.0 * 0.015625)), 1.0);
        int termHeight = (int)Math.max((double)Math.round(((double)this.origin.getHeight() - 0.3125) / (textScale * 9.0 * 0.015625)), 1.0);
        this.resize(termWidth, termHeight);
        if (oldWidth != termWidth || oldHeight != termHeight) {
            this.getTerminal().clear();
            this.resized.set(true);
            this.markChanged();
        }
    }

    @Override
    protected void markTerminalChanged() {
        super.markTerminalChanged();
        this.markChanged();
    }

    private void markChanged() {
        if (!this.changed.getAndSet(true)) {
            TickScheduler.schedule(this.origin);
        }
    }

    protected void clearChanged() {
        this.changed.set(false);
    }

    public int getTextScale() {
        return this.textScale;
    }

    public synchronized void setTextScale(int textScale) {
        if (this.textScale == textScale) {
            return;
        }
        this.textScale = textScale;
        this.rebuild();
    }

    public boolean pollResized() {
        return this.resized.getAndSet(false);
    }

    public boolean pollTerminalChanged() {
        this.update();
        return this.hasTerminalChanged();
    }
}

