/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.printer;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralTile;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.media.items.ItemPrintout;
import dan200.computercraft.shared.peripheral.printer.BlockPrinter;
import dan200.computercraft.shared.peripheral.printer.ContainerPrinter;
import dan200.computercraft.shared.peripheral.printer.PrinterPeripheral;
import dan200.computercraft.shared.util.ColourUtils;
import dan200.computercraft.shared.util.DefaultSidedInventory;
import dan200.computercraft.shared.util.WorldUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1262;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1273;
import net.minecraft.class_1275;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3908;
import net.minecraft.class_3965;

public final class TilePrinter
extends TileGeneric
implements IPeripheralTile,
DefaultSidedInventory,
class_1275,
class_3908 {
    private static final String NBT_NAME = "CustomName";
    private static final String NBT_PRINTING = "Printing";
    private static final String NBT_PAGE_TITLE = "PageTitle";
    static final int SLOTS = 13;
    private static final int[] BOTTOM_SLOTS = new int[]{7, 8, 9, 10, 11, 12};
    private static final int[] TOP_SLOTS = new int[]{1, 2, 3, 4, 5, 6};
    private static final int[] SIDE_SLOTS = new int[]{0};
    class_2561 customName;
    private class_1273 lockCode = class_1273.field_5817;
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)13, (Object)class_1799.field_8037);
    private PrinterPeripheral peripheral;
    private final Terminal page = new Terminal(25, 21);
    private String pageTitle = "";
    private boolean printing = false;

    public TilePrinter(class_2591<TilePrinter> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void destroy() {
        this.ejectContents();
    }

    @Override
    public boolean isUsable(class_1657 player) {
        return super.isUsable(player) && class_2624.method_17487((class_1657)player, (class_1273)this.lockCode, (class_2561)this.method_5476());
    }

    @Override
    @Nonnull
    public class_1269 onActivate(class_1657 player, class_1268 hand, class_3965 hit) {
        if (player.method_18276()) {
            return class_1269.field_5811;
        }
        if (!this.method_10997().field_9236 && this.isUsable(player)) {
            player.method_17355((class_3908)this);
        }
        return class_1269.field_5812;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_11014(@Nonnull class_2487 nbt) {
        super.method_11014(nbt);
        this.customName = nbt.method_10545(NBT_NAME) ? class_2561.class_2562.method_10877((String)nbt.method_10558(NBT_NAME)) : null;
        Terminal terminal = this.page;
        synchronized (terminal) {
            this.printing = nbt.method_10577(NBT_PRINTING);
            this.pageTitle = nbt.method_10558(NBT_PAGE_TITLE);
            this.page.readFromNBT(nbt);
        }
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.lockCode = class_1273.method_5473((class_2487)nbt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_11007(@Nonnull class_2487 nbt) {
        if (this.customName != null) {
            nbt.method_10582(NBT_NAME, class_2561.class_2562.method_10867((class_2561)this.customName));
        }
        Terminal terminal = this.page;
        synchronized (terminal) {
            nbt.method_10556(NBT_PRINTING, this.printing);
            nbt.method_10582(NBT_PAGE_TITLE, this.pageTitle);
            this.page.writeToNBT(nbt);
        }
        class_1262.method_5426((class_2487)nbt, this.inventory);
        this.lockCode.method_5474(nbt);
        super.method_11007(nbt);
    }

    boolean isPrinting() {
        return this.printing;
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        for (class_1799 stack : this.inventory) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    @Nonnull
    public class_1799 method_5441(int slot) {
        class_1799 result = (class_1799)this.inventory.get(slot);
        this.inventory.set(slot, (Object)class_1799.field_8037);
        this.method_5431();
        this.updateBlockState();
        return result;
    }

    @Nonnull
    public class_1799 method_5434(int slot, int count) {
        class_1799 stack = (class_1799)this.inventory.get(slot);
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        if (stack.method_7947() <= count) {
            this.method_5447(slot, class_1799.field_8037);
            return stack;
        }
        class_1799 part = stack.method_7971(count);
        if (((class_1799)this.inventory.get(slot)).method_7960()) {
            this.inventory.set(slot, (Object)class_1799.field_8037);
            this.updateBlockState();
        }
        this.method_5431();
        return part;
    }

    public void method_5447(int slot, @Nonnull class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
        this.method_5431();
        this.updateBlockState();
    }

    public void method_5448() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            this.inventory.set(i, (Object)class_1799.field_8037);
        }
        this.method_5431();
        this.updateBlockState();
    }

    @Override
    public boolean method_5437(int slot, @Nonnull class_1799 stack) {
        if (slot == 0) {
            return TilePrinter.isInk(stack);
        }
        if (slot >= TOP_SLOTS[0] && slot <= TOP_SLOTS[TOP_SLOTS.length - 1]) {
            return TilePrinter.isPaper(stack);
        }
        return false;
    }

    public boolean method_5443(@Nonnull class_1657 playerEntity) {
        return this.isUsable(playerEntity);
    }

    @Nonnull
    public int[] method_5494(@Nonnull class_2350 side) {
        switch (side) {
            case field_11033: {
                return BOTTOM_SLOTS;
            }
            case field_11036: {
                return TOP_SLOTS;
            }
        }
        return SIDE_SLOTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Terminal getCurrentPage() {
        Terminal terminal = this.page;
        synchronized (terminal) {
            return this.printing ? this.page : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean startNewPage() {
        Terminal terminal = this.page;
        synchronized (terminal) {
            if (!this.canInputPage()) {
                return false;
            }
            if (this.printing && !this.outputPage()) {
                return false;
            }
            return this.inputPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean endCurrentPage() {
        Terminal terminal = this.page;
        synchronized (terminal) {
            return this.printing && this.outputPage();
        }
    }

    int getInkLevel() {
        class_1799 inkStack = (class_1799)this.inventory.get(0);
        return TilePrinter.isInk(inkStack) ? inkStack.method_7947() : 0;
    }

    int getPaperLevel() {
        int count = 0;
        for (int i = 1; i < 7; ++i) {
            class_1799 paperStack = (class_1799)this.inventory.get(i);
            if (!TilePrinter.isPaper(paperStack)) continue;
            count += paperStack.method_7947();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPageTitle(String title) {
        Terminal terminal = this.page;
        synchronized (terminal) {
            if (this.printing) {
                this.pageTitle = title;
            }
        }
    }

    static boolean isInk(@Nonnull class_1799 stack) {
        return ColourUtils.getStackColour(stack) != null;
    }

    static boolean isPaper(@Nonnull class_1799 stack) {
        ItemPrintout printout;
        class_1792 item = stack.method_7909();
        return item == class_1802.field_8407 || item instanceof ItemPrintout && (printout = (ItemPrintout)item).getType() == ItemPrintout.Type.PAGE;
    }

    private boolean canInputPage() {
        class_1799 inkStack = (class_1799)this.inventory.get(0);
        return !inkStack.method_7960() && TilePrinter.isInk(inkStack) && this.getPaperLevel() > 0;
    }

    private boolean inputPage() {
        class_1799 inkStack = (class_1799)this.inventory.get(0);
        class_1767 dye = ColourUtils.getStackColour(inkStack);
        if (dye == null) {
            return false;
        }
        for (int i = 1; i < 7; ++i) {
            class_1799 paperStack = (class_1799)this.inventory.get(i);
            if (paperStack.method_7960() || !TilePrinter.isPaper(paperStack)) continue;
            this.page.setTextColour(dye.method_7789());
            this.page.clear();
            if (paperStack.method_7909() instanceof ItemPrintout) {
                this.pageTitle = ItemPrintout.getTitle(paperStack);
                String[] text = ItemPrintout.getText(paperStack);
                String[] textColour = ItemPrintout.getColours(paperStack);
                for (int y = 0; y < this.page.getHeight(); ++y) {
                    this.page.setLine(y, text[y], textColour[y], "");
                }
            } else {
                this.pageTitle = "";
            }
            this.page.setCursorPos(0, 0);
            inkStack.method_7934(1);
            if (inkStack.method_7960()) {
                this.inventory.set(0, (Object)class_1799.field_8037);
            }
            paperStack.method_7934(1);
            if (paperStack.method_7960()) {
                this.inventory.set(i, (Object)class_1799.field_8037);
                this.updateBlockState();
            }
            this.method_5431();
            this.printing = true;
            return true;
        }
        return false;
    }

    private boolean outputPage() {
        int height = this.page.getHeight();
        String[] lines = new String[height];
        String[] colours = new String[height];
        for (int i = 0; i < height; ++i) {
            lines[i] = this.page.getLine(i).toString();
            colours[i] = this.page.getTextColourLine(i).toString();
        }
        class_1799 stack = ItemPrintout.createSingleFromTitleAndText(this.pageTitle, lines, colours);
        for (int slot : BOTTOM_SLOTS) {
            if (!((class_1799)this.inventory.get(slot)).method_7960()) continue;
            this.method_5447(slot, stack);
            this.printing = false;
            return true;
        }
        return false;
    }

    private void ejectContents() {
        for (int i = 0; i < 13; ++i) {
            class_1799 stack = (class_1799)this.inventory.get(i);
            if (stack.method_7960()) continue;
            this.method_5447(i, class_1799.field_8037);
            WorldUtil.dropItemStack(stack, this.method_10997(), class_243.method_24954((class_2382)this.method_11016()).method_1031(0.5, 0.75, 0.5));
        }
    }

    private void updateBlockState() {
        class_1799 stack;
        int i;
        boolean top = false;
        boolean bottom = false;
        for (i = 1; i < 7; ++i) {
            stack = (class_1799)this.inventory.get(i);
            if (stack.method_7960() || !TilePrinter.isPaper(stack)) continue;
            top = true;
            break;
        }
        for (i = 7; i < 13; ++i) {
            stack = (class_1799)this.inventory.get(i);
            if (stack.method_7960() || !TilePrinter.isPaper(stack)) continue;
            bottom = true;
            break;
        }
        this.updateBlockState(top, bottom);
    }

    private void updateBlockState(boolean top, boolean bottom) {
        if (this.field_11865 || this.field_11863 == null) {
            return;
        }
        class_2680 state = this.method_11010();
        if ((Boolean)state.method_11654((class_2769)BlockPrinter.TOP) == top & (Boolean)state.method_11654((class_2769)BlockPrinter.BOTTOM) == bottom) {
            return;
        }
        this.method_10997().method_8501(this.method_11016(), (class_2680)((class_2680)state.method_11657((class_2769)BlockPrinter.TOP, (Comparable)Boolean.valueOf(top))).method_11657((class_2769)BlockPrinter.BOTTOM, (Comparable)Boolean.valueOf(bottom)));
    }

    @Override
    @Nonnull
    public IPeripheral getPeripheral(class_2350 side) {
        if (this.peripheral == null) {
            this.peripheral = new PrinterPeripheral(this);
        }
        return this.peripheral;
    }

    public boolean method_16914() {
        return this.customName != null;
    }

    @Nullable
    public class_2561 method_5797() {
        return this.customName;
    }

    @Nonnull
    public class_2561 method_5477() {
        return this.customName != null ? this.customName : class_2561.method_43471((String)this.method_11010().method_26204().method_9539());
    }

    @Nonnull
    public class_2561 method_5476() {
        return super.method_5476();
    }

    @Nonnull
    public class_1703 createMenu(int id, @Nonnull class_1661 inventory, @Nonnull class_1657 player) {
        return new ContainerPrinter(id, inventory, this);
    }
}

