/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.TurtlePermissions;
import dan200.computercraft.shared.turtle.core.MoveDirection;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;

public class TurtleMoveCommand
implements ITurtleCommand {
    private final MoveDirection direction;
    private static final class_238 EMPTY_BOX = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public TurtleMoveCommand(MoveDirection direction) {
        this.direction = direction;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        class_2350 direction = this.direction.toWorldDir(turtle);
        class_1937 oldWorld = turtle.getLevel();
        class_2338 oldPosition = turtle.getPosition();
        class_2338 newPosition = oldPosition.method_10093(direction);
        TurtlePlayer turtlePlayer = TurtlePlayer.getWithPosition(turtle, oldPosition, direction);
        TurtleCommandResult canEnterResult = TurtleMoveCommand.canEnter(turtlePlayer, oldWorld, newPosition);
        if (!canEnterResult.isSuccess()) {
            return canEnterResult;
        }
        class_2680 state = oldWorld.method_8320(newPosition);
        if (!(oldWorld.method_22347(newPosition) || WorldUtil.isLiquidBlock(oldWorld, newPosition) || state.method_26207().method_15800())) {
            return TurtleCommandResult.failure("Movement obstructed");
        }
        class_265 collision = state.method_26220((class_1922)oldWorld, oldPosition).method_1096((double)newPosition.method_10263(), (double)newPosition.method_10264(), (double)newPosition.method_10260());
        if (!oldWorld.method_8611(null, collision)) {
            if (!ComputerCraft.turtlesCanPush || this.direction == MoveDirection.UP || this.direction == MoveDirection.DOWN) {
                return TurtleCommandResult.failure("Movement obstructed");
            }
            List list = oldWorld.method_8390(class_1297.class, TurtleMoveCommand.getBox(collision), x -> x != null && x.method_5805() && x.field_23807);
            for (class_1297 entity : list) {
                class_238 pushedBB = entity.method_5829().method_989((double)direction.method_10148(), (double)direction.method_10164(), (double)direction.method_10165());
                if (oldWorld.method_8611(null, class_259.method_1078((class_238)pushedBB))) continue;
                return TurtleCommandResult.failure("Movement obstructed");
            }
        }
        if (turtle.isFuelNeeded() && turtle.getFuelLevel() < 1) {
            return TurtleCommandResult.failure("Out of fuel");
        }
        if (!turtle.teleportTo(oldWorld, newPosition)) {
            return TurtleCommandResult.failure("Movement failed");
        }
        turtle.consumeFuel(1);
        switch (this.direction) {
            default: {
                turtle.playAnimation(TurtleAnimation.MOVE_FORWARD);
                break;
            }
            case BACK: {
                turtle.playAnimation(TurtleAnimation.MOVE_BACK);
                break;
            }
            case UP: {
                turtle.playAnimation(TurtleAnimation.MOVE_UP);
                break;
            }
            case DOWN: {
                turtle.playAnimation(TurtleAnimation.MOVE_DOWN);
            }
        }
        return TurtleCommandResult.success();
    }

    private static TurtleCommandResult canEnter(TurtlePlayer turtlePlayer, class_1937 world, class_2338 position) {
        if (world.method_31606(position)) {
            return TurtleCommandResult.failure(position.method_10264() < 0 ? "Too low to move" : "Too high to move");
        }
        if (!world.method_24794(position)) {
            return TurtleCommandResult.failure("Cannot leave the world");
        }
        if (ComputerCraft.turtlesObeyBlockProtection && !TurtlePermissions.isBlockEnterable(world, position, (class_1657)turtlePlayer)) {
            return TurtleCommandResult.failure("Cannot enter protected area");
        }
        if (!world.method_8477(position)) {
            return TurtleCommandResult.failure("Cannot leave loaded world");
        }
        if (!world.method_8621().method_11952(position)) {
            return TurtleCommandResult.failure("Cannot pass the world border");
        }
        return TurtleCommandResult.success();
    }

    private static class_238 getBox(class_265 shape) {
        return shape.method_1110() ? EMPTY_BOX : shape.method_1107();
    }
}

