/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.TurtlePermissions;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.util.DropConsumer;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.ItemStorage;
import dan200.computercraft.shared.util.WorldUtil;
import javax.annotation.Nonnull;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1749;
import net.minecraft.class_1750;
import net.minecraft.class_1754;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1822;
import net.minecraft.class_1838;
import net.minecraft.class_1841;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import org.apache.commons.lang3.tuple.Pair;

public class TurtlePlaceCommand
implements ITurtleCommand {
    private final InteractDirection direction;
    private final Object[] extraArguments;

    public TurtlePlaceCommand(InteractDirection direction, Object[] arguments) {
        this.direction = direction;
        this.extraArguments = arguments;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        class_1799 stack = turtle.getInventory().method_5438(turtle.getSelectedSlot());
        if (stack.method_7960()) {
            return TurtleCommandResult.failure("No items to place");
        }
        class_2350 direction = this.direction.toWorldDir(turtle);
        class_2338 coordinates = turtle.getPosition().method_10093(direction);
        class_2338 playerPosition = turtle.getPosition().method_10093(direction);
        TurtlePlayer turtlePlayer = TurtlePlayer.getWithPosition(turtle, playerPosition, direction);
        turtlePlayer.loadInventory(turtle);
        ErrorMessage message = new ErrorMessage();
        boolean result = TurtlePlaceCommand.deploy(stack, turtle, turtlePlayer, direction, this.extraArguments, message);
        turtlePlayer.unloadInventory(turtle);
        if (result) {
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        if (message.message != null) {
            return TurtleCommandResult.failure(message.message);
        }
        return TurtleCommandResult.failure(stack.method_7909() instanceof class_1747 ? "Cannot place block here" : "Cannot place item here");
    }

    public static boolean deployCopiedItem(@Nonnull class_1799 stack, ITurtleAccess turtle, class_2350 direction, Object[] extraArguments, ErrorMessage outErrorMessage) {
        class_2338 playerPosition = turtle.getPosition().method_10093(direction);
        TurtlePlayer turtlePlayer = TurtlePlayer.getWithPosition(turtle, playerPosition, direction);
        turtlePlayer.loadInventory(stack);
        boolean result = TurtlePlaceCommand.deploy(stack, turtle, turtlePlayer, direction, extraArguments, outErrorMessage);
        turtlePlayer.method_31548().method_5448();
        return result;
    }

    private static boolean deploy(@Nonnull class_1799 stack, ITurtleAccess turtle, TurtlePlayer turtlePlayer, class_2350 direction, Object[] extraArguments, ErrorMessage outErrorMessage) {
        if (TurtlePlaceCommand.deployOnEntity(stack, turtle, turtlePlayer)) {
            return true;
        }
        class_2338 position = turtle.getPosition();
        class_2338 newPosition = position.method_10093(direction);
        return TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, newPosition, direction.method_10153(), extraArguments, true, outErrorMessage) || TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, newPosition.method_10093(direction), direction.method_10153(), extraArguments, false, outErrorMessage) || direction.method_10166() != class_2350.class_2351.field_11052 && TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, newPosition.method_10074(), class_2350.field_11036, extraArguments, false, outErrorMessage) || TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, position, direction, extraArguments, false, outErrorMessage);
    }

    private static boolean deployOnEntity(@Nonnull class_1799 stack, ITurtleAccess turtle, TurtlePlayer turtlePlayer) {
        class_243 rayDir;
        class_1937 world = turtle.getLevel();
        class_2338 position = turtle.getPosition();
        class_243 turtlePos = turtlePlayer.method_19538();
        Pair<class_1297, class_243> hit = WorldUtil.rayTraceEntities(world, turtlePos, rayDir = turtlePlayer.method_5828(1.0f), 1.5);
        if (hit == null) {
            return false;
        }
        class_1297 hitEntity = (class_1297)hit.getKey();
        class_243 hitPos = (class_243)hit.getValue();
        ItemStorage itemHandler = ItemStorage.wrap((class_1263)turtlePlayer.method_31548());
        DropConsumer.set(hitEntity, drop -> InventoryUtil.storeItems(drop, itemHandler, 1));
        boolean placed = TurtlePlaceCommand.doDeployOnEntity(stack, turtlePlayer, hitEntity, hitPos);
        DropConsumer.clearAndDrop(world, position, turtle.getDirection().method_10153());
        return placed;
    }

    private static boolean doDeployOnEntity(@Nonnull class_1799 stack, TurtlePlayer turtlePlayer, @Nonnull class_1297 hitEntity, @Nonnull class_243 hitPos) {
        class_1269 interactAt = hitEntity.method_5664((class_1657)turtlePlayer, hitPos, class_1268.field_5808);
        if (interactAt.method_23665()) {
            return true;
        }
        if (hitEntity.method_5688((class_1657)turtlePlayer, class_1268.field_5808).method_23665()) {
            return true;
        }
        if (hitEntity instanceof class_1309) {
            class_1309 hitLiving = (class_1309)hitEntity;
            return stack.method_7920((class_1657)turtlePlayer, hitLiving, class_1268.field_5808).method_23665();
        }
        return false;
    }

    private static boolean canDeployOnBlock(@Nonnull class_1750 context, ITurtleAccess turtle, TurtlePlayer player, class_2338 position, class_2350 side, boolean allowReplaceable, ErrorMessage outErrorMessage) {
        class_1937 world = turtle.getLevel();
        if (!world.method_24794(position) || world.method_22347(position) || context.method_8041().method_7909() instanceof class_1747 && WorldUtil.isLiquidBlock(world, position)) {
            return false;
        }
        class_2680 state = world.method_8320(position);
        boolean replaceable = state.method_26166(context);
        if (!allowReplaceable && replaceable) {
            return false;
        }
        if (ComputerCraft.turtlesObeyBlockProtection) {
            boolean editable;
            boolean bl = editable = replaceable ? TurtlePermissions.isBlockEditable(world, position, (class_1657)player) : TurtlePermissions.isBlockEditable(world, position.method_10093(side), (class_1657)player);
            if (!editable) {
                if (outErrorMessage != null) {
                    outErrorMessage.message = "Cannot place in protected area";
                }
                return false;
            }
        }
        return true;
    }

    private static boolean deployOnBlock(@Nonnull class_1799 stack, ITurtleAccess turtle, TurtlePlayer turtlePlayer, class_2338 position, class_2350 side, Object[] extraArguments, boolean allowReplace, ErrorMessage outErrorMessage) {
        Object object;
        class_3965 hit;
        class_1838 context;
        class_2350 playerDir = side.method_10153();
        class_2338 playerPosition = position.method_10093(side);
        turtlePlayer.setPosition(turtle, playerPosition, playerDir);
        float hitX = 0.5f + (float)side.method_10148() * 0.5f;
        float hitY = 0.5f + (float)side.method_10164() * 0.5f;
        float hitZ = 0.5f + (float)side.method_10165() * 0.5f;
        if (Math.abs(hitY - 0.5f) < 0.01f) {
            hitY = 0.45f;
        }
        if (!TurtlePlaceCommand.canDeployOnBlock(new class_1750(context = new class_1838((class_1657)turtlePlayer, class_1268.field_5808, hit = new class_3965(new class_243((double)hitX, (double)hitY, (double)hitZ), side, position, false))), turtle, turtlePlayer, position, side, allowReplace, outErrorMessage)) {
            return false;
        }
        class_1792 item = stack.method_7909();
        class_2586 existingTile = turtle.getLevel().method_8321(position);
        boolean placed = TurtlePlaceCommand.doDeployOnBlock(stack, turtlePlayer, position, context, hit).method_23665();
        if (placed && item instanceof class_1822 && extraArguments != null && extraArguments.length >= 1 && (object = extraArguments[0]) instanceof String) {
            String message = (String)object;
            class_1937 world = turtle.getLevel();
            class_2586 tile = world.method_8321(position);
            if (tile == null || tile == existingTile) {
                tile = world.method_8321(position.method_10093(side));
            }
            if (tile instanceof class_2625) {
                TurtlePlaceCommand.setSignText(world, tile, message);
            }
        }
        return placed;
    }

    private static class_1269 doDeployOnBlock(@Nonnull class_1799 stack, TurtlePlayer turtlePlayer, class_2338 position, class_1838 context, class_3965 hit) {
        class_1271 result;
        class_1269 useResult = stack.method_7981(context);
        if (useResult != class_1269.field_5811) {
            return useResult;
        }
        class_1792 item = stack.method_7909();
        if ((item instanceof class_1755 || item instanceof class_1749 || item instanceof class_1841 || item instanceof class_1754) && (result = stack.method_7913(context.method_8045(), (class_1657)turtlePlayer, class_1268.field_5808)).method_5467().method_23665() && !class_1799.method_7973((class_1799)stack, (class_1799)((class_1799)result.method_5466()))) {
            turtlePlayer.method_6122(class_1268.field_5808, (class_1799)result.method_5466());
            return result.method_5467();
        }
        return class_1269.field_5811;
    }

    private static void setSignText(class_1937 world, class_2586 tile, String message) {
        class_2625 signTile = (class_2625)tile;
        String[] split = message.split("\n");
        int firstLine = split.length <= 2 ? 1 : 0;
        for (int i = 0; i < 4; ++i) {
            if (i >= firstLine && i < firstLine + split.length) {
                String line = split[i - firstLine];
                signTile.method_11299(i, (class_2561)(line.length() > 15 ? class_2561.method_43470((String)line.substring(0, 15)) : class_2561.method_43470((String)line)));
                continue;
            }
            signTile.method_11299(i, (class_2561)class_2561.method_43470((String)""));
        }
        signTile.method_5431();
        world.method_8413(tile.method_11016(), tile.method_11010(), tile.method_11010(), 3);
    }

    private static class ErrorMessage {
        String message;

        private ErrorMessage() {
        }
    }
}

