/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.shared.util.WorldUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;

public final class DropConsumer {
    private static Function<class_1799, class_1799> dropConsumer;
    private static List<class_1799> remainingDrops;
    private static class_1937 dropWorld;
    private static class_2338 dropPos;
    private static class_238 dropBounds;
    private static class_1297 dropEntity;

    private DropConsumer() {
    }

    public static void set(class_1297 entity, Function<class_1799, class_1799> consumer) {
        dropConsumer = consumer;
        remainingDrops = new ArrayList<class_1799>();
        dropEntity = entity;
        dropWorld = entity.field_6002;
        dropPos = null;
        dropBounds = new class_238(entity.method_24515()).method_1009(2.0, 2.0, 2.0);
    }

    public static void set(class_1937 world, class_2338 pos, Function<class_1799, class_1799> consumer) {
        dropConsumer = consumer;
        remainingDrops = new ArrayList<class_1799>(2);
        dropEntity = null;
        dropWorld = world;
        dropBounds = new class_238(pos).method_1009(2.0, 2.0, 2.0);
    }

    public static List<class_1799> clear() {
        List<class_1799> remainingStacks = remainingDrops;
        dropConsumer = null;
        remainingDrops = null;
        dropEntity = null;
        dropWorld = null;
        dropBounds = null;
        return remainingStacks;
    }

    public static void clearAndDrop(class_1937 world, class_2338 pos, class_2350 direction) {
        List<class_1799> remainingDrops = DropConsumer.clear();
        for (class_1799 remaining : remainingDrops) {
            WorldUtil.dropItemStack(remaining, world, pos, direction);
        }
    }

    private static void handleDrops(class_1799 stack) {
        class_1799 remaining = dropConsumer.apply(stack);
        if (!remaining.method_7960()) {
            remainingDrops.add(remaining);
        }
    }

    public static boolean onEntitySpawn(class_1297 entity) {
        if (dropWorld != null && dropWorld == entity.method_5770() && entity instanceof class_1542 && dropBounds.method_1006(entity.method_19538())) {
            DropConsumer.handleDrops(((class_1542)entity).method_6983());
            return true;
        }
        return false;
    }

    public static boolean onLivingDrops(class_1297 entity, class_1799 stack) {
        if (dropEntity == null || entity != dropEntity) {
            return false;
        }
        DropConsumer.handleDrops(stack);
        return true;
    }

    public static boolean onHarvestDrops(class_1937 world, class_2338 pos, class_1799 stack) {
        if (dropWorld != null && dropWorld == world && dropPos != null && dropPos.equals((Object)pos)) {
            DropConsumer.handleDrops(stack);
            return true;
        }
        return false;
    }
}

