/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_fabric.functions;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.natamus.collective_common_fabric.data.Constants;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class JsonFunctions {
    public static HashMap<String, String> JsonStringToHashMap(String jsonstring) {
        return (HashMap)new Gson().fromJson(jsonstring, new TypeToken<HashMap<String, String>>(){}.getType());
    }

    public static String HashMapToJsonString(HashMap<String, String> map) {
        return new Gson().toJson(map);
    }

    public static List<String> getStringListFromJsonFile(String folder, String fileName, String key) {
        if (!((String)(folder = ((String)folder).replace("/", File.separator).replace("\\", File.separator).strip())).endsWith(File.separator)) {
            folder = (String)folder + File.separator;
        }
        ArrayList<String> stringList = new ArrayList<String>();
        File file = new File((String)folder + fileName);
        if (!file.isFile()) {
            return stringList;
        }
        JsonElement jsonElement = null;
        try {
            jsonElement = JsonFunctions.getJsonElementFromFile((String)folder, fileName);
        }
        catch (IOException ex) {
            Constants.LOG.warn("[Collective] IOException while trying to parse JSON file: " + (String)folder + fileName);
            return stringList;
        }
        if (jsonElement == null) {
            return stringList;
        }
        if (!jsonElement.isJsonObject()) {
            return stringList;
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        JsonArray jsonArray = jsonObject.getAsJsonArray(key);
        if (jsonArray == null) {
            Constants.LOG.warn("[Collective] Unable to find JSON member with key: " + key);
            return stringList;
        }
        for (JsonElement jE : JsonFunctions.jsonArrayToList(jsonArray)) {
            try {
                String stringElement = jE.getAsString();
                stringList.add(stringElement);
            }
            catch (Exception ex) {
                Constants.LOG.warn("[Collective] Unable to parse '" + jE.toString() + "' as a String Element.");
            }
        }
        return stringList;
    }

    public static JsonElement getJsonElementFromFile(String folder, String fileName) throws IOException {
        return JsonParser.parseReader((Reader)new FileReader(folder + fileName));
    }

    public static List<JsonElement> jsonArrayToList(JsonArray jsonArray) {
        ArrayList<JsonElement> jsonElementList = new ArrayList<JsonElement>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                jsonElementList.add(jsonArray.get(i));
            }
        }
        return jsonElementList;
    }
}

