/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.integration;

import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.api.util.ConfigScreenHelper;
import com.mrcrayfish.configured.client.ClientHandler;
import com.mrcrayfish.configured.impl.simple.SimpleConfigManager;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.minecraft.class_151;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;

public final class CatalogueConfigFactory {
    public static class_437 createConfigScreen(class_437 currentScreen, ModContainer container) {
        HashMap<ConfigType, Set<IModConfig>> modConfigMap = new HashMap<ConfigType, Set<IModConfig>>();
        Set<IModConfig> configs = ClientHandler.getProviders().stream().flatMap(provider -> provider.getConfigurationsForMod(container).stream()).collect(Collectors.toSet());
        configs.forEach(entry -> modConfigMap.computeIfAbsent(entry.getType(), type -> new LinkedHashSet()).add(entry));
        class_2960 backgroundTexture = CatalogueConfigFactory.getBackgroundTexture(container);
        return ConfigScreenHelper.createSelectionScreen(currentScreen, (class_2561)class_2561.method_43470((String)container.getMetadata().getName()), modConfigMap, backgroundTexture);
    }

    public static Map<String, BiFunction<class_437, ModContainer, class_437>> createConfigProvider() {
        HashMap providers = new HashMap();
        SimpleConfigManager.getInstance().getConfigs().stream().map(SimpleConfigManager.SimpleConfigImpl::getModId).distinct().forEach(s -> {
            if (!s.equals("configured")) {
                providers.put(s, CatalogueConfigFactory::createConfigScreen);
            }
        });
        return ImmutableMap.copyOf(providers);
    }

    private static class_2960 getBackgroundTexture(ModContainer container) {
        CustomValue.CvObject configuredObj;
        CustomValue backgroundValue;
        CustomValue value = container.getMetadata().getCustomValue("configured");
        if (value != null && value.getType() == CustomValue.CvType.OBJECT && (backgroundValue = (configuredObj = value.getAsObject()).get("background")) != null && backgroundValue.getType() == CustomValue.CvType.STRING) {
            try {
                return new class_2960(backgroundValue.getAsString());
            }
            catch (class_151 var2) {
                return class_437.field_22735;
            }
        }
        return class_437.field_22735;
    }
}

