/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.simibubi.create.Create;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedSpout;
import com.simibubi.create.content.fluids.potion.PotionFluidHandler;
import com.simibubi.create.content.fluids.transfer.FillingRecipe;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import io.github.fabricators_of_create.porting_lib.transfer.MutableContainerItemContext;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.Collection;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.fabric.constants.FabricTypes;
import mezz.jei.api.fabric.ingredients.fluids.IJeiFluidIngredient;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IIngredientManager;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_4587;

@ParametersAreNonnullByDefault
public class SpoutCategory
extends CreateRecipeCategory<FillingRecipe> {
    private final AnimatedSpout spout = new AnimatedSpout();

    public SpoutCategory(CreateRecipeCategory.Info<FillingRecipe> info) {
        super(info);
    }

    public static void consumeRecipes(Consumer<FillingRecipe> consumer, IIngredientManager ingredientManager) {
        Collection fluidStacks = ingredientManager.getAllIngredients((IIngredientType)FabricTypes.FLUID_STACK);
        for (class_1799 stack : ingredientManager.getAllIngredients((IIngredientType)VanillaTypes.ITEM_STACK)) {
            if (stack.method_7909() instanceof class_1812) {
                FluidStack fluidFromPotionItem = PotionFluidHandler.getFluidFromPotionItem(stack);
                class_1856 bottle = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8469});
                consumer.accept(new ProcessingRecipeBuilder<FillingRecipe>(FillingRecipe::new, Create.asResource("potions")).withItemIngredients(bottle).withFluidIngredients(FluidIngredient.fromFluidStack(fluidFromPotionItem)).withSingleItemOutput(stack).build());
                continue;
            }
            ContainerItemContext testCtx = ContainerItemContext.withConstant((class_1799)stack);
            Storage testStorage = (Storage)testCtx.find(FluidStorage.ITEM);
            if (testStorage == null) continue;
            for (IJeiFluidIngredient ingredient : fluidStacks) {
                MutableContainerItemContext ctx;
                Storage storage;
                FluidStack fluidStack = SpoutCategory.fromJei(ingredient);
                class_1799 copy = stack.method_7972();
                if (!GenericItemFilling.isFluidHandlerValid(copy, (Storage<FluidVariant>)(storage = (Storage)(ctx = new MutableContainerItemContext(copy)).find(FluidStorage.ITEM)))) continue;
                FluidStack fluidCopy = fluidStack.copy();
                fluidCopy.setAmount(81000L);
                TransferUtil.insertFluid((Storage)storage, (FluidStack)fluidCopy);
                ItemVariant container = ctx.getItemVariant();
                if (container.matches(copy) || container.isBlank()) continue;
                class_1856 bucket = class_1856.method_8101((class_1799[])new class_1799[]{stack});
                class_2960 itemName = RegisteredObjects.getKeyOrThrow(stack.method_7909());
                class_2960 fluidName = RegisteredObjects.getKeyOrThrow(fluidCopy.getFluid());
                consumer.accept(new ProcessingRecipeBuilder<FillingRecipe>(FillingRecipe::new, Create.asResource("fill_" + itemName.method_12836() + "_" + itemName.method_12832() + "_with_" + fluidName.method_12836() + "_" + fluidName.method_12832())).withItemIngredients(bucket).withFluidIngredients(FluidIngredient.fromFluidStack(fluidCopy)).withSingleItemOutput(container.toStack(ItemHelper.truncateLong(ctx.getAmount()))).build());
            }
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FillingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 27, 51).setBackground(SpoutCategory.getRenderedSlot(), -1, -1).addIngredients((class_1856)recipe.method_8117().get(0));
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 27, 32).setBackground(SpoutCategory.getRenderedSlot(), -1, -1).addIngredients((IIngredientType)FabricTypes.FLUID_STACK, SpoutCategory.toJei(SpoutCategory.withImprovedVisibility(recipe.getRequiredFluid().getMatchingFluidStacks())))).addTooltipCallback(SpoutCategory.addFluidTooltip(recipe.getRequiredFluid().getRequiredAmount()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 132, 51).setBackground(SpoutCategory.getRenderedSlot(), -1, -1).addItemStack(recipe.method_8110());
    }

    public void draw(FillingRecipe recipe, IRecipeSlotsView iRecipeSlotsView, class_4587 matrixStack, double mouseX, double mouseY) {
        AllGuiTextures.JEI_SHADOW.render(matrixStack, 62, 57);
        AllGuiTextures.JEI_DOWN_ARROW.render(matrixStack, 126, 29);
        this.spout.withFluids(recipe.getRequiredFluid().getMatchingFluidStacks()).draw(matrixStack, this.getBackground().getWidth() / 2 - 13, 22);
    }
}

