/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.rei.category;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.Create;
import com.simibubi.create.compat.rei.category.CreateRecipeCategory;
import com.simibubi.create.compat.rei.category.animations.AnimatedItemDrain;
import com.simibubi.create.compat.rei.display.CreateDisplay;
import com.simibubi.create.content.fluids.potion.PotionFluidHandler;
import com.simibubi.create.content.fluids.transfer.EmptyingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.item.ItemHelper;
import dev.architectury.fluid.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.MutableContainerItemContext;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4587;

public class ItemDrainCategory
extends CreateRecipeCategory<EmptyingRecipe> {
    private final AnimatedItemDrain drain = new AnimatedItemDrain();

    public ItemDrainCategory(CreateRecipeCategory.Info<EmptyingRecipe> info) {
        super(info);
    }

    public static void consumeRecipes(Consumer<EmptyingRecipe> consumer) {
        EntryRegistry.getInstance().getEntryStacks().filter(stack -> Objects.equals(stack.getType(), VanillaEntryTypes.ITEM)).map(EntryStack::cast).collect(Collectors.toList()).stream().forEach(entryStack -> {
            class_1799 stack = (class_1799)entryStack.getValue();
            class_1792 item = stack.method_7909();
            if (item == class_1802.field_8574 || item == class_1802.field_8436 || item == class_1802.field_8150) {
                io.github.fabricators_of_create.porting_lib.util.FluidStack fluidFromPotionItem = PotionFluidHandler.getFluidFromPotionItem(stack);
                class_1856 potion = class_1856.method_8101((class_1799[])new class_1799[]{stack});
                consumer.accept(new ProcessingRecipeBuilder<EmptyingRecipe>(EmptyingRecipe::new, Create.asResource("potions")).withItemIngredients(potion).withFluidOutputs(fluidFromPotionItem).withSingleItemOutput(new class_1799((class_1935)class_1802.field_8469)).build());
                return;
            }
            class_1799 copy = stack.method_7972();
            MutableContainerItemContext ctx = new MutableContainerItemContext(copy);
            Storage handler = (Storage)ctx.find(FluidStorage.ITEM);
            if (handler == null) {
                return;
            }
            io.github.fabricators_of_create.porting_lib.util.FluidStack extracted = TransferUtil.extractAnyFluid((Storage)handler, (long)81000L);
            class_1799 result = ctx.getItemVariant().toStack(ItemHelper.truncateLong(ctx.getAmount()));
            if (extracted.isEmpty()) {
                return;
            }
            if (result.method_7960()) {
                return;
            }
            class_1856 ingredient = class_1856.method_8101((class_1799[])new class_1799[]{stack});
            class_2960 itemName = class_2378.field_11142.method_10221((Object)stack.method_7909());
            class_2960 fluidName = class_2378.field_11154.method_10221((Object)extracted.getFluid());
            consumer.accept(new ProcessingRecipeBuilder<EmptyingRecipe>(EmptyingRecipe::new, Create.asResource("empty_" + itemName.method_12836() + "_" + itemName.method_12832() + "_of_" + fluidName.method_12836() + "_" + fluidName.method_12832())).withItemIngredients(ingredient).withFluidOutputs(extracted).withSingleItemOutput(result).build());
        });
    }

    @Override
    public void addWidgets(CreateDisplay<EmptyingRecipe> display, List<Widget> ingredients, Point origin) {
        io.github.fabricators_of_create.porting_lib.util.FluidStack fluidOutput = display.getRecipe().getResultingFluid();
        List<class_1799> matchingIngredients = Arrays.asList(((class_1856)display.getRecipe().method_8117().get(0)).method_8105());
        Slot fluidSlot = ItemDrainCategory.basicSlot(origin.x + 132, origin.y + 8).markOutput().entries((Collection)EntryIngredients.of((FluidStack)CreateRecipeCategory.convertToREIFluid(fluidOutput)));
        CreateRecipeCategory.setFluidRenderRatio(fluidSlot);
        ingredients.add((Widget)fluidSlot);
        ingredients.add((Widget)ItemDrainCategory.basicSlot(origin.x + 27, origin.y + 8).markOutput().entries((Collection)EntryIngredients.ofItemStacks(matchingIngredients)));
        ingredients.add((Widget)ItemDrainCategory.basicSlot(origin.x + 132, origin.y + 27).markInput().entries((Collection)display.getOutputEntries().get(0)));
        ItemDrainCategory.addFluidTooltip(ingredients, Collections.emptyList(), (List<io.github.fabricators_of_create.porting_lib.util.FluidStack>)ImmutableList.of((Object)fluidOutput));
    }

    @Override
    public void draw(EmptyingRecipe recipe, class_4587 matrixStack, double mouseX, double mouseY) {
        AllGuiTextures.JEI_SLOT.render(matrixStack, 131, 7);
        AllGuiTextures.JEI_SLOT.render(matrixStack, 26, 7);
        ItemDrainCategory.getRenderedSlot(recipe, 0).render(matrixStack, 131, 26);
        AllGuiTextures.JEI_SHADOW.render(matrixStack, 62, 37);
        AllGuiTextures.JEI_DOWN_ARROW.render(matrixStack, 73, 4);
        this.drain.withFluid(recipe.getResultingFluid()).draw(matrixStack, this.getDisplayWidth(null) / 2 - 13, 40);
    }
}

