/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.bell;

import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.content.equipment.bell.BasicParticleData;
import com.simibubi.create.content.equipment.bell.CustomRotationParticle;
import com.simibubi.create.content.equipment.bell.SoulPulseEffect;
import io.github.fabricators_of_create.porting_lib.util.ParticleHelper;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;

public class SoulParticle
extends CustomRotationParticle {
    private final class_4002 animatedSprite;
    protected int startTicks;
    protected int endTicks;
    protected int numLoops;
    protected int firstStartFrame = 0;
    protected int startFrames = 17;
    protected int firstLoopFrame = 17;
    protected int loopFrames = 16;
    protected int firstEndFrame = 33;
    protected int endFrames = 20;
    protected AnimationStage animationStage;
    protected int totalFrames = 53;
    protected int ticksPerFrame = 2;
    protected boolean isPerimeter = false;
    protected boolean isExpandingPerimeter = false;
    protected boolean isVisible = true;
    protected int perimeterFrames = 8;

    public SoulParticle(class_638 worldIn, double x, double y, double z, double vx, double vy, double vz, class_4002 spriteSet, class_2394 data) {
        super(worldIn, x, y, z, spriteSet, 0.0f);
        this.animatedSprite = spriteSet;
        this.field_17867 = 0.5f;
        this.method_3080(this.field_17867, this.field_17867);
        this.loopLength = this.loopFrames + (int)(this.field_3840.method_43057() * 5.0f - 4.0f);
        this.startTicks = this.startFrames + (int)(this.field_3840.method_43057() * 5.0f - 4.0f);
        this.endTicks = this.endFrames + (int)(this.field_3840.method_43057() * 5.0f - 4.0f);
        this.numLoops = (int)(1.0f + this.field_3840.method_43057() * 2.0f);
        this.setFrame(0);
        ParticleHelper.setStoppedByCollision((class_703)this, (boolean)true);
        this.mirror = this.field_3840.method_43056();
        this.isPerimeter = data instanceof PerimeterData;
        this.isExpandingPerimeter = data instanceof ExpandingPerimeterData;
        AnimationStage animationStage = this.animationStage = !this.isPerimeter ? new StartAnimation(this) : new PerimeterAnimation(this);
        if (this.isPerimeter) {
            this.field_3838 = y -= 0.4921875;
            this.totalFrames = this.perimeterFrames;
            this.isVisible = false;
        }
    }

    public void method_3070() {
        this.animationStage.tick();
        this.animationStage = this.animationStage.getNext();
        class_2338 pos = new class_2338(this.field_3874, this.field_3854, this.field_3871);
        if (this.animationStage == null) {
            this.method_3085();
        }
        if (!SoulPulseEffect.isDark((class_1937)this.field_3851, pos)) {
            this.isVisible = true;
            if (!this.isPerimeter) {
                this.method_3085();
            }
        } else if (this.isPerimeter) {
            this.isVisible = false;
        }
    }

    @Override
    public void method_3074(class_4588 builder, class_4184 camera, float partialTicks) {
        if (!this.isVisible) {
            return;
        }
        super.method_3074(builder, camera, partialTicks);
    }

    public void setFrame(int frame) {
        if (frame >= 0 && frame < this.totalFrames) {
            this.method_18141(this.animatedSprite.method_18138(frame, this.totalFrames));
        }
    }

    @Override
    public class_1158 getCustomRotation(class_4184 camera, float partialTicks) {
        if (this.isPerimeter) {
            return class_1160.field_20703.method_23214(90.0f);
        }
        return new class_1158(0.0f, -camera.method_19330(), 0.0f, true);
    }

    public static class PerimeterData
    extends BasicParticleData<SoulParticle> {
        @Override
        public BasicParticleData.IBasicParticleFactory<SoulParticle> getBasicFactory() {
            return (worldIn, x, y, z, vx, vy, vz, spriteSet) -> new SoulParticle(worldIn, x, y, z, vx, vy, vz, spriteSet, this);
        }

        public class_2396<?> method_10295() {
            return AllParticleTypes.SOUL_PERIMETER.get();
        }
    }

    public static class ExpandingPerimeterData
    extends PerimeterData {
        @Override
        public class_2396<?> method_10295() {
            return AllParticleTypes.SOUL_EXPANDING_PERIMETER.get();
        }
    }

    public static class StartAnimation
    extends AnimationStage {
        public StartAnimation(SoulParticle particle) {
            super(particle);
        }

        @Override
        public void tick() {
            super.tick();
            this.particle.setFrame(this.particle.firstStartFrame + (int)(this.getAnimAge() / (float)this.particle.startTicks * (float)this.particle.startFrames));
        }

        @Override
        public AnimationStage getNext() {
            if (this.animAge < this.particle.startTicks) {
                return this;
            }
            return new LoopAnimation(this.particle);
        }
    }

    public static class PerimeterAnimation
    extends AnimationStage {
        public PerimeterAnimation(SoulParticle particle) {
            super(particle);
        }

        @Override
        public void tick() {
            super.tick();
            this.particle.setFrame((int)this.getAnimAge() % this.particle.perimeterFrames);
        }

        @Override
        public AnimationStage getNext() {
            if (this.animAge < (this.particle.isExpandingPerimeter ? 8 : this.particle.startTicks + this.particle.endTicks + this.particle.numLoops * this.particle.loopLength)) {
                return this;
            }
            return null;
        }
    }

    public static abstract class AnimationStage {
        protected final SoulParticle particle;
        protected int ticks;
        protected int animAge;

        public AnimationStage(SoulParticle particle) {
            this.particle = particle;
        }

        public void tick() {
            ++this.ticks;
            if (this.ticks % this.particle.ticksPerFrame == 0) {
                ++this.animAge;
            }
        }

        public float getAnimAge() {
            return this.animAge;
        }

        public abstract AnimationStage getNext();
    }

    public static class EndAnimation
    extends AnimationStage {
        public EndAnimation(SoulParticle particle) {
            super(particle);
        }

        @Override
        public void tick() {
            super.tick();
            this.particle.setFrame(this.particle.firstEndFrame + (int)(this.getAnimAge() / (float)this.particle.endTicks * (float)this.particle.endFrames));
        }

        @Override
        public AnimationStage getNext() {
            if (this.animAge < this.particle.endTicks) {
                return this;
            }
            return null;
        }
    }

    public static class LoopAnimation
    extends AnimationStage {
        int loops;

        public LoopAnimation(SoulParticle particle) {
            super(particle);
        }

        @Override
        public void tick() {
            super.tick();
            int loopTick = this.getLoopTick();
            if (loopTick == 0) {
                ++this.loops;
            }
            this.particle.setFrame(this.particle.firstLoopFrame + loopTick);
        }

        private int getLoopTick() {
            return this.animAge % this.particle.loopFrames;
        }

        @Override
        public AnimationStage getNext() {
            if (this.loops <= this.particle.numLoops) {
                return this;
            }
            return new EndAnimation(this.particle);
        }
    }

    public static class Data
    extends BasicParticleData<SoulParticle> {
        @Override
        public BasicParticleData.IBasicParticleFactory<SoulParticle> getBasicFactory() {
            return (worldIn, x, y, z, vx, vy, vz, spriteSet) -> new SoulParticle(worldIn, x, y, z, vx, vy, vz, spriteSet, this);
        }

        public class_2396<?> method_10295() {
            return AllParticleTypes.SOUL.get();
        }
    }
}

