/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.client.tools;

import com.simibubi.create.AllKeys;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.schematics.client.SchematicHandler;
import com.simibubi.create.content.schematics.client.SchematicTransformation;
import com.simibubi.create.content.schematics.client.tools.ISchematicTool;
import com.simibubi.create.foundation.outliner.AABBOutline;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.RaycastHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_746;

public abstract class SchematicToolBase
implements ISchematicTool {
    protected SchematicHandler schematicHandler;
    protected class_2338 selectedPos;
    protected class_243 chasingSelectedPos;
    protected class_243 lastChasingSelectedPos;
    protected boolean selectIgnoreBlocks;
    protected int selectionRange;
    protected boolean schematicSelected;
    protected boolean renderSelectedFace;
    protected class_2350 selectedFace;
    protected final List<String> mirrors = Arrays.asList("none", "leftRight", "frontBack");
    protected final List<String> rotations = Arrays.asList("none", "cw90", "cw180", "cw270");

    @Override
    public void init() {
        this.schematicHandler = CreateClient.SCHEMATIC_HANDLER;
        this.selectedPos = null;
        this.selectedFace = null;
        this.schematicSelected = false;
        this.chasingSelectedPos = class_243.field_1353;
        this.lastChasingSelectedPos = class_243.field_1353;
    }

    @Override
    public void updateSelection() {
        this.updateTargetPos();
        if (this.selectedPos == null) {
            return;
        }
        this.lastChasingSelectedPos = this.chasingSelectedPos;
        class_243 target = class_243.method_24954((class_2382)this.selectedPos);
        if (target.method_1022(this.chasingSelectedPos) < 0.001953125) {
            this.chasingSelectedPos = target;
            return;
        }
        this.chasingSelectedPos = this.chasingSelectedPos.method_1019(target.method_1020(this.chasingSelectedPos).method_1021(0.5));
    }

    public void updateTargetPos() {
        boolean snap;
        class_746 player = class_310.method_1551().field_1724;
        if (this.schematicHandler.isDeployed()) {
            class_243 end;
            SchematicTransformation transformation = this.schematicHandler.getTransformation();
            class_238 localBounds = this.schematicHandler.getBounds();
            class_243 traceOrigin = RaycastHelper.getTraceOrigin((class_1657)player);
            class_243 start = transformation.toLocalSpace(traceOrigin);
            RaycastHelper.PredicateTraceResult result = RaycastHelper.rayTraceUntil(start, end = transformation.toLocalSpace(RaycastHelper.getTraceTarget((class_1657)player, 70.0, traceOrigin)), pos -> localBounds.method_1006(VecHelper.getCenterOf((class_2382)pos)));
            this.schematicSelected = !result.missed();
            this.selectedFace = this.schematicSelected ? result.getFacing() : null;
        }
        boolean bl = snap = this.selectedPos == null;
        if (this.selectIgnoreBlocks) {
            float pt = AnimationTickHolder.getPartialTicks();
            this.selectedPos = new class_2338(player.method_5836(pt).method_1019(player.method_5720().method_1021((double)this.selectionRange)));
            if (snap) {
                this.lastChasingSelectedPos = this.chasingSelectedPos = class_243.method_24954((class_2382)this.selectedPos);
            }
            return;
        }
        this.selectedPos = null;
        class_3965 trace = RaycastHelper.rayTraceRange(player.field_6002, (class_1657)player, 75.0);
        if (trace == null || trace.method_17783() != class_239.class_240.field_1332) {
            return;
        }
        class_2338 hit = new class_2338(trace.method_17784());
        boolean replaceable = player.field_6002.method_8320(hit).method_26207().method_15800();
        if (trace.method_17780().method_10166().method_10178() && !replaceable) {
            hit = hit.method_10093(trace.method_17780());
        }
        this.selectedPos = hit;
        if (snap) {
            this.lastChasingSelectedPos = this.chasingSelectedPos = class_243.method_24954((class_2382)this.selectedPos);
        }
    }

    @Override
    public void renderTool(class_4587 ms, SuperRenderTypeBuffer buffer, class_243 camera) {
    }

    @Override
    public void renderOverlay(class_4587 poseStack, float partialTicks, int width, int height) {
    }

    @Override
    public void renderOnSchematic(class_4587 ms, SuperRenderTypeBuffer buffer) {
        if (!this.schematicHandler.isDeployed()) {
            return;
        }
        ms.method_22903();
        AABBOutline outline = this.schematicHandler.getOutline();
        if (this.renderSelectedFace) {
            outline.getParams().highlightFace(this.selectedFace).withFaceTextures(AllSpecialTextures.CHECKERED, AllKeys.ctrlDown() ? AllSpecialTextures.HIGHLIGHT_CHECKERED : AllSpecialTextures.CHECKERED);
        }
        outline.getParams().colored(6850245).withFaceTexture(AllSpecialTextures.CHECKERED).lineWidth(0.0625f);
        outline.render(ms, buffer, class_243.field_1353, AnimationTickHolder.getPartialTicks());
        outline.getParams().clearTextures();
        ms.method_22909();
    }
}

