/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.bogey;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.transform.Transform;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1158;
import net.minecraft.class_1159;
import net.minecraft.class_2246;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.jetbrains.annotations.Nullable;

public abstract class BogeyRenderer {
    Map<String, BogeyModelData[]> contraptionModelData = new HashMap<String, BogeyModelData[]>();

    public BogeyModelData[] getTransform(PartialModel model, class_4587 ms, boolean inInstancedContraption, int size) {
        return inInstancedContraption ? this.transformContraptionModelData(this.keyFromModel(model), ms) : this.createModelData(model, size);
    }

    public BogeyModelData[] getTransform(class_2680 state, class_4587 ms, boolean inContraption, int size) {
        return inContraption ? this.transformContraptionModelData(this.keyFromModel(state), ms) : this.createModelData(state, size);
    }

    public BogeyModelData getTransform(PartialModel model, class_4587 ms, boolean inInstancedContraption) {
        return inInstancedContraption ? this.contraptionModelData.get(this.keyFromModel(model))[0].setTransform(ms) : BogeyModelData.from(model);
    }

    public BogeyModelData getTransform(class_2680 state, class_4587 ms, boolean inContraption) {
        return inContraption ? this.contraptionModelData.get(this.keyFromModel(state))[0].setTransform(ms) : BogeyModelData.from(state);
    }

    @Environment(value=EnvType.CLIENT)
    public abstract void render(class_2487 var1, float var2, class_4587 var3, int var4, class_4588 var5, boolean var6);

    @Environment(value=EnvType.CLIENT)
    public void render(class_2487 bogeyData, float wheelAngle, class_4587 ms) {
        this.render(bogeyData, wheelAngle, ms, 0, null, true);
    }

    public abstract BogeySizes.BogeySize getSize();

    private BogeyModelData[] transformContraptionModelData(String key, class_4587 ms) {
        BogeyModelData[] modelData = this.contraptionModelData.get(key);
        Arrays.stream(modelData).forEach(modelDataElement -> modelDataElement.setTransform(ms));
        return modelData;
    }

    private BogeyModelData[] createModelData(PartialModel model, int size) {
        BogeyModelData[] data = new BogeyModelData[]{BogeyModelData.from(model)};
        return this.expandArrayToLength(data, size);
    }

    private BogeyModelData[] createModelData(class_2680 state, int size) {
        BogeyModelData[] data = new BogeyModelData[]{BogeyModelData.from(state)};
        return this.expandArrayToLength(data, size);
    }

    private BogeyModelData[] expandArrayToLength(BogeyModelData[] data, int size) {
        return (BogeyModelData[])Arrays.stream(Collections.nCopies(size, data).toArray()).flatMap(inner -> Arrays.stream((BogeyModelData[])inner)).toArray(BogeyModelData[]::new);
    }

    @Environment(value=EnvType.CLIENT)
    public abstract void initialiseContraptionModelData(MaterialManager var1, CarriageBogey var2);

    public void createModelInstance(MaterialManager materialManager, PartialModel model, int count) {
        BogeyModelData[] modelData = (BogeyModelData[])IntStream.range(0, count).mapToObj(i -> (ModelData)materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(model).createInstance()).map(BogeyModelData::new).toArray(BogeyModelData[]::new);
        this.contraptionModelData.put(this.keyFromModel(model), modelData);
    }

    public void createModelInstance(MaterialManager materialManager, class_2680 state, int count) {
        BogeyModelData[] modelData = (BogeyModelData[])IntStream.range(0, count).mapToObj(i -> (ModelData)materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(state).createInstance()).map(BogeyModelData::new).toArray(BogeyModelData[]::new);
        this.contraptionModelData.put(this.keyFromModel(state), modelData);
    }

    public void createModelInstance(MaterialManager materialManager, class_2680 ... states) {
        for (class_2680 state : states) {
            this.createModelInstance(materialManager, state, 1);
        }
    }

    public void createModelInstance(MaterialManager materialManager, PartialModel ... models) {
        for (PartialModel model : models) {
            this.createModelInstance(materialManager, model, 1);
        }
    }

    @Deprecated
    public static <B extends Transform<?>> void finalize(B b, class_4587 ms, int light, @Nullable class_4588 vb) {
        b.scale(0.9980469f);
        if (b instanceof SuperByteBuffer) {
            SuperByteBuffer byteBuf = (SuperByteBuffer)b;
            if (vb != null) {
                byteBuf.light(light).renderInto(ms, vb);
            }
        }
    }

    public void emptyTransforms() {
        for (BogeyModelData[] data : this.contraptionModelData.values()) {
            for (BogeyModelData model : data) {
                model.setEmptyTransform();
            }
        }
    }

    public void updateLight(int blockLight, int skyLight) {
        for (BogeyModelData[] data : this.contraptionModelData.values()) {
            for (BogeyModelData model : data) {
                model.updateLight(blockLight, skyLight);
            }
        }
    }

    public void remove() {
        for (BogeyModelData[] data : this.contraptionModelData.values()) {
            for (BogeyModelData model : data) {
                model.delete();
            }
        }
        this.contraptionModelData.clear();
    }

    private String keyFromModel(PartialModel partialModel) {
        return partialModel.getLocation().toString();
    }

    private String keyFromModel(class_2680 state) {
        return state.toString();
    }

    public record BogeyModelData(Transform<?> transform) implements Transform<BogeyModelData>
    {
        public static BogeyModelData from(PartialModel model) {
            class_2680 air = class_2246.field_10124.method_9564();
            return new BogeyModelData(CachedBufferer.partial(model, air));
        }

        public static BogeyModelData from(class_2680 model) {
            return new BogeyModelData(CachedBufferer.block(model));
        }

        public void render(class_4587 ms, int light, @Nullable class_4588 vb) {
            this.transform.scale(0.9980469f);
            Transform<?> transform = this.transform;
            if (transform instanceof SuperByteBuffer) {
                SuperByteBuffer byteBuf = (SuperByteBuffer)transform;
                if (vb != null) {
                    byteBuf.light(light).renderInto(ms, vb);
                }
            }
        }

        public BogeyModelData setTransform(class_4587 ms) {
            Transform<?> transform = this.transform;
            if (transform instanceof ModelData) {
                ModelData model = (ModelData)transform;
                model.setTransform(ms);
            }
            return this;
        }

        public BogeyModelData setEmptyTransform() {
            Transform<?> transform = this.transform;
            if (transform instanceof ModelData) {
                ModelData model = (ModelData)transform;
                model.setEmptyTransform();
            }
            return this;
        }

        public BogeyModelData delete() {
            Transform<?> transform = this.transform;
            if (transform instanceof ModelData) {
                ModelData model = (ModelData)transform;
                model.delete();
            }
            return this;
        }

        public BogeyModelData updateLight(int blockLight, int skyLight) {
            Transform<?> transform = this.transform;
            if (transform instanceof ModelData) {
                ModelData model = (ModelData)transform;
                model.setBlockLight(blockLight).setSkyLight(skyLight);
            }
            return this;
        }

        public BogeyModelData mulPose(class_1159 pose) {
            this.transform.mulPose(pose);
            return this;
        }

        public BogeyModelData mulNormal(class_4581 normal) {
            this.transform.mulNormal(normal);
            return this;
        }

        public BogeyModelData multiply(class_1158 quaternion) {
            this.transform.multiply(quaternion);
            return this;
        }

        public BogeyModelData scale(float factorX, float factorY, float factorZ) {
            this.transform.scale(factorX, factorY, factorZ);
            return this;
        }

        public BogeyModelData translate(double x, double y, double z) {
            this.transform.translate(x, y, z);
            return this;
        }
    }

    public static abstract class CommonRenderer
    extends BogeyRenderer {
        @Override
        public BogeySizes.BogeySize getSize() {
            return null;
        }
    }
}

