/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.gui.element.BoxElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.gui.element.TextStencilElement;
import com.simibubi.create.foundation.gui.widget.BoxWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class ConfirmationScreen
extends AbstractSimiScreen {
    private class_437 source;
    private Consumer<Response> action = _success -> {};
    private List<class_5348> text = new ArrayList<class_5348>();
    private boolean centered = false;
    private int x;
    private int y;
    private int textWidth;
    private int textHeight;
    private boolean tristate;
    private BoxWidget confirm;
    private BoxWidget confirmDontSave;
    private BoxWidget cancel;
    private BoxElement textBackground;

    public ConfirmationScreen removeTextLines(int amount) {
        if (amount > this.text.size()) {
            return this.clearText();
        }
        this.text.subList(this.text.size() - amount, this.text.size()).clear();
        return this;
    }

    public ConfirmationScreen clearText() {
        this.text.clear();
        return this;
    }

    public ConfirmationScreen addText(class_5348 text) {
        this.text.add(text);
        return this;
    }

    public ConfirmationScreen withText(class_5348 text) {
        return this.clearText().addText(text);
    }

    public ConfirmationScreen at(int x, int y) {
        this.x = Math.max(x, 0);
        this.y = Math.max(y, 0);
        this.centered = false;
        return this;
    }

    public ConfirmationScreen centered() {
        this.centered = true;
        return this;
    }

    public ConfirmationScreen withAction(Consumer<Boolean> action) {
        this.action = r -> action.accept(r == Response.Confirm);
        return this;
    }

    public ConfirmationScreen withThreeActions(Consumer<Response> action) {
        this.action = action;
        this.tristate = true;
        return this;
    }

    public void open(@Nonnull class_437 source) {
        this.source = source;
        class_310 client = class_310.method_1551();
        this.method_25423(client, client.method_22683().method_4486(), client.method_22683().method_4502());
        this.field_22787.field_1755 = this;
    }

    @Override
    public void method_25393() {
        super.method_25393();
        this.source.method_25393();
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        ArrayList<class_5348> copy = new ArrayList<class_5348>(this.text);
        this.text.clear();
        copy.forEach(t -> this.text.addAll(this.field_22793.method_27527().method_27495(t, 300, class_2583.field_24360)));
        int n = this.text.size();
        Objects.requireNonNull(this.field_22793);
        this.textHeight = n * (9 + 1) + 4;
        this.textWidth = 300;
        if (this.centered) {
            this.x = this.field_22789 / 2 - this.textWidth / 2 - 2;
            this.y = this.field_22790 / 2 - this.textHeight / 2 - 16;
        } else {
            this.x = Math.max(0, this.x - this.textWidth / 2);
            this.y = Math.max(0, this.y -= this.textHeight);
        }
        if (this.x + this.textWidth > this.field_22789) {
            this.x = this.field_22789 - this.textWidth;
        }
        if (this.y + this.textHeight + 30 > this.field_22790) {
            this.y = this.field_22790 - this.textHeight - 30;
        }
        int buttonX = this.x + this.textWidth / 2 - 6 - (int)(70.0f * (this.tristate ? 1.5f : 1.0f));
        TextStencilElement confirmText = new TextStencilElement(this.field_22793, this.tristate ? "Save" : "Confirm").centered(true, true);
        this.confirm = (BoxWidget)new BoxWidget(buttonX, this.y + this.textHeight + 6, 70, 16).withCallback(() -> this.accept(Response.Confirm));
        this.confirm.showingElement((RenderElement)confirmText.withElementRenderer(BoxWidget.gradientFactory.apply(this.confirm)));
        this.method_37063(this.confirm);
        buttonX += 82;
        if (this.tristate) {
            TextStencilElement confirmDontSaveText = new TextStencilElement(this.field_22793, "Don't Save").centered(true, true);
            this.confirmDontSave = (BoxWidget)new BoxWidget(buttonX, this.y + this.textHeight + 6, 70, 16).withCallback(() -> this.accept(Response.ConfirmDontSave));
            this.confirmDontSave.showingElement((RenderElement)confirmDontSaveText.withElementRenderer(BoxWidget.gradientFactory.apply(this.confirmDontSave)));
            this.method_37063(this.confirmDontSave);
            buttonX += 82;
        }
        TextStencilElement cancelText = new TextStencilElement(this.field_22793, "Cancel").centered(true, true);
        this.cancel = (BoxWidget)new BoxWidget(buttonX, this.y + this.textHeight + 6, 70, 16).withCallback(() -> this.accept(Response.Cancel));
        this.cancel.showingElement((RenderElement)cancelText.withElementRenderer(BoxWidget.gradientFactory.apply(this.cancel)));
        this.method_37063(this.cancel);
        this.textBackground = (BoxElement)((RenderElement)((RenderElement)new BoxElement().gradientBorder(Theme.p(Theme.Key.BUTTON_DISABLE))).withBounds(this.field_22789 + 10, this.textHeight + 35)).at(-5.0f, this.y - 5);
        if (this.text.size() == 1) {
            this.x = (this.field_22789 - this.field_22793.method_27525(this.text.get(0))) / 2;
        }
    }

    public void method_25419() {
        this.accept(Response.Cancel);
    }

    private void accept(Response success) {
        this.field_22787.field_1755 = this.source;
        this.action.accept(success);
    }

    @Override
    protected void renderWindow(class_4587 ms, int mouseX, int mouseY, float partialTicks) {
        this.textBackground.render(ms);
        Objects.requireNonNull(this.field_22793);
        int offset = 9 + 1;
        int lineY = this.y - offset;
        ms.method_22903();
        ms.method_22904(0.0, 0.0, 200.0);
        for (class_5348 line : this.text) {
            lineY += offset;
            if (line == null) continue;
            this.field_22793.method_1729(ms, line.getString(), (float)this.x, (float)lineY, 0xEAEAEA);
        }
        ms.method_22909();
    }

    @Override
    protected void renderWindowBackground(class_4587 ms, int mouseX, int mouseY, float partialTicks) {
        this.endFrame();
        this.source.method_25394(ms, 0, 0, 10.0f);
        this.prepareFrame();
        this.method_25296(ms, 0, 0, this.field_22789, this.field_22790, 0x70101010, -2146430960);
    }

    @Override
    protected void prepareFrame() {
        UIRenderHelper.swapAndBlitColor(this.field_22787.method_1522(), UIRenderHelper.framebuffer);
        RenderSystem.clear((int)1280, (boolean)class_310.field_1703);
    }

    @Override
    protected void endFrame() {
        UIRenderHelper.swapAndBlitColor(UIRenderHelper.framebuffer, this.field_22787.method_1522());
    }

    public void method_25410(@Nonnull class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        this.source.method_25410(client, width, height);
    }

    @Override
    public boolean method_25421() {
        return true;
    }

    public static enum Response {
        Confirm,
        ConfirmDontSave,
        Cancel;

    }
}

