/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.placement;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementOffset;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CClient;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;

public class PlacementHelpers {
    private static final List<IPlacementHelper> helpers = new ArrayList<IPlacementHelper>();
    private static int animationTick = 0;
    private static final LerpedFloat angle = LerpedFloat.angular().chase(0.0, 0.25, LerpedFloat.Chaser.EXP);
    private static class_2338 target = null;
    private static class_2338 lastTarget = null;

    public static int register(IPlacementHelper helper) {
        helpers.add(helper);
        return helpers.size() - 1;
    }

    public static IPlacementHelper get(int id) {
        if (id < 0 || id >= helpers.size()) {
            throw new ArrayIndexOutOfBoundsException("id " + id + " for placement helper not known");
        }
        return helpers.get(id);
    }

    @Environment(value=EnvType.CLIENT)
    public static void tick() {
        PlacementHelpers.setTarget(null);
        PlacementHelpers.checkHelpers();
        if (target == null) {
            if (animationTick > 0) {
                animationTick = Math.max(animationTick - 2, 0);
            }
            return;
        }
        if (animationTick < 10) {
            ++animationTick;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void checkHelpers() {
        class_310 mc = class_310.method_1551();
        class_638 world = mc.field_1687;
        if (world == null) {
            return;
        }
        if (!(mc.field_1765 instanceof class_3965)) {
            return;
        }
        class_3965 ray = (class_3965)mc.field_1765;
        if (mc.field_1724 == null) {
            return;
        }
        if (mc.field_1724.method_5715()) {
            return;
        }
        for (class_1268 hand : class_1268.values()) {
            class_1799 heldItem = mc.field_1724.method_5998(hand);
            List filteredForHeldItem = helpers.stream().filter(helper -> helper.matchesItem(heldItem)).collect(Collectors.toList());
            if (filteredForHeldItem.isEmpty()) continue;
            class_2338 pos = ray.method_17777();
            class_2680 state = world.method_8320(pos);
            List filteredForState = filteredForHeldItem.stream().filter(helper -> helper.matchesState(state)).collect(Collectors.toList());
            if (filteredForState.isEmpty()) continue;
            boolean atLeastOneMatch = false;
            for (IPlacementHelper h : filteredForState) {
                PlacementOffset offset = h.getOffset((class_1657)mc.field_1724, (class_1937)world, state, pos, ray, heldItem);
                if (!offset.isSuccessful()) continue;
                h.renderAt(pos, state, ray, offset);
                PlacementHelpers.setTarget(offset.getBlockPos());
                atLeastOneMatch = true;
                break;
            }
            if (!atLeastOneMatch) continue;
            return;
        }
    }

    static void setTarget(class_2338 target) {
        PlacementHelpers.target = target;
        if (target == null) {
            return;
        }
        if (lastTarget == null) {
            lastTarget = target;
            return;
        }
        if (!lastTarget.equals((Object)target)) {
            lastTarget = target;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void afterRenderOverlayLayer(class_4587 stack, float partialTicks, class_1041 res) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player != null && animationTick > 0) {
            float screenY = (float)res.method_4502() / 2.0f;
            float screenX = (float)res.method_4486() / 2.0f;
            float progress = PlacementHelpers.getCurrentAlpha();
            PlacementHelpers.drawDirectionIndicator(stack, partialTicks, screenX, screenY, progress);
        }
    }

    public static float getCurrentAlpha() {
        return Math.min((float)animationTick / 10.0f, 1.0f);
    }

    @Environment(value=EnvType.CLIENT)
    private static void drawDirectionIndicator(class_4587 ms, float partialTicks, float centerX, float centerY, float progress) {
        float r = 0.8f;
        float g = 0.8f;
        float b = 0.8f;
        float a = progress * progress;
        class_243 projTarget = VecHelper.projectToPlayerView(VecHelper.getCenterOf((class_2382)lastTarget), partialTicks);
        class_243 target = new class_243(projTarget.field_1352, projTarget.field_1351, 0.0);
        if (projTarget.field_1350 > 0.0) {
            target = target.method_22882();
        }
        class_243 norm = target.method_1029();
        class_243 ref = new class_243(0.0, 1.0, 0.0);
        float targetAngle = AngleHelper.deg(Math.acos(norm.method_1026(ref)));
        if (norm.field_1352 < 0.0) {
            targetAngle = 360.0f - targetAngle;
        }
        if (animationTick < 10) {
            angle.setValue(targetAngle);
        }
        angle.chase(targetAngle, 0.25, LerpedFloat.Chaser.EXP);
        angle.tickChaser();
        float snapSize = 22.5f;
        float snappedAngle = snapSize * (float)Math.round(angle.getValue(0.0f) / snapSize) % 360.0f;
        float length = 10.0f;
        CClient.PlacementIndicatorSetting mode = (CClient.PlacementIndicatorSetting)((Object)AllConfigs.client().placementIndicator.get());
        if (mode == CClient.PlacementIndicatorSetting.TRIANGLE) {
            PlacementHelpers.fadedArrow(ms, centerX, centerY, r, g, b, a, length, snappedAngle);
        } else if (mode == CClient.PlacementIndicatorSetting.TEXTURE) {
            PlacementHelpers.textured(ms, centerX, centerY, a, snappedAngle);
        }
    }

    private static void fadedArrow(class_4587 ms, float centerX, float centerY, float r, float g, float b, float a, float length, float snappedAngle) {
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        ms.method_22903();
        ms.method_22904((double)centerX, (double)centerY, 5.0);
        ms.method_22907(class_1160.field_20707.method_23214(angle.getValue(0.0f)));
        double scale = (Double)AllConfigs.client().indicatorScale.get();
        ms.method_22905((float)scale, (float)scale, 1.0f);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferbuilder = tessellator.method_1349();
        bufferbuilder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
        class_1159 mat = ms.method_23760().method_23761();
        bufferbuilder.method_22918(mat, 0.0f, -(10.0f + length), 0.0f).method_22915(r, g, b, a).method_1344();
        bufferbuilder.method_22918(mat, -9.0f, -3.0f, 0.0f).method_22915(r, g, b, 0.0f).method_1344();
        bufferbuilder.method_22918(mat, -6.0f, -6.0f, 0.0f).method_22915(r, g, b, 0.0f).method_1344();
        bufferbuilder.method_22918(mat, -3.0f, -8.0f, 0.0f).method_22915(r, g, b, 0.0f).method_1344();
        bufferbuilder.method_22918(mat, 0.0f, -8.5f, 0.0f).method_22915(r, g, b, 0.0f).method_1344();
        bufferbuilder.method_22918(mat, 3.0f, -8.0f, 0.0f).method_22915(r, g, b, 0.0f).method_1344();
        bufferbuilder.method_22918(mat, 6.0f, -6.0f, 0.0f).method_22915(r, g, b, 0.0f).method_1344();
        bufferbuilder.method_22918(mat, 9.0f, -3.0f, 0.0f).method_22915(r, g, b, 0.0f).method_1344();
        tessellator.method_1350();
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
        ms.method_22909();
    }

    @Environment(value=EnvType.CLIENT)
    public static void textured(class_4587 ms, float centerX, float centerY, float alpha, float snappedAngle) {
        RenderSystem.enableTexture();
        AllGuiTextures.PLACEMENT_INDICATOR_SHEET.bind();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34541);
        ms.method_22903();
        ms.method_22904((double)centerX, (double)centerY, 50.0);
        float scale = ((Double)AllConfigs.client().indicatorScale.get()).floatValue() * 0.75f;
        ms.method_22905(scale, scale, 1.0f);
        ms.method_22905(12.0f, 12.0f, 1.0f);
        float index = snappedAngle / 22.5f;
        float tex_size = 0.0625f;
        float tx = 0.0f;
        float ty = index * tex_size;
        float tw = 1.0f;
        float th = tex_size;
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
        class_1159 mat = ms.method_23760().method_23761();
        buffer.method_22918(mat, -1.0f, -1.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(tx, ty).method_1344();
        buffer.method_22918(mat, -1.0f, 1.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(tx, ty + th).method_1344();
        buffer.method_22918(mat, 1.0f, 1.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(tx + tw, ty + th).method_1344();
        buffer.method_22918(mat, 1.0f, -1.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(tx + tw, ty).method_1344();
        tessellator.method_1350();
        RenderSystem.disableBlend();
        ms.method_22909();
    }
}

