/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.gui.element.BoxElement;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widget.ElementWidget;
import com.simibubi.create.foundation.ponder.FabricPonderProcessing;
import com.simibubi.create.foundation.ponder.PonderChapter;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderStoryBoardEntry;
import com.simibubi.create.foundation.ponder.PonderTag;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.element.TextWindowElement;
import com.simibubi.create.foundation.ponder.ui.NavigatableSimiScreen;
import com.simibubi.create.foundation.ponder.ui.PonderButton;
import com.simibubi.create.foundation.ponder.ui.PonderProgressBar;
import com.simibubi.create.foundation.ponder.ui.PonderTagScreen;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.FontHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.Pointing;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.ponder.DebugScenes;
import com.simibubi.create.infrastructure.ponder.PonderIndex;
import io.github.fabricators_of_create.porting_lib.mixin.client.accessor.ScreenAccessor;
import io.github.fabricators_of_create.porting_lib.util.client.ScreenUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1041;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_327;
import net.minecraft.class_3341;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3674;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5425;
import net.minecraft.class_5819;

public class PonderUI
extends NavigatableSimiScreen {
    public static int ponderTicks;
    public static float ponderPartialTicksPaused;
    public static final String PONDERING = "ponder.pondering";
    public static final String IDENTIFY_MODE = "ponder.identify_mode";
    public static final String IN_CHAPTER = "ponder.in_chapter";
    public static final String IDENTIFY = "ponder.identify";
    public static final String PREVIOUS = "ponder.previous";
    public static final String CLOSE = "ponder.close";
    public static final String NEXT = "ponder.next";
    public static final String NEXT_UP = "ponder.next_up";
    public static final String REPLAY = "ponder.replay";
    public static final String SLOW_TEXT = "ponder.slow_text";
    private List<PonderScene> scenes;
    private List<PonderTag> tags;
    private List<PonderButton> tagButtons;
    private List<LerpedFloat> tagFades;
    private LerpedFloat fadeIn;
    class_1799 stack;
    PonderChapter chapter = null;
    private boolean userViewMode;
    private boolean identifyMode;
    private class_1799 hoveredTooltipItem;
    private class_2338 hoveredBlockPos;
    private class_3674 clipboardHelper;
    private class_2338 copiedBlockPos;
    private LerpedFloat finishingFlash;
    private LerpedFloat nextUp;
    private int finishingFlashWarmup = 0;
    private int nextUpWarmup = 0;
    private LerpedFloat lazyIndex;
    private int index = 0;
    private PonderTag referredToByTag;
    private PonderButton left;
    private PonderButton right;
    private PonderButton scan;
    private PonderButton chap;
    private PonderButton userMode;
    private PonderButton close;
    private PonderButton replay;
    private PonderButton slowMode;
    private int skipCooling = 0;
    private int extendedTickLength = 0;
    private int extendedTickTimer = 0;

    public static PonderUI of(class_2960 id) {
        return new PonderUI(PonderRegistry.compile(id));
    }

    public static PonderUI of(class_1799 item) {
        return new PonderUI(PonderRegistry.compile(RegisteredObjects.getKeyOrThrow(item.method_7909())));
    }

    public static PonderUI of(class_1799 item, PonderTag tag) {
        PonderUI ponderUI = new PonderUI(PonderRegistry.compile(RegisteredObjects.getKeyOrThrow(item.method_7909())));
        ponderUI.referredToByTag = tag;
        return ponderUI;
    }

    public static PonderUI of(PonderChapter chapter) {
        PonderUI ui = new PonderUI(PonderRegistry.compile(chapter));
        ui.chapter = chapter;
        return ui;
    }

    protected PonderUI(List<PonderScene> scenes) {
        class_2960 component = scenes.get(0).getComponent();
        this.stack = class_2378.field_11142.method_10250(component) ? new class_1799((class_1935)class_2378.field_11142.method_10223(component)) : new class_1799((class_1935)class_2378.field_11146.method_10223(component));
        this.tags = new ArrayList<PonderTag>(PonderRegistry.TAGS.getTags(component));
        this.scenes = scenes;
        if (scenes.isEmpty()) {
            List<PonderStoryBoardEntry> l = Collections.singletonList(new PonderStoryBoardEntry(DebugScenes::empty, "create", "debug/scene_1", new class_2960("minecraft", "stick")));
            scenes.addAll(PonderRegistry.compile(l));
        }
        this.lazyIndex = LerpedFloat.linear().startWithValue(this.index);
        this.fadeIn = LerpedFloat.linear().startWithValue(0.0).chase(1.0, 0.1f, LerpedFloat.Chaser.EXP);
        this.clipboardHelper = new class_3674();
        this.finishingFlash = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.1f, LerpedFloat.Chaser.EXP);
        this.nextUp = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.4f, LerpedFloat.Chaser.EXP);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.tagButtons = new ArrayList<PonderButton>();
        this.tagFades = new ArrayList<LerpedFloat>();
        this.tags.forEach(t -> {
            int i = this.tagButtons.size();
            int x = 31;
            int y = 81 + i * 30;
            PonderButton b2 = (PonderButton)((AbstractSimiWidget)new PonderButton(x, y).showing((ScreenElement)t)).withCallback((mX, mY) -> {
                this.centerScalingOn((int)mX, (int)mY);
                ScreenOpener.transitionTo(new PonderTagScreen((PonderTag)t));
            });
            this.method_37063(b2);
            this.tagButtons.add(b2);
            LerpedFloat chase = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.05f, LerpedFloat.Chaser.exp(0.1));
            this.tagFades.add(chase);
        });
        class_315 bindings = this.field_22787.field_1690;
        int spacing = 8;
        int bX = (this.field_22789 - 20) / 2 - (70 + 2 * spacing);
        int bY = this.field_22790 - 20 - 31;
        int pX = this.field_22789 / 2 - 110;
        int pY = bY + 20 + 4;
        int pW = this.field_22789 - 2 * pX;
        this.method_37063(new PonderProgressBar(this, pX, pY, pW, 1));
        this.scan = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX, bY).withShortcut(bindings.field_1869)).showing(AllIcons.I_MTD_SCAN)).enableFade(0, 5)).withCallback(() -> {
            boolean bl = this.identifyMode = !this.identifyMode;
            if (!this.identifyMode) {
                this.scenes.get(this.index).deselect();
            } else {
                ponderPartialTicksPaused = this.field_22787.method_1488();
            }
        });
        this.method_37063(this.scan);
        this.scan.atZLevel(600.0f);
        this.slowMode = (PonderButton)((AbstractSimiWidget)((ElementWidget)new PonderButton(this.field_22789 - 20 - 31, bY).showing(AllIcons.I_MTD_SLOW_MODE)).enableFade(0, 5)).withCallback(() -> this.setComfyReadingEnabled(!this.isComfyReadingEnabled()));
        this.method_37063(this.slowMode);
        if (PonderIndex.editingModeActive()) {
            this.userMode = (PonderButton)((AbstractSimiWidget)((ElementWidget)new PonderButton(this.field_22789 - 50 - 31, bY).showing(AllIcons.I_MTD_USER_MODE)).enableFade(0, 5)).withCallback(() -> {
                this.userViewMode = !this.userViewMode;
            });
            this.method_37063(this.userMode);
        }
        this.left = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX += 50 + spacing, bY).withShortcut(bindings.field_1913)).showing(AllIcons.I_MTD_LEFT)).enableFade(0, 5)).withCallback(() -> this.scroll(false));
        this.method_37063(this.left);
        this.close = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX += 20 + spacing, bY).withShortcut(bindings.field_1822)).showing(AllIcons.I_MTD_CLOSE)).enableFade(0, 5)).withCallback(this::method_25419);
        this.method_37063(this.close);
        this.right = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX += 20 + spacing, bY).withShortcut(bindings.field_1849)).showing(AllIcons.I_MTD_RIGHT)).enableFade(0, 5)).withCallback(() -> this.scroll(true));
        this.method_37063(this.right);
        this.replay = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX += 50 + spacing, bY).withShortcut(bindings.field_1881)).showing(AllIcons.I_MTD_REPLAY)).enableFade(0, 5)).withCallback(this::replay);
        this.method_37063(this.replay);
    }

    @Override
    protected void initBackTrackIcon(PonderButton backTrack) {
        backTrack.showing(this.stack);
    }

    @Override
    public void method_25393() {
        super.method_25393();
        if (this.skipCooling > 0) {
            --this.skipCooling;
        }
        if (this.referredToByTag != null) {
            for (int i = 0; i < this.scenes.size(); ++i) {
                PonderScene ponderScene = this.scenes.get(i);
                if (!ponderScene.getTags().contains(this.referredToByTag)) continue;
                if (i == this.index) break;
                this.scenes.get(this.index).fadeOut();
                this.index = i;
                this.scenes.get(this.index).begin();
                this.lazyIndex.chase(this.index, 0.25, LerpedFloat.Chaser.EXP);
                this.identifyMode = false;
                break;
            }
            this.referredToByTag = null;
        }
        this.lazyIndex.tickChaser();
        this.fadeIn.tickChaser();
        this.finishingFlash.tickChaser();
        this.nextUp.tickChaser();
        PonderScene activeScene = this.scenes.get(this.index);
        this.extendedTickLength = 0;
        if (this.isComfyReadingEnabled()) {
            activeScene.forEachVisible(TextWindowElement.class, twe -> {
                this.extendedTickLength = 2;
            });
        }
        if (this.extendedTickTimer == 0) {
            float lazyIndexValue;
            if (!this.identifyMode) {
                ++ponderTicks;
                if (this.skipCooling == 0) {
                    activeScene.tick();
                }
            }
            if (!this.identifyMode && Math.abs((lazyIndexValue = this.lazyIndex.getValue()) - (float)this.index) > 0.001953125f) {
                this.scenes.get(lazyIndexValue < (float)this.index ? this.index - 1 : this.index + 1).tick();
            }
            this.extendedTickTimer = this.extendedTickLength;
        } else {
            --this.extendedTickTimer;
        }
        if (activeScene.getCurrentTime() == activeScene.getTotalTime() - 1) {
            this.finishingFlashWarmup = 30;
            this.nextUpWarmup = 50;
        }
        if (this.finishingFlashWarmup > 0) {
            --this.finishingFlashWarmup;
            if (this.finishingFlashWarmup == 0) {
                this.finishingFlash.setValue(1.0);
                this.finishingFlash.setValue(1.0);
            }
        }
        if (this.nextUpWarmup > 0) {
            --this.nextUpWarmup;
            if (this.nextUpWarmup == 0) {
                this.nextUp.updateChaseTarget(1.0f);
            }
        }
        this.updateIdentifiedItem(activeScene);
    }

    public PonderScene getActiveScene() {
        return this.scenes.get(this.index);
    }

    public void seekToTime(int time) {
        if (this.getActiveScene().getCurrentTime() > time) {
            this.replay();
        }
        this.getActiveScene().seekToTime(time);
        if (time != 0) {
            this.coolDownAfterSkip();
        }
    }

    public void updateIdentifiedItem(PonderScene activeScene) {
        this.hoveredTooltipItem = class_1799.field_8037;
        this.hoveredBlockPos = null;
        if (!this.identifyMode) {
            return;
        }
        class_1041 w = this.field_22787.method_22683();
        double mouseX = this.field_22787.field_1729.method_1603() * (double)w.method_4486() / (double)w.method_4480();
        double mouseY = this.field_22787.field_1729.method_1604() * (double)w.method_4502() / (double)w.method_4507();
        PonderScene.SceneTransform t = activeScene.getTransform();
        class_243 vec1 = t.screenToScene(mouseX, mouseY, 1000, 0.0f);
        class_243 vec2 = t.screenToScene(mouseX, mouseY, -100, 0.0f);
        Pair<class_1799, class_2338> pair = activeScene.rayTraceScene(vec1, vec2);
        this.hoveredTooltipItem = pair.getFirst();
        this.hoveredBlockPos = pair.getSecond();
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.scroll(delta > 0.0)) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    protected void replay() {
        this.identifyMode = false;
        PonderScene scene = this.scenes.get(this.index);
        if (PonderUI.method_25442()) {
            List<PonderStoryBoardEntry> list = PonderRegistry.ALL.get(scene.getComponent());
            PonderStoryBoardEntry sb = list.get(this.index);
            class_2960 id = sb.getSchematicLocation();
            class_3499 activeTemplate = PonderRegistry.loadSchematic(id);
            PonderWorld world = new PonderWorld(class_2338.field_10980, (class_1937)class_310.method_1551().field_1687);
            class_3492 settings = FabricPonderProcessing.makePlaceSettings(id);
            activeTemplate.method_15172((class_5425)world, class_2338.field_10980, class_2338.field_10980, settings, class_5819.method_43047(), 2);
            world.createBackup();
            scene = PonderRegistry.compileScene(this.index, sb, world);
            scene.begin();
            this.scenes.set(this.index, scene);
        }
        scene.begin();
    }

    protected boolean scroll(boolean forward) {
        int prevIndex = this.index;
        this.index = forward ? this.index + 1 : this.index - 1;
        this.index = class_3532.method_15340((int)this.index, (int)0, (int)(this.scenes.size() - 1));
        if (prevIndex != this.index) {
            this.scenes.get(prevIndex).fadeOut();
            this.scenes.get(this.index).begin();
            this.lazyIndex.chase(this.index, 0.25, LerpedFloat.Chaser.EXP);
            this.identifyMode = false;
            return true;
        }
        this.index = prevIndex;
        return false;
    }

    @Override
    protected void renderWindow(class_4587 ms, int mouseX, int mouseY, float partialTicks) {
        partialTicks = PonderUI.getPartialTicks();
        RenderSystem.enableBlend();
        this.renderVisibleScenes(ms, mouseX, mouseY, this.skipCooling > 0 ? 0.0f : (this.identifyMode ? ponderPartialTicksPaused : partialTicks));
        this.renderWidgets(ms, mouseX, mouseY, this.identifyMode ? ponderPartialTicksPaused : partialTicks);
    }

    public void method_25420(class_4587 ms) {
        super.method_25420(ms);
    }

    protected void renderVisibleScenes(class_4587 ms, int mouseX, int mouseY, float partialTicks) {
        this.renderScene(ms, mouseX, mouseY, this.index, partialTicks);
        float lazyIndexValue = this.lazyIndex.getValue(partialTicks);
        if (Math.abs(lazyIndexValue - (float)this.index) > 0.001953125f) {
            this.renderScene(ms, mouseX, mouseY, lazyIndexValue < (float)this.index ? this.index - 1 : this.index + 1, partialTicks);
        }
    }

    protected void renderScene(class_4587 ms, int mouseX, int mouseY, int i, float partialTicks) {
        SuperRenderTypeBuffer buffer = SuperRenderTypeBuffer.getInstance();
        PonderScene scene = this.scenes.get(i);
        double value = this.lazyIndex.getValue(this.field_22787.method_1488());
        double diff = (double)i - value;
        double slide = class_3532.method_16436((double)(diff * diff), (double)200.0, (double)600.0) * diff;
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.backupProjectionMatrix();
        class_1159 matrix4f = new class_1159(RenderSystem.getProjectionMatrix());
        matrix4f.method_31544(0.0f, 0.0f, 800.0f);
        RenderSystem.setProjectionMatrix((class_1159)matrix4f);
        ms.method_22903();
        ms.method_22904(0.0, 0.0, -800.0);
        scene.getTransform().updateScreenParams(this.field_22789, this.field_22790, slide);
        scene.getTransform().apply(ms, partialTicks);
        scene.getTransform().updateSceneRVE(partialTicks);
        scene.renderScene(buffer, ms, partialTicks);
        buffer.draw();
        class_3341 bounds = scene.getBounds();
        ms.method_22903();
        if (!scene.shouldHidePlatformShadow()) {
            float flash;
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
            ms.method_22903();
            ms.method_22904((double)scene.getBasePlateOffsetX(), 0.0, (double)scene.getBasePlateOffsetZ());
            UIRenderHelper.flipForGuiRender(ms);
            float alpha = flash = this.finishingFlash.getValue(partialTicks) * 0.9f;
            flash *= flash;
            flash = flash * 2.0f - 1.0f;
            flash *= flash;
            flash = 1.0f - flash;
            for (int f = 0; f < 4; ++f) {
                ms.method_22904((double)scene.getBasePlateSize(), 0.0, 0.0);
                ms.method_22903();
                ms.method_22904(0.0, 0.0, -9.765625E-4);
                if (flash > 0.0f) {
                    ms.method_22903();
                    ms.method_22905(1.0f, 0.5f + flash * 0.75f, 1.0f);
                    ScreenUtils.drawGradientRect((class_1159)ms.method_23760().method_23761(), (int)0, (int)0, (int)-1, (int)(-scene.getBasePlateSize()), (int)0, (int)13041609, (int)new Color(-1429798967).scaleAlpha(alpha).getRGB());
                    ms.method_22909();
                }
                ms.method_22904(0.0, 0.0, 0.001953125);
                ScreenUtils.drawGradientRect((class_1159)ms.method_23760().method_23761(), (int)0, (int)0, (int)0, (int)(-scene.getBasePlateSize()), (int)4, (int)0x66000000, (int)0);
                ms.method_22909();
                ms.method_22907(class_1160.field_20705.method_23214(-90.0f));
            }
            ms.method_22909();
            RenderSystem.disableCull();
            RenderSystem.disableDepthTest();
        }
        if (PonderIndex.editingModeActive() && !this.userViewMode) {
            ms.method_22905(-1.0f, -1.0f, 1.0f);
            ms.method_22905(0.0625f, 0.0625f, 0.0625f);
            ms.method_22904(1.0, -8.0, -0.015625);
            ms.method_22903();
            ms.method_22904(4.0, -3.0, 0.0);
            ms.method_22904(0.0, 0.0, -0.001953125);
            for (int x = 0; x <= bounds.method_35414(); ++x) {
                ms.method_22904(-16.0, 0.0, 0.0);
                this.field_22793.method_1729(ms, (String)(x == bounds.method_35414() ? "x" : "" + x), 0.0f, 0.0f, -1);
            }
            ms.method_22909();
            ms.method_22903();
            ms.method_22905(-1.0f, 1.0f, 1.0f);
            ms.method_22904(0.0, -3.0, -4.0);
            ms.method_22907(class_1160.field_20705.method_23214(-90.0f));
            ms.method_22904(-8.0, -2.0, 0.03125);
            for (int z = 0; z <= bounds.method_14663(); ++z) {
                ms.method_22904(16.0, 0.0, 0.0);
                this.field_22793.method_1729(ms, (String)(z == bounds.method_14663() ? "z" : "" + z), 0.0f, 0.0f, -1);
            }
            ms.method_22909();
            ms.method_22903();
            ms.method_22904((double)(bounds.method_35414() * -8), 0.0, (double)(bounds.method_14663() * 8));
            ms.method_22907(class_1160.field_20705.method_23214(-90.0f));
            for (class_2350 d : Iterate.horizontalDirections) {
                ms.method_22907(class_1160.field_20705.method_23214(90.0f));
                ms.method_22903();
                ms.method_22904(0.0, 0.0, (double)(bounds.method_14663() * 16));
                ms.method_22907(class_1160.field_20703.method_23214(-90.0f));
                this.field_22793.method_1729(ms, d.name().substring(0, 1), 0.0f, 0.0f, 0x66FFFFFF);
                this.field_22793.method_1729(ms, "|", 2.0f, 10.0f, 0x44FFFFFF);
                this.field_22793.method_1729(ms, ".", 2.0f, 14.0f, 0x22FFFFFF);
                ms.method_22909();
            }
            ms.method_22909();
            buffer.draw();
        }
        ms.method_22909();
        ms.method_22909();
        RenderSystem.restoreProjectionMatrix();
    }

    protected void renderWidgets(class_4587 ms, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.disableDepthTest();
        float fade = this.fadeIn.getValue(partialTicks);
        float lazyIndexValue = this.lazyIndex.getValue(partialTicks);
        float indexDiff = Math.abs(lazyIndexValue - (float)this.index);
        PonderScene activeScene = this.scenes.get(this.index);
        PonderScene nextScene = this.scenes.size() > this.index + 1 ? this.scenes.get(this.index + 1) : null;
        boolean noWidgetsHovered = true;
        for (class_364 child : this.method_25396()) {
            noWidgetsHovered &= !child.method_25405((double)mouseX, (double)mouseY);
        }
        int tooltipColor = Theme.i(Theme.Key.TEXT_DARKER);
        this.renderChapterTitle(ms, fade, indexDiff, activeScene, tooltipColor);
        this.renderNavigationMenu(ms);
        if (this.identifyMode) {
            if (noWidgetsHovered && mouseY < this.field_22790 - 80) {
                ms.method_22903();
                ms.method_22904((double)mouseX, (double)mouseY, 100.0);
                if (this.hoveredTooltipItem.method_7960()) {
                    class_5250 text = Lang.translateDirect(IDENTIFY_MODE, ((class_5250)this.field_22787.field_1690.field_1869.method_16007()).method_27692(class_124.field_1068)).method_27692(class_124.field_1080);
                    this.method_30901(ms, this.field_22793.method_27527().method_27495((class_5348)text, this.field_22789 / 3, class_2583.field_24360).stream().map(formatted -> class_2561.method_43470((String)formatted.getString())).toList(), 0, 0);
                } else {
                    this.method_25409(ms, this.hoveredTooltipItem, 0, 0);
                }
                if (this.hoveredBlockPos != null && PonderIndex.editingModeActive() && !this.userViewMode) {
                    ms.method_22904(0.0, -15.0, 0.0);
                    boolean copied = this.copiedBlockPos != null && this.hoveredBlockPos.equals((Object)this.copiedBlockPos);
                    class_5250 coords = Components.literal(this.hoveredBlockPos.method_10263() + ", " + this.hoveredBlockPos.method_10264() + ", " + this.hoveredBlockPos.method_10260()).method_27692(copied ? class_124.field_1060 : class_124.field_1065);
                    this.method_25424(ms, (class_2561)coords, 0, 0);
                }
                ms.method_22909();
            }
            this.scan.flash();
        } else {
            this.scan.dim();
        }
        if (PonderIndex.editingModeActive()) {
            if (this.userViewMode) {
                this.userMode.flash();
            } else {
                this.userMode.dim();
            }
        }
        if (this.isComfyReadingEnabled()) {
            this.slowMode.flash();
        } else {
            this.slowMode.dim();
        }
        this.renderSceneOverlay(ms, partialTicks, lazyIndexValue, indexDiff);
        boolean finished = activeScene.isFinished();
        if (finished) {
            this.jumpToNextScene(ms, partialTicks, nextScene);
        }
        ((ScreenAccessor)this).port_lib$getRenderables().forEach(w -> {
            if (w instanceof PonderButton) {
                PonderButton button = (PonderButton)w;
                button.fade().startWithValue(fade);
            }
        });
        if (this.index == 0 || this.index == 1 && lazyIndexValue < (float)this.index) {
            this.left.fade().startWithValue(lazyIndexValue);
        }
        if (this.index == this.scenes.size() - 1 || this.index == this.scenes.size() - 2 && lazyIndexValue > (float)this.index) {
            this.right.fade().startWithValue((float)this.scenes.size() - lazyIndexValue - 1.0f);
        }
        if (finished) {
            this.right.flash();
        } else {
            this.right.dim();
            this.nextUp.updateChaseTarget(0.0f);
        }
        this.renderPonderTags(ms, mouseX, mouseY, partialTicks, fade, activeScene);
        this.renderHoverTooltips(ms, tooltipColor);
        RenderSystem.enableDepthTest();
    }

    protected void renderPonderTags(class_4587 ms, int mouseX, int mouseY, float partialTicks, float fade, PonderScene activeScene) {
        List<PonderTag> sceneTags = activeScene.getTags();
        boolean highlightAll = sceneTags.contains(PonderTag.HIGHLIGHT_ALL);
        double s = class_310.method_1551().method_22683().method_4495();
        IntStream.range(0, this.tagButtons.size()).forEach(i -> {
            ms.method_22903();
            LerpedFloat chase = this.tagFades.get(i);
            PonderButton button = this.tagButtons.get(i);
            if (button.method_25405(mouseX, mouseY)) {
                chase.updateChaseTarget(1.0f);
            } else {
                chase.updateChaseTarget(0.0f);
            }
            chase.tickChaser();
            if (highlightAll) {
                button.flash();
            } else {
                button.dim();
            }
            int x = button.field_22760 + button.method_25368() + 4;
            int y = button.field_22761 - 2;
            ms.method_22904((double)x, (double)((float)y + 5.0f * (1.0f - fade)), 800.0);
            float fadedWidth = 200.0f * chase.getValue(partialTicks);
            UIRenderHelper.streak(ms, 0.0f, 0, 12, 26, (int)fadedWidth);
            RenderSystem.enableScissor((int)((int)((double)x * s)), (int)0, (int)((int)((double)fadedWidth * s)), (int)((int)((double)this.field_22790 * s)));
            String tagName = this.tags.get(i).getTitle();
            this.field_22793.method_1729(ms, tagName, 3.0f, 8.0f, Theme.i(Theme.Key.TEXT_ACCENT_SLIGHT));
            RenderSystem.disableScissor();
            ms.method_22909();
        });
    }

    protected void renderSceneOverlay(class_4587 ms, float partialTicks, float lazyIndexValue, float indexDiff) {
        float scenePT = this.skipCooling > 0 ? 0.0f : partialTicks;
        ms.method_22903();
        ms.method_22904(0.0, 0.0, 100.0);
        this.renderOverlay(ms, this.index, scenePT);
        if (indexDiff > 0.001953125f) {
            this.renderOverlay(ms, lazyIndexValue < (float)this.index ? this.index - 1 : this.index + 1, scenePT);
        }
        ms.method_22909();
    }

    protected void jumpToNextScene(class_4587 ms, float partialTicks, PonderScene nextScene) {
        if (nextScene != null && this.nextUp.getValue() > 0.0625f && !nextScene.getId().equals((Object)Create.asResource("creative_motor_mojang"))) {
            ms.method_22903();
            ms.method_22904((double)(this.right.field_22760 + 10), (double)((float)(this.right.field_22761 - 6) + this.nextUp.getValue(partialTicks) * 5.0f), 400.0);
            int boxWidth = Math.max(this.field_22793.method_1727(nextScene.getTitle()), this.field_22793.method_27525((class_5348)Lang.translateDirect(NEXT_UP, new Object[0]))) + 5;
            PonderUI.renderSpeechBox(ms, 0, 0, boxWidth, 20, this.right.method_25367(), Pointing.DOWN, false);
            ms.method_22904(0.0, -29.0, 100.0);
            PonderUI.method_27534((class_4587)ms, (class_327)this.field_22793, (class_2561)Lang.translateDirect(NEXT_UP, new Object[0]), (int)0, (int)0, (int)Theme.i(Theme.Key.TEXT_DARKER));
            PonderUI.method_25300((class_4587)ms, (class_327)this.field_22793, (String)nextScene.getTitle(), (int)0, (int)10, (int)Theme.i(Theme.Key.TEXT));
            ms.method_22909();
        }
    }

    protected void renderHoverTooltips(class_4587 ms, int tooltipColor) {
        ms.method_22903();
        ms.method_22904(0.0, 0.0, 500.0);
        int tooltipY = this.field_22790 - 16;
        if (this.scan.method_25367()) {
            PonderUI.method_27534((class_4587)ms, (class_327)this.field_22793, (class_2561)Lang.translateDirect(IDENTIFY, new Object[0]), (int)(this.scan.field_22760 + 10), (int)tooltipY, (int)tooltipColor);
        }
        if (this.index != 0 && this.left.method_25367()) {
            PonderUI.method_27534((class_4587)ms, (class_327)this.field_22793, (class_2561)Lang.translateDirect(PREVIOUS, new Object[0]), (int)(this.left.field_22760 + 10), (int)tooltipY, (int)tooltipColor);
        }
        if (this.close.method_25367()) {
            PonderUI.method_27534((class_4587)ms, (class_327)this.field_22793, (class_2561)Lang.translateDirect(CLOSE, new Object[0]), (int)(this.close.field_22760 + 10), (int)tooltipY, (int)tooltipColor);
        }
        if (this.index != this.scenes.size() - 1 && this.right.method_25367()) {
            PonderUI.method_27534((class_4587)ms, (class_327)this.field_22793, (class_2561)Lang.translateDirect(NEXT, new Object[0]), (int)(this.right.field_22760 + 10), (int)tooltipY, (int)tooltipColor);
        }
        if (this.replay.method_25367()) {
            PonderUI.method_27534((class_4587)ms, (class_327)this.field_22793, (class_2561)Lang.translateDirect(REPLAY, new Object[0]), (int)(this.replay.field_22760 + 10), (int)tooltipY, (int)tooltipColor);
        }
        if (this.slowMode.method_25367()) {
            PonderUI.method_27534((class_4587)ms, (class_327)this.field_22793, (class_2561)Lang.translateDirect(SLOW_TEXT, new Object[0]), (int)(this.slowMode.field_22760 + 5), (int)tooltipY, (int)tooltipColor);
        }
        if (PonderIndex.editingModeActive() && this.userMode.method_25367()) {
            PonderUI.method_25300((class_4587)ms, (class_327)this.field_22793, (String)"Editor View", (int)(this.userMode.field_22760 + 10), (int)tooltipY, (int)tooltipColor);
        }
        ms.method_22909();
    }

    protected void renderChapterTitle(class_4587 ms, float fade, float indexDiff, PonderScene activeScene, int tooltipColor) {
        ms.method_22903();
        ms.method_22904(0.0, 0.0, 400.0);
        int x = 59;
        int y = 31;
        String title = activeScene.getTitle();
        int wordWrappedHeight = this.field_22793.method_1713(title, this.left.field_22760 - 51);
        int streakHeight = 26 + wordWrappedHeight;
        UIRenderHelper.streak(ms, 0.0f, x - 4, y - 12 + streakHeight / 2, streakHeight, (int)(150.0f * fade));
        UIRenderHelper.streak(ms, 180.0f, x - 4, y - 12 + streakHeight / 2, streakHeight, (int)(30.0f * fade));
        ((RenderElement)((RenderElement)((RenderElement)((BoxElement)new BoxElement().withBackground(Theme.c(Theme.Key.PONDER_BACKGROUND_FLAT))).gradientBorder(Theme.p(Theme.Key.PONDER_IDLE))).at(21.0f, 21.0f, 100.0f)).withBounds(30, 30)).render(ms);
        ((RenderElement)GuiGameElement.of(this.stack).scale(2.0).at((float)x - 39.0f, (float)y - 11.0f)).render(ms);
        this.field_22793.method_30883(ms, (class_2561)Lang.translateDirect(PONDERING, new Object[0]), (float)x, (float)(y - 6), tooltipColor);
        ms.method_22904((double)(x += 0), (double)(y += 8), 0.0);
        ms.method_22907(class_1160.field_20702.method_23214(indexDiff * -75.0f));
        ms.method_22904(0.0, 0.0, 5.0);
        FontHelper.drawSplitString(ms, this.field_22793, title, 0, 0, this.left.field_22760 - 51, Theme.c(Theme.Key.TEXT).scaleAlpha(1.0f - indexDiff).getRGB());
        ms.method_22909();
        if (this.chapter != null) {
            ms.method_22903();
            ms.method_22904((double)(this.chap.field_22760 - 8), (double)this.chap.field_22761, 0.0);
            UIRenderHelper.streak(ms, 180.0f, 4, 10, 26, (int)(150.0f * fade));
            this.drawRightAlignedString(this.field_22793, ms, Lang.translateDirect(IN_CHAPTER, new Object[0]).getString(), 0, 0, tooltipColor);
            this.drawRightAlignedString(this.field_22793, ms, this.chapter.getTitle(), 0, 12, Theme.i(Theme.Key.TEXT));
            ms.method_22909();
        }
    }

    protected void renderNavigationMenu(class_4587 ms) {
        Color c1 = Theme.c(Theme.Key.PONDER_BACK_ARROW).setAlpha(64);
        Color c2 = Theme.c(Theme.Key.PONDER_BACK_ARROW).setAlpha(32);
        Color c3 = Theme.c(Theme.Key.PONDER_BACK_ARROW).setAlpha(16);
        UIRenderHelper.breadcrumbArrow(ms, this.field_22789 / 2 - 20, this.field_22790 - 51, 0, 20, 20, 5, c1, c2);
        UIRenderHelper.breadcrumbArrow(ms, this.field_22789 / 2 + 20, this.field_22790 - 51, 0, -20, 20, -5, c1, c2);
        UIRenderHelper.breadcrumbArrow(ms, this.field_22789 / 2 - 90, this.field_22790 - 51, 0, 70, 20, 5, c1, c3);
        UIRenderHelper.breadcrumbArrow(ms, this.field_22789 / 2 + 90, this.field_22790 - 51, 0, -70, 20, -5, c1, c3);
    }

    private void renderOverlay(class_4587 ms, int i, float partialTicks) {
        if (this.identifyMode) {
            return;
        }
        ms.method_22903();
        PonderScene story = this.scenes.get(i);
        story.renderOverlay(this, ms, this.skipCooling > 0 ? 0.0f : (this.identifyMode ? ponderPartialTicksPaused : partialTicks));
        ms.method_22909();
    }

    public boolean method_25402(double x, double y, int button) {
        if (this.identifyMode && this.hoveredBlockPos != null && PonderIndex.editingModeActive()) {
            long handle = this.field_22787.method_22683().method_4490();
            if (this.copiedBlockPos != null && button == 1) {
                this.clipboardHelper.method_15979(handle, "util.select.fromTo(" + this.copiedBlockPos.method_10263() + ", " + this.copiedBlockPos.method_10264() + ", " + this.copiedBlockPos.method_10260() + ", " + this.hoveredBlockPos.method_10263() + ", " + this.hoveredBlockPos.method_10264() + ", " + this.hoveredBlockPos.method_10260() + ")");
                this.copiedBlockPos = this.hoveredBlockPos;
                return true;
            }
            if (PonderUI.method_25442()) {
                this.clipboardHelper.method_15979(handle, "util.select.position(" + this.hoveredBlockPos.method_10263() + ", " + this.hoveredBlockPos.method_10264() + ", " + this.hoveredBlockPos.method_10260() + ")");
            } else {
                this.clipboardHelper.method_15979(handle, "util.grid.at(" + this.hoveredBlockPos.method_10263() + ", " + this.hoveredBlockPos.method_10264() + ", " + this.hoveredBlockPos.method_10260() + ")");
            }
            this.copiedBlockPos = this.hoveredBlockPos;
            return true;
        }
        return super.method_25402(x, y, button);
    }

    @Override
    public boolean method_25404(int code, int p_keyPressed_2_, int p_keyPressed_3_) {
        class_315 settings = class_310.method_1551().field_1690;
        int sCode = KeyBindingHelper.getBoundKeyOf((class_304)settings.field_1881).method_1444();
        int aCode = KeyBindingHelper.getBoundKeyOf((class_304)settings.field_1913).method_1444();
        int dCode = KeyBindingHelper.getBoundKeyOf((class_304)settings.field_1849).method_1444();
        int qCode = KeyBindingHelper.getBoundKeyOf((class_304)settings.field_1869).method_1444();
        if (code == sCode) {
            this.replay();
            return true;
        }
        if (code == aCode) {
            this.scroll(false);
            return true;
        }
        if (code == dCode) {
            this.scroll(true);
            return true;
        }
        if (code == qCode) {
            boolean bl = this.identifyMode = !this.identifyMode;
            if (!this.identifyMode) {
                this.scenes.get(this.index).deselect();
            }
            return true;
        }
        return super.method_25404(code, p_keyPressed_2_, p_keyPressed_3_);
    }

    @Override
    protected String getBreadcrumbTitle() {
        if (this.chapter != null) {
            return this.chapter.getTitle();
        }
        return this.stack.method_7909().method_7848().getString();
    }

    public class_327 getFontRenderer() {
        return this.field_22793;
    }

    protected boolean isMouseOver(double mouseX, double mouseY, int x, int y, int w, int h) {
        boolean hovered = !(mouseX < (double)x) && !(mouseX > (double)(x + w));
        return hovered &= !(mouseY < (double)y) && !(mouseY > (double)(y + h));
    }

    public static void renderSpeechBox(class_4587 ms, int x, int y, int w, int h, boolean highlighted, Pointing pointing, boolean returnWithLocalTransform) {
        if (!returnWithLocalTransform) {
            ms.method_22903();
        }
        int boxX = x;
        int boxY = y;
        int divotX = x;
        int divotY = y;
        int divotRotation = 0;
        int divotSize = 8;
        int distance = 1;
        int divotRadius = divotSize / 2;
        Couple<Color> borderColors = Theme.p(highlighted ? Theme.Key.PONDER_BUTTON_HOVER : Theme.Key.PONDER_IDLE);
        Color c = switch (pointing) {
            default -> {
                divotRotation = 0;
                boxX -= w / 2;
                boxY -= h + divotSize + 1 + distance;
                divotX -= divotRadius;
                divotY -= divotSize + distance;
                yield (Color)borderColors.getSecond();
            }
            case Pointing.LEFT -> {
                divotRotation = 90;
                boxX += divotSize + 1 + distance;
                boxY -= h / 2;
                divotX += distance;
                divotY -= divotRadius;
                yield Color.mixColors(borderColors, 0.5f);
            }
            case Pointing.RIGHT -> {
                divotRotation = 270;
                boxX -= w + divotSize + 1 + distance;
                boxY -= h / 2;
                divotX -= divotSize + distance;
                divotY -= divotRadius;
                yield Color.mixColors(borderColors, 0.5f);
            }
            case Pointing.UP -> {
                divotRotation = 180;
                boxX -= w / 2;
                boxY += divotSize + 1 + distance;
                divotX -= divotRadius;
                divotY += distance;
                yield (Color)borderColors.getFirst();
            }
        };
        ((RenderElement)((RenderElement)((RenderElement)((BoxElement)new BoxElement().withBackground(Theme.c(Theme.Key.PONDER_BACKGROUND_FLAT))).gradientBorder(borderColors)).at(boxX, boxY, 100.0f)).withBounds(w, h)).render(ms);
        ms.method_22903();
        ms.method_22904((double)(divotX + divotRadius), (double)(divotY + divotRadius), 10.0);
        ms.method_22907(class_1160.field_20707.method_23214((float)divotRotation));
        ms.method_22904((double)(-divotRadius), (double)(-divotRadius), 0.0);
        AllGuiTextures.SPEECH_TOOLTIP_BACKGROUND.render(ms, 0, 0);
        AllGuiTextures.SPEECH_TOOLTIP_COLOR.render(ms, 0, 0, c);
        ms.method_22909();
        if (returnWithLocalTransform) {
            ms.method_22904((double)boxX, (double)boxY, 0.0);
            return;
        }
        ms.method_22909();
    }

    public class_1799 getHoveredTooltipItem() {
        return this.hoveredTooltipItem;
    }

    public class_1799 getSubject() {
        return this.stack;
    }

    @Override
    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        if (other instanceof PonderUI) {
            return this.stack.method_7962(((PonderUI)other).stack);
        }
        return super.isEquivalentTo(other);
    }

    @Override
    public void shareContextWith(NavigatableSimiScreen other) {
        if (other instanceof PonderUI) {
            PonderUI ponderUI = (PonderUI)other;
            ponderUI.referredToByTag = this.referredToByTag;
        }
    }

    public static float getPartialTicks() {
        float renderPartialTicks = class_310.method_1551().method_1488();
        if (class_310.method_1551().field_1755 instanceof PonderUI) {
            PonderUI ui = (PonderUI)class_310.method_1551().field_1755;
            if (ui.identifyMode) {
                return ponderPartialTicksPaused;
            }
            return (renderPartialTicks + (float)(ui.extendedTickLength - ui.extendedTickTimer)) / (float)(ui.extendedTickLength + 1);
        }
        return renderPartialTicks;
    }

    @Override
    public boolean method_25421() {
        return true;
    }

    public void coolDownAfterSkip() {
        this.skipCooling = 15;
    }

    public void method_25432() {
        super.method_25432();
        this.hoveredTooltipItem = class_1799.field_8037;
    }

    public void drawRightAlignedString(class_327 fontRenderer, class_4587 ms, String string, int x, int y, int color) {
        fontRenderer.method_1729(ms, string, (float)(x - fontRenderer.method_1727(string)), (float)y, color);
    }

    public boolean isComfyReadingEnabled() {
        return (Boolean)AllConfigs.client().comfyReading.get();
    }

    public void setComfyReadingEnabled(boolean slowTextMode) {
        AllConfigs.client().comfyReading.set(slowTextMode);
    }
}

