/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderRegistry;
import com.jozufozu.flywheel.config.BackendType;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.class_1159;
import net.minecraft.class_1162;
import net.minecraft.class_1920;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_761;
import net.minecraft.class_827;

public class BlockEntityRenderHelper {
    public static void renderBlockEntities(class_1937 world, Iterable<class_2586> customRenderBEs, class_4587 ms, class_4597 buffer) {
        BlockEntityRenderHelper.renderBlockEntities(world, null, customRenderBEs, ms, null, buffer);
    }

    public static void renderBlockEntities(class_1937 world, Iterable<class_2586> customRenderBEs, class_4587 ms, class_4597 buffer, float pt) {
        BlockEntityRenderHelper.renderBlockEntities(world, null, customRenderBEs, ms, null, buffer, pt);
    }

    public static void renderBlockEntities(class_1937 world, @Nullable VirtualRenderWorld renderWorld, Iterable<class_2586> customRenderBEs, class_4587 ms, @Nullable class_1159 lightTransform, class_4597 buffer) {
        BlockEntityRenderHelper.renderBlockEntities(world, renderWorld, customRenderBEs, ms, lightTransform, buffer, AnimationTickHolder.getPartialTicks());
    }

    public static void renderBlockEntities(class_1937 world, @Nullable VirtualRenderWorld renderWorld, Iterable<class_2586> customRenderBEs, class_4587 ms, @Nullable class_1159 lightTransform, class_4597 buffer, float pt) {
        Iterator<class_2586> iterator = customRenderBEs.iterator();
        while (iterator.hasNext()) {
            class_2586 blockEntity = iterator.next();
            if (Backend.getBackendType() == BackendType.INSTANCING && Backend.isFlywheelWorld((class_1936)renderWorld) && InstancedRenderRegistry.shouldSkipRender((class_2586)blockEntity)) continue;
            class_827 renderer = class_310.method_1551().method_31975().method_3550(blockEntity);
            if (renderer == null) {
                iterator.remove();
                continue;
            }
            class_2338 pos = blockEntity.method_11016();
            ms.method_22903();
            TransformStack.cast((class_4587)ms).translate((class_2382)pos);
            try {
                int worldLight = BlockEntityRenderHelper.getCombinedLight(world, BlockEntityRenderHelper.getLightPos(lightTransform, pos), renderWorld, pos);
                if (renderWorld != null) {
                    blockEntity.method_31662((class_1937)renderWorld);
                    renderer.method_3569(blockEntity, pt, ms, buffer, worldLight, class_4608.field_21444);
                    blockEntity.method_31662(world);
                } else {
                    renderer.method_3569(blockEntity, pt, ms, buffer, worldLight, class_4608.field_21444);
                }
            }
            catch (Exception e) {
                iterator.remove();
                String message = "BlockEntity " + RegisteredObjects.getKeyOrThrow(blockEntity.method_11017()).toString() + " could not be rendered virtually.";
                if (((Boolean)AllConfigs.client().explainRenderErrors.get()).booleanValue()) {
                    Create.LOGGER.error(message, (Throwable)e);
                }
                Create.LOGGER.error(message);
            }
            ms.method_22909();
        }
    }

    private static class_2338 getLightPos(@Nullable class_1159 lightTransform, class_2338 contraptionPos) {
        if (lightTransform != null) {
            class_1162 lightVec = new class_1162((float)contraptionPos.method_10263() + 0.5f, (float)contraptionPos.method_10264() + 0.5f, (float)contraptionPos.method_10260() + 0.5f, 1.0f);
            lightVec.method_22674(lightTransform);
            return new class_2338((double)lightVec.method_4953(), (double)lightVec.method_4956(), (double)lightVec.method_4957());
        }
        return contraptionPos;
    }

    public static int getCombinedLight(class_1937 world, class_2338 worldPos, @Nullable VirtualRenderWorld renderWorld, class_2338 renderWorldPos) {
        int worldLight = class_761.method_23794((class_1920)world, (class_2338)worldPos);
        if (renderWorld != null) {
            int renderWorldLight = class_761.method_23794((class_1920)renderWorld, (class_2338)renderWorldPos);
            return SuperByteBuffer.maxLight(worldLight, renderWorldLight);
        }
        return worldLight;
    }
}

