/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.portable_energy_interface;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyInterfaceActorInstance;
import com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyInterfaceBlock;
import com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyInterfaceBlockEntity;
import com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyInterfaceRenderer;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ActorInstance;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.render.ContraptionRenderDispatcher;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4597;
import org.jetbrains.annotations.Nullable;

public class PortableEnergyInterfaceMovement
implements MovementBehaviour {
    public class_243 getActiveAreaOffset(MovementContext context) {
        return class_243.method_24954((class_2382)((class_2350)context.state.method_11654((class_2769)PortableEnergyInterfaceBlock.field_10927)).method_10163()).method_1021((double)1.85f);
    }

    public boolean hasSpecialInstancedRendering() {
        return true;
    }

    @Nullable
    public ActorInstance createInstance(MaterialManager materialManager, VirtualRenderWorld simulationWorld, MovementContext context) {
        return new PortableEnergyInterfaceActorInstance(materialManager, simulationWorld, context);
    }

    @Environment(value=EnvType.CLIENT)
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, class_4597 buffer) {
        if (!ContraptionRenderDispatcher.canInstance()) {
            PortableEnergyInterfaceRenderer.renderInContraption(context, renderWorld, matrices, buffer);
        }
    }

    public void visitNewPosition(MovementContext context, class_2338 pos) {
        boolean onCarriage = context.contraption instanceof CarriageContraption;
        if (!(onCarriage && context.motion.method_1033() > 0.25 || this.findInterface(context, pos))) {
            context.data.method_10551("WorkingPos");
        }
    }

    public void tick(MovementContext context) {
        boolean onCarriage;
        if (context.world.field_9236) {
            PortableEnergyInterfaceMovement.getAnimation(context).tickChaser();
        }
        if (!(onCarriage = context.contraption instanceof CarriageContraption) || !(context.motion.method_1033() > 0.25)) {
            if (context.world.field_9236) {
                class_2338 pos = new class_2338(context.position);
                if (!this.findInterface(context, pos)) {
                    this.reset(context);
                }
            } else if (context.data.method_10545("WorkingPos")) {
                Optional<class_2350> currentFacingIfValid;
                class_2338 pos = class_2512.method_10691((class_2487)context.data.method_10562("WorkingPos"));
                class_243 target = VecHelper.getCenterOf((class_2382)pos);
                if (!context.stall && !onCarriage && context.position.method_24802((class_2374)target, target.method_1022(context.position.method_1019(context.motion)))) {
                    context.stall = true;
                }
                if ((currentFacingIfValid = this.getCurrentFacingIfValid(context)).isPresent()) {
                    PortableEnergyInterfaceBlockEntity stationaryInterface = this.getStationaryInterfaceAt(context.world, pos, context.state, currentFacingIfValid.get());
                    if (stationaryInterface == null) {
                        this.reset(context);
                    } else {
                        if (stationaryInterface.getConnectedEntity() == null) {
                            stationaryInterface.startTransferringTo(context.contraption, stationaryInterface.getConnectionDistance());
                        }
                        boolean timerBelow = stationaryInterface.getTransferTimer() <= 4;
                        stationaryInterface.keepAlive = 2;
                        if (context.stall && timerBelow) {
                            context.stall = false;
                        }
                    }
                }
            }
        }
    }

    protected boolean findInterface(MovementContext context, class_2338 pos) {
        CarriageContraption cc;
        Contraption var4 = context.contraption;
        if (var4 instanceof CarriageContraption && !(cc = (CarriageContraption)var4).notInPortal()) {
            return false;
        }
        Optional<class_2350> currentFacingIfValid = this.getCurrentFacingIfValid(context);
        if (!currentFacingIfValid.isPresent()) {
            return false;
        }
        class_2350 currentFacing = currentFacingIfValid.get();
        PortableEnergyInterfaceBlockEntity psi = this.findStationaryInterface(context.world, pos, context.state, currentFacing);
        if (psi == null) {
            return false;
        }
        if (psi.isPowered()) {
            return false;
        }
        context.data.method_10566("WorkingPos", (class_2520)class_2512.method_10692((class_2338)psi.method_11016()));
        if (!context.world.field_9236) {
            class_243 diff = VecHelper.getCenterOf((class_2382)psi.method_11016()).method_1020(context.position);
            diff = VecHelper.project((class_243)diff, (class_243)class_243.method_24954((class_2382)currentFacing.method_10163()));
            float distance = (float)(diff.method_1033() + (double)1.85f - 1.0);
            psi.startTransferringTo(context.contraption, distance);
        } else {
            context.data.method_10566("ClientPrevPos", (class_2520)class_2512.method_10692((class_2338)pos));
            if (context.contraption instanceof CarriageContraption || context.contraption.entity.isStalled() || context.motion.method_1027() == 0.0) {
                PortableEnergyInterfaceMovement.getAnimation(context).chase((double)(psi.getConnectionDistance() / 2.0f), 0.25, LerpedFloat.Chaser.LINEAR);
            }
        }
        return true;
    }

    public void stopMoving(MovementContext context) {
    }

    public void cancelStall(MovementContext context) {
        this.reset(context);
    }

    public void reset(MovementContext context) {
        context.data.method_10551("ClientPrevPos");
        context.data.method_10551("WorkingPos");
        context.stall = false;
        PortableEnergyInterfaceMovement.getAnimation(context).chase(0.0, 0.25, LerpedFloat.Chaser.LINEAR);
    }

    private PortableEnergyInterfaceBlockEntity findStationaryInterface(class_1937 world, class_2338 pos, class_2680 state, class_2350 facing) {
        for (int i = 0; i < 2; ++i) {
            PortableEnergyInterfaceBlockEntity interfaceAt = this.getStationaryInterfaceAt(world, pos.method_10079(facing, i), state, facing);
            if (interfaceAt == null) continue;
            return interfaceAt;
        }
        return null;
    }

    private PortableEnergyInterfaceBlockEntity getStationaryInterfaceAt(class_1937 world, class_2338 pos, class_2680 state, class_2350 facing) {
        class_2586 te = world.method_8321(pos);
        if (te instanceof PortableEnergyInterfaceBlockEntity) {
            PortableEnergyInterfaceBlockEntity psi = (PortableEnergyInterfaceBlockEntity)te;
            class_2680 blockState = world.method_8320(pos);
            if (blockState.method_26204() != state.method_26204()) {
                return null;
            }
            if (blockState.method_11654((class_2769)PortableEnergyInterfaceBlock.field_10927) != facing.method_10153()) {
                return null;
            }
            return psi.isPowered() ? null : psi;
        }
        return null;
    }

    private Optional<class_2350> getCurrentFacingIfValid(MovementContext context) {
        class_2350 facingFromVector;
        class_243 directionVec = class_243.method_24954((class_2382)((class_2350)context.state.method_11654((class_2769)PortableEnergyInterfaceBlock.field_10927)).method_10163());
        return (directionVec = (class_243)context.rotation.apply(directionVec)).method_1022(class_243.method_24954((class_2382)(facingFromVector = class_2350.method_10142((double)directionVec.field_1352, (double)directionVec.field_1351, (double)directionVec.field_1350)).method_10163())) > 0.5 ? Optional.empty() : Optional.of(facingFromVector);
    }

    public static LerpedFloat getAnimation(MovementContext context) {
        Object var2 = context.temporaryData;
        if (var2 instanceof LerpedFloat) {
            LerpedFloat lf = (LerpedFloat)var2;
            return lf;
        }
        LerpedFloat nlf = LerpedFloat.linear();
        context.temporaryData = nlf;
        return nlf;
    }
}

