/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1812;
import net.minecraft.class_1819;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_5632;
import tfar.dankstorage.DankStorage;
import tfar.dankstorage.client.Client;
import tfar.dankstorage.client.DankTooltip;
import tfar.dankstorage.container.PortableDankProvider;
import tfar.dankstorage.mixin.ItemUsageContextAccessor;
import tfar.dankstorage.network.DankPacketHandler;
import tfar.dankstorage.network.server.C2SMessageToggleUseType;
import tfar.dankstorage.network.server.C2SRequestContentsPacket;
import tfar.dankstorage.utils.DankStats;
import tfar.dankstorage.utils.PickupMode;
import tfar.dankstorage.utils.Utils;
import tfar.dankstorage.world.ClientData;
import tfar.dankstorage.world.DankInventory;
import tfar.dankstorage.world.DankSavedData;

public class DankItem
extends class_1792 {
    public final DankStats stats;
    private static final ThreadLocal<Integer> cache = ThreadLocal.withInitial(() -> -1);

    public DankItem(class_1792.class_1793 p_i48527_2_, DankStats stats) {
        super(p_i48527_2_);
        this.stats = stats;
    }

    public int method_7881(class_1799 bag) {
        if (!Utils.isConstruction(bag)) {
            return 0;
        }
        return 0;
    }

    public static class_1799 getSelected(class_1799 bag) {
        return class_1799.field_8037;
    }

    public float method_7865(class_1799 bag, class_2680 p_150893_2_) {
        if (!Utils.isConstruction(bag)) {
            return 1.0f;
        }
        return 1.0f;
    }

    public boolean method_7879(class_1799 s, class_1937 level, class_2680 p_179218_3_, class_2338 p_179218_4_, class_1309 p_179218_5_) {
        if (!Utils.isConstruction(s)) {
            return super.method_7879(s, level, p_179218_3_, p_179218_4_, p_179218_5_);
        }
        class_1799 tool = Utils.getItemStackInSelectedSlot(s, (class_3218)level);
        return tool.method_7909().method_7879(tool, level, p_179218_3_, p_179218_4_, p_179218_5_);
    }

    @Nonnull
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 bag = player.method_5998(hand);
        if (Utils.getUseType(bag) == C2SMessageToggleUseType.UseType.bag) {
            if (!level.field_9236) {
                DankItem.assignNextId(bag);
                player.method_17355((class_3908)new PortableDankProvider(bag));
            }
            return class_1271.method_22427((Object)bag);
        }
        if (!level.field_9236) {
            class_1304 hand1;
            class_1799 toPlace = Utils.getItemStackInSelectedSlot(bag, (class_3218)level);
            class_1304 class_13042 = hand1 = hand == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171;
            if (toPlace.method_7960()) {
                return class_1271.method_22430((Object)bag);
            }
            if (toPlace.method_7909().method_19263()) {
                if (player.method_7332(false)) {
                    player.method_6019(hand);
                    return class_1271.method_22428((Object)bag);
                }
            } else {
                if (toPlace.method_7909() instanceof class_1812) {
                    player.method_6019(hand);
                    return class_1271.method_22427((Object)player.method_5998(hand));
                }
                if (toPlace.method_7909() instanceof class_1819) {
                    player.method_6019(hand);
                    return class_1271.method_22427((Object)player.method_5998(hand));
                }
                class_1799 bagCopy = bag.method_7972();
                player.method_5673(hand1, toPlace);
                class_1271 actionResult = toPlace.method_7909().method_7836(level, player, hand);
                DankInventory handler = Utils.getOrCreateInventory(bagCopy, level);
                handler.method_5447(Utils.getSelectedSlot(bagCopy), (class_1799)actionResult.method_5466());
                player.method_5673(hand1, bagCopy);
            }
        }
        return new class_1271(class_1269.field_5811, (Object)player.method_5998(hand));
    }

    public class_1269 method_7847(class_1799 bag, class_1657 player, class_1309 entity, class_1268 hand) {
        if (!Utils.isConstruction(bag)) {
            return class_1269.field_5811;
        }
        class_1799 toUse = Utils.getSelectedItem(bag, player.field_6002);
        class_1304 hand1 = hand == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171;
        player.method_5673(hand1, toUse);
        class_1269 result = toUse.method_7909().method_7847(toUse, player, entity, hand);
        if (!player.field_6002.field_9236) {
            DankInventory handler = Utils.getOrCreateInventory(bag, player.field_6002);
            handler.method_5447(Utils.getSelectedSlot(bag), toUse);
        }
        player.method_5673(hand1, bag);
        return result;
    }

    public boolean method_7886(class_1799 stack) {
        return stack.method_7985() && Utils.getPickupMode(stack) != PickupMode.NONE;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 bag, @Nullable class_1937 level, List<class_2561> tooltip, class_1836 flag) {
        if (bag.method_7985() && Utils.DEV) {
            String s = bag.method_7969().toString();
            ArrayList<String> bits = new ArrayList<String>();
            int length = s.length();
            if (s.length() > 10000) {
                return;
            }
            int itr = (int)Math.ceil((double)length / 40.0);
            for (int i = 0; i < itr; ++i) {
                int end = (i + 1) * 40;
                if ((i + 1) * 40 - 1 >= length) {
                    end = length;
                }
                String s12 = s.substring(i * 40, end);
                bits.add(s12);
            }
            bits.forEach(s1 -> tooltip.add((class_2561)class_2561.method_43470((String)s1)));
        }
        int id = Utils.getFrequency(bag);
        tooltip.add((class_2561)class_2561.method_43470((String)("ID: " + id)));
        if (!class_437.method_25442()) {
            tooltip.add((class_2561)class_2561.method_43469((String)"text.dankstorage.shift", (Object[])new Object[]{class_2561.method_43470((String)"Shift").method_27692(class_124.field_1054)}).method_27692(class_124.field_1080));
        } else {
            tooltip.add((class_2561)class_2561.method_43469((String)"text.dankstorage.change_pickup_mode", (Object[])new Object[]{Client.PICKUP_MODE.method_16007().method_27661().method_27692(class_124.field_1054)}).method_27692(class_124.field_1080));
            PickupMode pickupMode = Utils.getPickupMode(bag);
            tooltip.add((class_2561)class_2561.method_43469((String)"text.dankstorage.current_pickup_mode", (Object[])new Object[]{class_2561.method_43471((String)("dankstorage.mode." + pickupMode.name().toLowerCase(Locale.ROOT))).method_27692(class_124.field_1054)}).method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43469((String)"text.dankstorage.changeusetype", (Object[])new Object[]{Client.CONSTRUCTION.method_16007().method_27661().method_27692(class_124.field_1054)}).method_27692(class_124.field_1080));
            C2SMessageToggleUseType.UseType useType = Utils.getUseType(bag);
            tooltip.add((class_2561)class_2561.method_43469((String)"text.dankstorage.currentusetype", (Object[])new Object[]{class_2561.method_43471((String)("dankstorage.usetype." + useType.name().toLowerCase(Locale.ROOT))).method_27692(class_124.field_1054)}).method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43469((String)"text.dankstorage.stacklimit", (Object[])new Object[]{class_2561.method_43470((String)("" + this.stats.stacklimit)).method_27692(class_124.field_1060)}).method_27692(class_124.field_1080));
        }
    }

    @Nonnull
    public class_1839 method_7853(class_1799 stack) {
        if (!Utils.isConstruction(stack)) {
            return class_1839.field_8952;
        }
        return class_1839.field_8952;
    }

    @Nonnull
    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 entity) {
        if (!Utils.isConstruction(stack)) {
            return stack;
        }
        return stack;
    }

    public int getGlintColor(class_1799 stack) {
        PickupMode pickupMode = Utils.getPickupMode(stack);
        switch (pickupMode) {
            default: {
                return -1;
            }
            case ALL: {
                return -16711936;
            }
            case FILTERED: {
                return -256;
            }
            case VOID: 
        }
        return -65536;
    }

    @Nonnull
    public class_1269 method_7884(class_1838 ctx) {
        class_1799 bag = ctx.method_8041();
        class_1937 level = ctx.method_8045();
        C2SMessageToggleUseType.UseType useType = Utils.getUseType(bag);
        if (useType == C2SMessageToggleUseType.UseType.bag) {
            return class_1269.field_5811;
        }
        int selectedSlot = Utils.getSelectedSlot(bag);
        if (selectedSlot == -1) {
            return class_1269.field_5811;
        }
        class_1799 toPlace = Utils.getSelectedItem(bag, level);
        ItemUseContextExt ctx2 = new ItemUseContextExt(ctx.method_8045(), ctx.method_8036(), ctx.method_20287(), toPlace, ((ItemUsageContextAccessor)ctx).getHitResult());
        class_1269 actionResultType = toPlace.method_7909().method_7884((class_1838)ctx2);
        if (!level.field_9236) {
            DankInventory dankInventory = Utils.getInventory(bag, level);
            dankInventory.method_5447(selectedSlot, ctx2.method_8041());
        }
        return actionResultType;
    }

    public void method_7888(class_1799 bag, class_1937 level, class_1297 entity, int i, boolean equipped) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            if (equipped) {
                class_1799 sel = Utils.getSelectedItem(bag, level);
                DankPacketHandler.sendSelectedItem(player, sel);
            }
        }
    }

    public boolean method_24357(class_1282 source) {
        return source == class_1282.field_5849;
    }

    public static void assignNextId(class_1799 dank) {
        class_2487 settings = Utils.getSettings(dank);
        if (settings == null || !settings.method_10573("dankstorage:id", 3)) {
            DankSavedData dankSavedData = DankStorage.instance.data;
            DankStats stats = Utils.getStats(dank);
            int next = dankSavedData.getNextID();
            dankSavedData.getOrCreateInventory(next, stats);
            Utils.getOrCreateSettings(dank).method_10569("dankstorage:id", next);
        }
    }

    public Optional<class_5632> method_32346(class_1799 itemStack) {
        int id = Utils.getFrequency(itemStack);
        if (id > -1) {
            if (cache.get() == id) {
                // empty if block
            }
            C2SRequestContentsPacket.send(id);
            cache.set(id);
            if (ClientData.cachedItems != null) {
                class_2371 nonNullList = class_2371.method_10211();
                nonNullList.addAll(ClientData.cachedItems);
                return Optional.of(new DankTooltip((class_2371<class_1799>)nonNullList, Utils.getSelectedSlot(itemStack)));
            }
        }
        return Optional.empty();
    }

    public static class ItemUseContextExt
    extends class_1838 {
        protected ItemUseContextExt(class_1937 level, @Nullable class_1657 player, class_1268 hand, class_1799 stack, class_3965 result) {
            super(level, player, hand, stack, result);
        }
    }
}

