/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.world;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.class_1277;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import tfar.dankstorage.DankStorage;
import tfar.dankstorage.mixin.SimpleContainerAccess;
import tfar.dankstorage.utils.DankStats;
import tfar.dankstorage.utils.ItemHandlerHelper;
import tfar.dankstorage.utils.ItemStackWrapper;
import tfar.dankstorage.utils.Utils;

public class DankInventory
extends class_1277
implements class_3913 {
    public DankStats dankStats;
    protected class_2371<class_1799> ghostItems;
    protected int id;
    public boolean locked = true;
    protected int textColor = -1;
    static final String GHOST = "GhostItems";

    public DankInventory(DankStats stats, int id) {
        super(stats.slots);
        this.dankStats = stats;
        this.ghostItems = class_2371.method_10213((int)stats.slots, (Object)class_1799.field_8037);
        this.id = id;
    }

    public void upgradeTo(DankStats stats) {
        if (stats.ordinal() <= this.dankStats.ordinal()) {
            return;
        }
        DankStorage.LOGGER.debug("Upgrading dank #{} from tier {} to {}", (Object)this.id, (Object)this.dankStats.name(), (Object)stats.name());
        this.setTo(stats);
    }

    public void setTo(DankStats stats) {
        this.dankStats = stats;
        this.copyItems();
    }

    private void copyItems() {
        class_2371 newStacks = class_2371.method_10213((int)this.dankStats.slots, (Object)class_1799.field_8037);
        class_2371 newGhostStacks = class_2371.method_10213((int)this.dankStats.slots, (Object)class_1799.field_8037);
        int oldSlots = this.method_5439();
        int max = Math.min(oldSlots, this.dankStats.slots);
        for (int i = 0; i < max; ++i) {
            class_1799 oldStack = this.method_5438(i);
            class_1799 oldGhost = this.getGhostItem(i);
            newStacks.set(i, (Object)oldStack);
            newGhostStacks.set(i, (Object)oldGhost);
        }
        this.$setSize(this.dankStats.slots);
        ((SimpleContainerAccess)((Object)this)).setItems((class_2371<class_1799>)newStacks);
        this.setGhostItems((class_2371<class_1799>)newGhostStacks);
        this.method_5431();
    }

    protected void setGhostItems(class_2371<class_1799> newGhosts) {
        this.ghostItems = newGhosts;
    }

    public void $setSize(int size) {
        ((SimpleContainerAccess)((Object)this)).setSize(size);
        ((SimpleContainerAccess)((Object)this)).setItems((class_2371<class_1799>)class_2371.method_10213((int)size, (Object)class_1799.field_8037));
        this.setGhostItems((class_2371<class_1799>)class_2371.method_10213((int)size, (Object)class_1799.field_8037));
    }

    public void setDankStats(DankStats dankStats) {
        this.dankStats = dankStats;
        this.$setSize(dankStats.slots);
    }

    public int method_5444() {
        return this.dankStats.stacklimit;
    }

    public class_2371<class_1799> getContents() {
        return ((SimpleContainerAccess)((Object)this)).getItems();
    }

    public boolean noValidSlots() {
        return IntStream.range(0, this.method_5439()).mapToObj(arg_0 -> ((DankInventory)this).method_5438(arg_0)).allMatch(stack -> stack.method_7960() || stack.method_31573(Utils.BLACKLISTED_USAGE));
    }

    public boolean method_5437(int slot, class_1799 stack) {
        boolean checkGhostItem = !this.hasGhostItem(slot) || this.getGhostItem(slot).method_7909() == stack.method_7909();
        return !stack.method_31573(Utils.BLACKLISTED_STORAGE) && checkGhostItem;
    }

    public class_2487 save() {
        class_2487 itemTag;
        class_2499 nbtTagList = new class_2499();
        for (int i = 0; i < this.getContents().size(); ++i) {
            if (((class_1799)this.getContents().get(i)).method_7960()) continue;
            int realCount = Math.min(this.dankStats.stacklimit, ((class_1799)this.getContents().get(i)).method_7947());
            itemTag = new class_2487();
            itemTag.method_10569("Slot", i);
            ((class_1799)this.getContents().get(i)).method_7953(itemTag);
            itemTag.method_10569("ExtendedCount", realCount);
            nbtTagList.add((Object)itemTag);
        }
        class_2499 ghostItemNBT = new class_2499();
        for (int i = 0; i < this.getContents().size(); ++i) {
            if (((class_1799)this.ghostItems.get(i)).method_7960()) continue;
            itemTag = new class_2487();
            itemTag.method_10569("Slot", i);
            ((class_1799)this.ghostItems.get(i)).method_7953(itemTag);
            ghostItemNBT.add((Object)itemTag);
        }
        class_2487 nbt = new class_2487();
        nbt.method_10566("Items", (class_2520)nbtTagList);
        nbt.method_10566(GHOST, (class_2520)ghostItemNBT);
        nbt.method_10582("DankStats", this.dankStats.name());
        nbt.method_10569("dankstorage:id", this.id);
        nbt.method_10556("locked", this.locked);
        return nbt;
    }

    public void read(class_2487 nbt) {
        DankStats stats = DankStats.valueOf(nbt.method_10558("DankStats"));
        this.setDankStats(stats);
        class_2499 tagList = nbt.method_10554("Items", 10);
        this.readItems(tagList);
        class_2499 ghostItemList = nbt.method_10554(GHOST, 10);
        this.readGhostItems(ghostItemList);
        this.locked = nbt.method_10577("locked");
        this.validate();
    }

    protected void readItems(class_2499 listTag) {
        for (int i = 0; i < listTag.size(); ++i) {
            class_1799 stack;
            class_2487 itemTags = listTag.method_10602(i);
            int slot = itemTags.method_10550("Slot");
            if (slot < 0 || slot >= this.method_5439()) continue;
            if (itemTags.method_10573("StackList", 9)) {
                stack = class_1799.field_8037;
                class_2499 stackTagList = itemTags.method_10554("StackList", 10);
                for (int j = 0; j < stackTagList.size(); ++j) {
                    class_2487 itemTag = stackTagList.method_10602(j);
                    class_1799 temp = class_1799.method_7915((class_2487)itemTag);
                    if (temp.method_7960()) continue;
                    if (stack.method_7960()) {
                        stack = temp;
                        continue;
                    }
                    stack.method_7933(temp.method_7947());
                }
                if (stack.method_7960()) continue;
                int count = stack.method_7947();
                count = Math.min(count, this.method_5444());
                stack.method_7939(count);
                this.method_5447(slot, stack);
                continue;
            }
            stack = class_1799.method_7915((class_2487)itemTags);
            if (itemTags.method_10573("ExtendedCount", 3)) {
                stack.method_7939(itemTags.method_10550("ExtendedCount"));
            }
            this.method_5447(slot, stack);
        }
    }

    protected void readGhostItems(class_2499 listTag) {
        for (int i = 0; i < listTag.size(); ++i) {
            class_1799 stack;
            class_2487 itemTags = listTag.method_10602(i);
            int slot = itemTags.method_10550("Slot");
            if (slot < 0 || slot >= this.method_5439()) continue;
            if (itemTags.method_10573("StackList", 9)) {
                stack = class_1799.field_8037;
                class_2499 stackTagList = itemTags.method_10554("StackList", 10);
                for (int j = 0; j < stackTagList.size(); ++j) {
                    class_2487 itemTag = stackTagList.method_10602(j);
                    class_1799 temp = class_1799.method_7915((class_2487)itemTag);
                    if (temp.method_7960()) continue;
                    if (stack.method_7960()) {
                        stack = temp;
                        continue;
                    }
                    stack.method_7933(temp.method_7947());
                }
                if (stack.method_7960()) continue;
                this.ghostItems.set(slot, (Object)stack);
                continue;
            }
            stack = class_1799.method_7915((class_2487)itemTags);
            this.ghostItems.set(slot, (Object)stack);
        }
    }

    protected void validate() {
        if (this.dankStats == DankStats.zero) {
            throw new RuntimeException("dank has no stats?");
        }
        if (this.method_5439() == 0) {
            throw new RuntimeException("dank is empty?");
        }
        if (this.ghostItems.size() != this.method_5439()) {
            throw new RuntimeException("inequal size");
        }
    }

    public int calcRedstone() {
        int numStacks = 0;
        float f = 0.0f;
        for (int slot = 0; slot < this.method_5439(); ++slot) {
            class_1799 stack = this.method_5438(slot);
            if (stack.method_7960()) continue;
            f += (float)stack.method_7947() / (float)this.method_5444();
            ++numStacks;
        }
        return class_3532.method_15375((float)((f /= (float)this.method_5439()) * 14.0f)) + (numStacks > 0 ? 1 : 0);
    }

    public int getMaxStackSizeSensitive(class_1799 stack) {
        return stack.method_31573(Utils.UNSTACKABLE) ? 1 : this.method_5444();
    }

    public void method_5431() {
        super.method_5431();
        if (DankStorage.instance.data != null) {
            DankStorage.instance.data.method_80();
        }
    }

    public int getTextColor() {
        return this.method_17390(1);
    }

    public void setTextColor(int color) {
        this.method_17391(1, color);
    }

    public boolean frequencyLocked() {
        return this.method_17390(2) == 1;
    }

    public void toggleFrequencyLock() {
        boolean loc = this.method_17390(2) == 1;
        this.setFrequencyLock(!loc);
    }

    public void setFrequencyLock(boolean lock) {
        this.method_17391(2, lock ? 1 : 0);
    }

    public int getFrequency() {
        return this.method_17390(0);
    }

    public int method_17390(int slot) {
        return switch (slot) {
            case 0 -> this.id;
            case 1 -> this.textColor;
            case 2 -> {
                if (this.locked) {
                    yield 1;
                }
                yield 0;
            }
            default -> -999;
        };
    }

    public void method_17391(int slot, int value) {
        switch (slot) {
            case 0: {
                this.id = value;
                break;
            }
            case 1: {
                this.textColor = value;
                break;
            }
            case 2: {
                this.locked = value == 1;
            }
        }
        this.method_5431();
    }

    public void compress(class_3218 level) {
        Pair<class_1799, Integer> stackIntegerPair;
        this.sort();
        int freeSlots = 0;
        HashMap<class_1792, Pair> groups = new HashMap<class_1792, Pair>();
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 stack = this.method_5438(i);
            if (!stack.method_7960()) {
                if (!Utils.canCompress(level, stack)) continue;
                class_1792 item = stack.method_7909();
                Pair pair = groups.containsKey(item) ? Pair.of((Object)((Integer)((Pair)groups.get(item)).getFirst()), (Object)i) : Pair.of((Object)i, (Object)i);
                groups.put(item, pair);
                continue;
            }
            freeSlots = this.method_5439() - i;
            break;
        }
        ArrayList<class_1792> unsafeSlots = new ArrayList<class_1792>();
        for (Map.Entry entry : groups.entrySet()) {
            class_1792 item = (class_1792)entry.getKey();
            Pair pair = (Pair)entry.getValue();
            stackIntegerPair = Utils.compress(level, new class_1799((class_1935)item));
            int count = 0;
            for (int i = ((Integer)pair.getFirst()).intValue(); i < (Integer)pair.getSecond() + 1; ++i) {
                count += this.method_5438(i).method_7947();
            }
            if (count <= this.method_5444() && count % (Integer)stackIntegerPair.getSecond() != 0) {
                unsafeSlots.add(item);
                continue;
            }
            class_1799 compressionResult = (class_1799)stackIntegerPair.getFirst();
            int compressedCount = count / (Integer)stackIntegerPair.getSecond();
            int remainder = count % (Integer)stackIntegerPair.getSecond();
            for (int i = ((Integer)pair.getFirst()).intValue(); i < (Integer)pair.getSecond() + 1; ++i) {
                this.method_5434(i, this.method_5444());
            }
            int fullStacks = compressedCount / this.method_5444();
            int partialStack = compressedCount % this.method_5444();
            for (int i = ((Integer)pair.getFirst()).intValue(); i < (Integer)pair.getFirst() + fullStacks; ++i) {
                this.method_5447(i, new class_1799((class_1935)compressionResult.method_7909(), this.method_5444()));
            }
            if (partialStack > 0) {
                this.method_5447((Integer)pair.getFirst() + fullStacks, new class_1799((class_1935)compressionResult.method_7909(), partialStack));
            }
            if (remainder <= 0) continue;
            this.method_5447((Integer)pair.getFirst() + fullStacks + 1, new class_1799((class_1935)item, partialStack));
        }
        this.sort();
        block5: for (class_1792 item : unsafeSlots) {
            if (freeSlots <= 0) break;
            for (int i = 0; i < this.method_5439(); ++i) {
                class_1799 stack = this.method_5438(i);
                if (stack.method_7909() != item) continue;
                stackIntegerPair = Utils.compress(level, new class_1799((class_1935)item));
                class_1799 compressionResult = (class_1799)stackIntegerPair.getFirst();
                int compressedCount = stack.method_7947() / (Integer)stackIntegerPair.getSecond();
                int remainder = stack.method_7947() % (Integer)stackIntegerPair.getSecond();
                this.method_5447(i, new class_1799((class_1935)compressionResult.method_7909(), compressedCount));
                this.method_5447(this.method_5439() - freeSlots, new class_1799((class_1935)item, remainder));
                --freeSlots;
                continue block5;
            }
        }
        this.sort();
    }

    public void sort() {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        for (class_1799 stack : this.getContents()) {
            if (stack.method_7960()) continue;
            Utils.merge(stacks, stack.method_7972());
        }
        List<ItemStackWrapper> wrappers = Utils.wrap(stacks);
        Collections.sort(wrappers);
        this.method_5448();
        int slotId = 0;
        for (int i = 0; i < wrappers.size(); ++i) {
            int stackSizeSensitive;
            class_1799 stack = wrappers.get((int)i).stack;
            int count = stack.method_7947();
            if (count > (stackSizeSensitive = this.getMaxStackSizeSensitive(stack))) {
                int fullStacks = count / stackSizeSensitive;
                int partialStack = count - fullStacks * stackSizeSensitive;
                for (int j = 0; j < fullStacks; ++j) {
                    this.method_5447(slotId, ItemHandlerHelper.copyStackWithSize(stack, stackSizeSensitive));
                    ++slotId;
                }
                if (partialStack <= 0) continue;
                this.method_5447(slotId, ItemHandlerHelper.copyStackWithSize(stack, partialStack));
                ++slotId;
                continue;
            }
            this.method_5447(slotId, stack);
            ++slotId;
        }
    }

    public boolean hasGhostItem(int slot) {
        return !((class_1799)this.ghostItems.get(slot)).method_7960();
    }

    public class_1799 getGhostItem(int slot) {
        return (class_1799)this.ghostItems.get(slot);
    }

    public void setGhostItem(int slot, class_1792 item) {
        this.ghostItems.set(slot, (Object)new class_1799((class_1935)item));
    }

    public void toggleGhostItem(int slot) {
        boolean loc;
        boolean bl = loc = !((class_1799)this.ghostItems.get(slot)).method_7960();
        if (!loc) {
            this.ghostItems.set(slot, (Object)ItemHandlerHelper.copyStackWithSize(this.method_5438(slot), 1));
        } else {
            this.ghostItems.set(slot, (Object)class_1799.field_8037);
        }
        this.method_5431();
    }

    public int method_17389() {
        return 3;
    }

    public static enum TxtColor {
        INVALID(-65536),
        TOO_HIGH(Short.MIN_VALUE),
        DIFFERENT_TIER(-256),
        GOOD(-16711936),
        LOCKED(-16776961);

        public final int color;

        private TxtColor(int color) {
            this.color = color;
        }
    }
}

