/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.world;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import tfar.dankstorage.DankStorage;
import tfar.dankstorage.utils.DankStats;
import tfar.dankstorage.world.DankInventory;

public class DankSavedData
extends class_18 {
    private final List<DankInventory> storage = new ArrayList<DankInventory>();

    @Nullable
    public DankInventory getInventory(int id) {
        return id < this.storage.size() && id > -1 ? this.storage.get(id) : null;
    }

    public DankInventory getOrCreateInventory(int id, DankStats stats) {
        DankInventory dankInventory = this.getInventory(id);
        if (dankInventory == null) {
            int next = this.getNextID();
            DankInventory inventory = new DankInventory(stats, next);
            this.storage.add(next, inventory);
            this.method_80();
        }
        return this.getInventory(id);
    }

    public int getNextID() {
        return this.storage.size();
    }

    public class_2487 method_75(class_2487 compoundTag) {
        class_2499 listTag = new class_2499();
        for (DankInventory inventory : this.storage) {
            listTag.add((Object)inventory.save());
        }
        compoundTag.method_10566("contents", (class_2520)listTag);
        return compoundTag;
    }

    public static DankSavedData loadStatic(class_2487 compoundTag) {
        DankSavedData dankSavedData = new DankSavedData();
        dankSavedData.load(compoundTag);
        return dankSavedData;
    }

    protected void load(class_2487 compoundTag) {
        class_2499 invs = compoundTag.method_10554("contents", 10);
        for (class_2520 tag : invs) {
            class_2487 compoundTag1 = (class_2487)tag;
            int id = compoundTag1.method_10550("dankstorage:id");
            DankInventory dankInventory = this.readItems(compoundTag1, id);
            this.storage.add(id, dankInventory);
        }
    }

    DankInventory readItems(class_2487 tag, int id) {
        DankInventory inventory = new DankInventory(DankStats.zero, id);
        inventory.read(tag);
        return inventory;
    }

    public void method_17919(File file) {
        super.method_17919(file);
        DankStorage.LOGGER.debug("Saving Dank Contents");
    }

    public void clearAll() {
        this.storage.clear();
        this.method_80();
    }

    public boolean clearId(int id) {
        if (id < this.getNextID()) {
            DankInventory dankInventory = this.getInventory(id);
            dankInventory.method_5448();
            this.method_80();
            return true;
        }
        return false;
    }

    public boolean setTier(int id, int tier) {
        if (id < this.getNextID()) {
            DankInventory dankInventory = this.getInventory(id);
            dankInventory.setTo(DankStats.values()[tier]);
            this.method_80();
            return true;
        }
        return false;
    }

    public boolean lock(int frequency) {
        if (frequency < this.getNextID()) {
            DankInventory dankInventory = this.getInventory(frequency);
            dankInventory.setFrequencyLock(true);
            this.method_80();
            return true;
        }
        return false;
    }

    public boolean unlock(int frequency) {
        if (frequency < this.getNextID()) {
            DankInventory dankInventory = this.getInventory(frequency);
            dankInventory.setFrequencyLock(false);
            this.method_80();
            return true;
        }
        return false;
    }
}

