/*
 * Decompiled with CFR 0.152.
 */
package com.hugman.dawn.mod.object.command;

import com.google.gson.JsonElement;
import com.hugman.dawn.mod.util.data.DataList;
import com.hugman.dawn.mod.util.data.DataSerialization;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_2408;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5458;
import net.minecraft.class_5475;
import net.minecraft.class_6903;
import net.minecraft.class_7403;

public class ExportCommand {
    private static final String REGISTRY_ENTRIES_DIRECTORY = "registry_entries";
    private static final String DYNAMIC_CONTENT_DIRECTORY = "dynamic_content";
    public static final int PERMISSION_LEVEL = 3;
    public static final String NAME = "export";
    public static final String REGISTRIES_ARG = "registries";
    public static final String EXPANDED_ARG = "expanded";
    public static final String DYNAMIC_ARG = "dynamic";
    public static final String BUILTIN_ARG = "builtin";

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)NAME).requires(sc -> sc.method_9259(3))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)REGISTRIES_ARG).executes(cc -> ExportCommand.exportRegistries((class_2168)cc.getSource(), false))).then(class_2170.method_9244((String)EXPANDED_ARG, (ArgumentType)BoolArgumentType.bool()).executes(cc -> ExportCommand.exportRegistries((class_2168)cc.getSource(), BoolArgumentType.getBool((CommandContext)cc, (String)EXPANDED_ARG)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)DYNAMIC_ARG).executes(cc -> ExportCommand.exportDynamic((class_2168)cc.getSource(), false))).then(class_2170.method_9244((String)BUILTIN_ARG, (ArgumentType)BoolArgumentType.bool()).executes(cc -> ExportCommand.exportDynamic((class_2168)cc.getSource(), BoolArgumentType.getBool((CommandContext)cc, (String)BUILTIN_ARG))))));
    }

    public static int exportRegistries(class_2168 source, boolean expanded) {
        Path exportPath = ExportCommand.getExportFolder(source, REGISTRY_ENTRIES_DIRECTORY);
        class_2561 exportFileComponent = ExportCommand.getFileComponent(exportPath);
        if (exportPath.toFile().exists()) {
            source.method_9213((class_2561)class_2561.method_43469((String)"commands.export.fail.already_exists", (Object[])new Object[]{exportFileComponent}));
            return 0;
        }
        source.method_9226((class_2561)class_2561.method_43471((String)"commands.export.start"), true);
        try {
            for (class_2378 registry : class_2378.field_11144) {
                ExportCommand.exportRegistry(registry, expanded, exportPath);
            }
            for (class_2378 registry : class_5458.field_25926) {
                ExportCommand.exportRegistry(registry, expanded, exportPath);
            }
            source.method_9226((class_2561)class_2561.method_43469((String)"commands.export.success", (Object[])new Object[]{exportFileComponent}), true);
        }
        catch (IOException e) {
            source.method_9213((class_2561)class_2561.method_43471((String)"commands.export.fail.unknown"));
            e.printStackTrace();
            return 0;
        }
        return 1;
    }

    public static int exportDynamic(class_2168 source, boolean builtin) {
        if (!source.method_9211().method_3724() && source.method_9211().method_3788() > 1) {
            source.method_9213((class_2561)class_2561.method_43471((String)"commands.export.dynamic.fail.multiplayer"));
            return 0;
        }
        Path exportPath = ExportCommand.getExportFolder(source, DYNAMIC_CONTENT_DIRECTORY);
        class_2561 exportFileComponent = ExportCommand.getFileComponent(exportPath);
        if (exportPath.toFile().exists()) {
            source.method_9213((class_2561)class_2561.method_43469((String)"commands.export.fail.already_exists", (Object[])new Object[]{exportFileComponent}));
            return 0;
        }
        source.method_9226((class_2561)class_2561.method_43471((String)"commands.export.start"), true);
        try {
            ExportCommand.generateDynamicFiles(builtin, source, exportPath);
            source.method_9226((class_2561)class_2561.method_43469((String)"commands.export.success", (Object[])new Object[]{exportFileComponent}), true);
            return 1;
        }
        catch (IOException e) {
            source.method_9213((class_2561)class_2561.method_43471((String)"commands.export.fail.unknown"));
            e.printStackTrace();
            return 0;
        }
    }

    public static <T> void exportRegistry(class_2378<T> registry, boolean expanded, Path exportPath) throws IOException {
        String[] modIds;
        class_2960 registryName = registry.method_30517().method_29177();
        for (String modId : modIds = (String[])registry.method_10235().stream().map(class_2960::method_12836).distinct().toArray(String[]::new)) {
            Path path = exportPath.resolve(modId).resolve(registryName.method_12836()).resolve(registryName.method_12832() + ".json");
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Set entries = registry.method_29722().stream().filter(entry -> ((class_5321)entry.getKey()).method_29177().method_12836().equals(modId)).collect(Collectors.toSet());
            DataList dataList = new DataList(entries.stream().map(DataSerialization.getMapperFromRegistry(expanded ? registry : null)).toList());
            DataSerialization.saveToFile(path.toFile(), dataList.getClass(), dataList);
        }
    }

    private static void generateDynamicFiles(boolean builtin, class_2168 source, Path exportPath) throws IOException {
        Files.createDirectories(exportPath, new FileAttribute[0]);
        class_2408.class_7404 writer = new class_2408.class_7404(class_155.method_16673().getName(), class_2408.method_43348((Path)exportPath, (Path)exportPath.resolve("reports")));
        class_5455.class_6893 manager = builtin ? class_5455.method_40314() : source.method_9225().method_30349();
        class_6903 ops = class_6903.method_40414((DynamicOps)JsonOps.INSTANCE, (class_5455)manager);
        for (class_5455.class_5456 info : class_5455.method_39674()) {
            ExportCommand.dumpRegistryCap(exportPath, (class_7403)writer, (class_5455)manager, (DynamicOps<JsonElement>)ops, info);
        }
    }

    private static <T> void dumpRegistryCap(Path exportPath, class_7403 writer, class_5455 manager, DynamicOps<JsonElement> ops, class_5455.class_5456<T> info) {
        class_5321 registryKey = info.comp_293();
        class_2378 registry = manager.method_30530(registryKey);
        for (Map.Entry entry : registry.method_29722()) {
            class_5321 key = (class_5321)entry.getKey();
            Path path = exportPath.resolve(key.method_29177().method_12836()).resolve(registryKey.method_29177().method_12836()).resolve(registryKey.method_29177().method_12832()).resolve(key.method_29177().method_12832() + ".json");
            class_5475.method_39680((Path)path, (class_7403)writer, ops, (Encoder)info.comp_294(), entry.getValue());
        }
    }

    public static Path getExportFolder(class_2168 source, String subFolderName) {
        return FabricLoader.getInstance().getGameDir().resolve("debug").resolve(NAME).resolve(subFolderName);
    }

    public static class_2561 getFileComponent(Path path) {
        return class_2561.method_43470((String)path.toString()).method_27695(new class_124[]{class_124.field_1078, class_124.field_1073}).method_27694(text -> text.method_10958(new class_2558(class_2558.class_2559.field_11746, path.toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"chat.fileExplorer.click"))));
    }
}

