/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities.client.model;

import foundationgames.enhancedblockentities.util.DateUtil;
import foundationgames.enhancedblockentities.util.duck.ModelStateHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public abstract class ModelSelector {
    private static final List<ModelSelector> REGISTRY = new ArrayList<ModelSelector>();
    public static final ModelSelector STATE_HOLDER_SELECTOR;
    public static final ModelSelector CHEST;
    public static final ModelSelector CHEST_WITH_CHRISTMAS;
    public static final ModelSelector BELL;
    public static final ModelSelector SHULKER_BOX;
    public final int id = REGISTRY.size();

    public abstract int getModelIndex(class_1920 var1, class_2680 var2, class_2338 var3, Supplier<class_5819> var4, @Nullable RenderContext var5);

    public ModelSelector() {
        REGISTRY.add(this);
    }

    public static ModelSelector fromId(int id) {
        return REGISTRY.get(id);
    }

    static {
        CHEST = STATE_HOLDER_SELECTOR = new ModelSelector(){

            @Override
            public int getModelIndex(class_1920 view, class_2680 state, class_2338 pos, Supplier<class_5819> rand, @Nullable RenderContext ctx) {
                class_2586 class_25862 = view.method_8321(pos);
                if (class_25862 instanceof ModelStateHolder) {
                    ModelStateHolder stateHolder = (ModelStateHolder)class_25862;
                    return stateHolder.getModelState();
                }
                return 0;
            }
        };
        CHEST_WITH_CHRISTMAS = new ModelSelector(){

            @Override
            public int getModelIndex(class_1920 view, class_2680 state, class_2338 pos, Supplier<class_5819> rand, @Nullable RenderContext ctx) {
                int os = DateUtil.isChristmas() ? 2 : 0;
                class_2586 class_25862 = view.method_8321(pos);
                if (class_25862 instanceof ModelStateHolder) {
                    ModelStateHolder stateHolder = (ModelStateHolder)class_25862;
                    return stateHolder.getModelState() + os;
                }
                return os;
            }
        };
        BELL = STATE_HOLDER_SELECTOR;
        SHULKER_BOX = STATE_HOLDER_SELECTOR;
    }
}

