/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities.config.gui.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.background.Background;
import dev.lambdaurora.spruceui.background.DirtTexturedBackground;
import dev.lambdaurora.spruceui.option.SpruceCyclingOption;
import dev.lambdaurora.spruceui.option.SpruceOption;
import dev.lambdaurora.spruceui.option.SpruceSeparatorOption;
import dev.lambdaurora.spruceui.screen.SpruceScreen;
import dev.lambdaurora.spruceui.util.RenderUtil;
import dev.lambdaurora.spruceui.widget.SpruceButtonWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceOptionListWidget;
import foundationgames.enhancedblockentities.EnhancedBlockEntities;
import foundationgames.enhancedblockentities.ReloadType;
import foundationgames.enhancedblockentities.config.EBEConfig;
import foundationgames.enhancedblockentities.config.gui.option.EBEOption;
import foundationgames.enhancedblockentities.config.gui.option.TextPalette;
import foundationgames.enhancedblockentities.util.EBEUtil;
import foundationgames.enhancedblockentities.util.GuiUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_757;
import net.minecraft.class_766;

public class EBEConfigScreen
extends SpruceScreen {
    private SpruceOptionListWidget optionsWidget;
    private List<EBEOption> options = new ArrayList<EBEOption>();
    private final class_437 parent;
    private static final ImmutableList<String> BOOLEAN_OPTIONS = ImmutableList.of((Object)"true", (Object)"false");
    private static final ImmutableList<String> ALLOWED_FORCED_DISABLED = ImmutableList.of((Object)"allowed", (Object)"forced", (Object)"disabled");
    private static final ImmutableList<String> SIGN_TEXT_OPTIONS = ImmutableList.of((Object)"smart", (Object)"all", (Object)"most", (Object)"some", (Object)"few");
    private static final class_2561 HOLD_SHIFT = class_2561.method_43471((String)"text.ebe.descriptions").method_27695(new class_124[]{class_124.field_1063, class_124.field_1056});
    private static final String CHEST_OPTIONS_TITLE = "text.ebe.chest_options";
    private static final String SIGN_OPTIONS_TITLE = "text.ebe.sign_options";
    private static final String BELL_OPTIONS_TITLE = "text.ebe.bell_options";
    private static final String BED_OPTIONS_TITLE = "text.ebe.bed_options";
    private static final String SHULKER_BOX_OPTIONS_TITLE = "text.ebe.shulker_box_options";
    private static final String ADVANCED_TITLE = "text.ebe.advanced";
    private static final class_2561 DUMP_LABEL = class_2561.method_43471((String)"option.ebe.dump");
    private final class_2561 dumpTooltip = GuiUtil.shorten(class_1074.method_4662((String)"option.ebe.dump.comment", (Object[])new Object[0]), 20, new class_124[0]);
    private final class_766 background = new class_766(class_442.field_17774);

    public EBEConfigScreen(class_437 screen) {
        super((class_2561)class_2561.method_43471((String)"screen.ebe.config"));
        this.parent = screen;
    }

    protected void method_25426() {
        super.method_25426();
        int bottomCenter = this.field_22789 / 2 - 50;
        this.optionsWidget = new SpruceOptionListWidget(Position.of((int)0, (int)34), this.field_22789, this.field_22790 - 69);
        this.options.clear();
        this.optionsWidget.setBackground((Background)new DirtTexturedBackground(32, 32, 32, 0));
        this.addOptions();
        this.method_37063((class_364)this.optionsWidget);
        this.method_37063((class_364)new SpruceButtonWidget(Position.of((int)(bottomCenter - 104), (int)(this.field_22790 - 27)), 100, 20, class_5244.field_24335, button -> this.method_25419()));
        this.method_37063((class_364)new SpruceButtonWidget(Position.of((int)bottomCenter, (int)(this.field_22790 - 27)), 100, 20, (class_2561)class_2561.method_43471((String)"text.ebe.apply"), button -> this.applyChanges()));
        this.method_37063((class_364)new SpruceButtonWidget(Position.of((int)(bottomCenter + 104), (int)(this.field_22790 - 27)), 100, 20, class_5244.field_24334, button -> {
            this.applyChanges();
            this.method_25419();
        }));
    }

    public void method_25420(class_4587 matrices) {
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (this.field_22787.field_1687 == null) {
            this.background.method_3317(delta, 1.0f);
            RenderSystem.setShader(class_757::method_34542);
        }
        this.method_25296(matrices, 0, 0, this.field_22789, this.field_22790, 0x4F141414, 0x4F141414);
        RenderUtil.renderBackgroundTexture((int)0, (int)0, (int)this.field_22789, (int)34, (float)0.0f);
        RenderUtil.renderBackgroundTexture((int)0, (int)(this.field_22790 - 35), (int)this.field_22789, (int)35, (float)0.0f);
        super.method_25394(matrices, mouseX, mouseY, delta);
        EBEConfigScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.field_22785, (int)((int)((double)this.field_22789 * 0.5)), (int)8, (int)0xFFFFFF);
        EBEConfigScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)HOLD_SHIFT, (int)((int)((double)this.field_22789 * 0.5)), (int)21, (int)0xFFFFFF);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public void applyChanges() {
        EBEConfig config = EnhancedBlockEntities.CONFIG;
        Properties properties = new Properties();
        AtomicReference<ReloadType> type = new AtomicReference<ReloadType>(ReloadType.NONE);
        this.options.forEach(option -> {
            if (!option.isDefault()) {
                type.set(((ReloadType)((Object)((Object)type.get()))).or(option.reloadType));
            }
            properties.setProperty(option.key, option.getValue());
        });
        config.readFrom(properties);
        config.save();
        EnhancedBlockEntities.reload(type.get());
    }

    public void addOptions() {
        Properties config = new Properties();
        EnhancedBlockEntities.CONFIG.writeTo(config);
        this.optionsWidget.addSingleOptionEntry((SpruceOption)new SpruceSeparatorOption(CHEST_OPTIONS_TITLE, true, null));
        this.optionsWidget.addSingleOptionEntry(this.option(new EBEOption("render_enhanced_chests", (List<String>)BOOLEAN_OPTIONS, BOOLEAN_OPTIONS.indexOf((Object)config.getProperty("render_enhanced_chests")), false, TextPalette.ON_OFF, ReloadType.RESOURCES)));
        this.optionsWidget.addSingleOptionEntry(this.option(new EBEOption("chest_ao", (List<String>)BOOLEAN_OPTIONS, BOOLEAN_OPTIONS.indexOf((Object)config.getProperty("chest_ao")), false, TextPalette.ON_OFF, ReloadType.RESOURCES)));
        this.optionsWidget.addOptionEntry(this.option(new EBEOption("experimental_chests", (List<String>)BOOLEAN_OPTIONS, BOOLEAN_OPTIONS.indexOf((Object)config.getProperty("experimental_chests")), false, TextPalette.ON_OFF, ReloadType.RESOURCES)), this.option(new EBEOption("christmas_chests", (List<String>)ALLOWED_FORCED_DISABLED, ALLOWED_FORCED_DISABLED.indexOf((Object)config.getProperty("christmas_chests")), true, TextPalette.rainbow(0.35f), ReloadType.WORLD)));
        this.optionsWidget.addSingleOptionEntry((SpruceOption)new SpruceSeparatorOption(SIGN_OPTIONS_TITLE, true, null));
        this.optionsWidget.addSingleOptionEntry(this.option(new EBEOption("render_enhanced_signs", (List<String>)BOOLEAN_OPTIONS, BOOLEAN_OPTIONS.indexOf((Object)config.getProperty("render_enhanced_signs")), false, TextPalette.ON_OFF, ReloadType.RESOURCES)));
        this.optionsWidget.addSingleOptionEntry(this.option(new EBEOption("sign_text_rendering", (List<String>)SIGN_TEXT_OPTIONS, SIGN_TEXT_OPTIONS.indexOf((Object)config.getProperty("sign_text_rendering")), true, TextPalette.rainbow(0.45f), ReloadType.NONE)));
        this.optionsWidget.addOptionEntry(this.option(new EBEOption("experimental_signs", (List<String>)BOOLEAN_OPTIONS, BOOLEAN_OPTIONS.indexOf((Object)config.getProperty("experimental_signs")), false, TextPalette.ON_OFF, ReloadType.RESOURCES)), this.option(new EBEOption("sign_ao", (List<String>)BOOLEAN_OPTIONS, BOOLEAN_OPTIONS.indexOf((Object)config.getProperty("sign_ao")), false, TextPalette.ON_OFF, ReloadType.RESOURCES)));
        this.optionsWidget.addSingleOptionEntry((SpruceOption)new SpruceSeparatorOption(BELL_OPTIONS_TITLE, true, null));
        this.optionsWidget.addSingleOptionEntry(this.option(new EBEOption("render_enhanced_bells", (List<String>)BOOLEAN_OPTIONS, BOOLEAN_OPTIONS.indexOf((Object)config.getProperty("render_enhanced_bells")), false, TextPalette.ON_OFF, ReloadType.RESOURCES)));
        this.optionsWidget.addSingleOptionEntry(this.option(new EBEOption("bell_ao", (List<String>)BOOLEAN_OPTIONS, BOOLEAN_OPTIONS.indexOf((Object)config.getProperty("bell_ao")), false, TextPalette.ON_OFF, ReloadType.RESOURCES)));
        this.optionsWidget.addSingleOptionEntry((SpruceOption)new SpruceSeparatorOption(BED_OPTIONS_TITLE, true, null));
        this.optionsWidget.addSingleOptionEntry(this.option(new EBEOption("render_enhanced_beds", (List<String>)BOOLEAN_OPTIONS, BOOLEAN_OPTIONS.indexOf((Object)config.getProperty("render_enhanced_beds")), false, TextPalette.ON_OFF, ReloadType.RESOURCES)));
        this.optionsWidget.addOptionEntry(this.option(new EBEOption("experimental_beds", (List<String>)BOOLEAN_OPTIONS, BOOLEAN_OPTIONS.indexOf((Object)config.getProperty("experimental_beds")), false, TextPalette.ON_OFF, ReloadType.RESOURCES)), this.option(new EBEOption("bed_ao", (List<String>)BOOLEAN_OPTIONS, BOOLEAN_OPTIONS.indexOf((Object)config.getProperty("bed_ao")), false, TextPalette.ON_OFF, ReloadType.RESOURCES)));
        this.optionsWidget.addSingleOptionEntry((SpruceOption)new SpruceSeparatorOption(SHULKER_BOX_OPTIONS_TITLE, true, null));
        this.optionsWidget.addSingleOptionEntry(this.option(new EBEOption("render_enhanced_shulker_boxes", (List<String>)BOOLEAN_OPTIONS, BOOLEAN_OPTIONS.indexOf((Object)config.getProperty("render_enhanced_shulker_boxes")), false, TextPalette.ON_OFF, ReloadType.RESOURCES)));
        this.optionsWidget.addSingleOptionEntry(this.option(new EBEOption("shulker_box_ao", (List<String>)BOOLEAN_OPTIONS, BOOLEAN_OPTIONS.indexOf((Object)config.getProperty("shulker_box_ao")), false, TextPalette.ON_OFF, ReloadType.RESOURCES)));
        this.optionsWidget.addSingleOptionEntry((SpruceOption)new SpruceSeparatorOption(ADVANCED_TITLE, true, null));
        this.optionsWidget.addSingleOptionEntry((SpruceOption)new SpruceCyclingOption("option.ebe.dump", i -> {
            try {
                EBEUtil.dumpResources();
            }
            catch (IOException e) {
                EnhancedBlockEntities.LOG.error((Object)e);
            }
        }, o -> DUMP_LABEL, this.dumpTooltip));
    }

    private SpruceOption option(EBEOption option) {
        this.options.add(option);
        return new SpruceCyclingOption(option.getOptionKey(), i -> option.next(), o -> option.getText(), (class_2561)option.getTooltip());
    }
}

