/*
 * Decompiled with CFR 0.152.
 */
package com.rebelkeithy.extendedarmorbars.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.rebelkeithy.extendedarmorbars.config.Config;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigLoader {
    private static final String CONFIG_DIR = FabricLoader.getInstance().getConfigDir() + "\\";

    public Config loadConfigFile(String filename) {
        Config config;
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            config = (Config)gson.fromJson((Reader)new FileReader(new File(CONFIG_DIR, filename)), Config.class);
        }
        catch (FileNotFoundException e) {
            System.out.println("Generating config file for mod: toughness bars.");
            config = new Config();
        }
        this.saveConfigFile(filename, config);
        return config;
    }

    public void saveConfigFile(String filename, Config config) {
        try {
            FileWriter writer = new FileWriter(CONFIG_DIR + filename);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson((Object)config, (Appendable)writer);
            writer.flush();
            writer.close();
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }
}

