/*
 * Decompiled with CFR 0.152.
 */
package com.nhoryzon.mc.farmersdelight.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.nhoryzon.mc.farmersdelight.registry.EffectsRegistry;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5134;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class ComfortHealthOverlay {
    public static ComfortHealthOverlay INSTANCE;
    private static final class_2960 MOD_ICONS_TEXTURE;
    public static int healthIconsOffset;

    public static void init() {
        INSTANCE = new ComfortHealthOverlay();
    }

    public void onRender(class_4587 matrixStack) {
        boolean isMounted;
        class_310 mc = class_310.method_1551();
        boolean bl = isMounted = mc.field_1724 != null && mc.field_1724.method_5854() instanceof class_1309;
        if (!isMounted && !mc.field_1690.field_1842) {
            this.renderComfortOverlay(matrixStack);
        }
    }

    private void renderComfortOverlay(class_4587 matrixStack) {
        boolean isPlayerEligibleForComfort;
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        class_1702 stats = player.method_7344();
        int top = mc.method_22683().method_4502() - healthIconsOffset;
        int left = mc.method_22683().method_4486() / 2 - 91;
        boolean bl = isPlayerEligibleForComfort = stats.method_7589() == 0.0f && player.method_7317() && !player.method_6059(class_1294.field_5924);
        if (player.method_6112(EffectsRegistry.COMFORT.get()) != null && isPlayerEligibleForComfort) {
            this.drawComfortOverlay((class_1657)player, mc, matrixStack, left, top);
        }
    }

    private void drawComfortOverlay(class_1657 player, class_310 mc, class_4587 matrixStack, int left, int top) {
        int ticks = mc.field_1705.method_1738();
        Random rand = new Random();
        rand.setSeed((long)ticks * 312871L);
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (class_2960)MOD_ICONS_TEXTURE);
        int health = class_3532.method_15386((float)player.method_6032());
        class_1324 attrMaxHealth = player.method_5996(class_5134.field_23716);
        if (attrMaxHealth != null) {
            float healthMax = (float)attrMaxHealth.method_6194();
            int regen = -1;
            if (player.method_6059(class_1294.field_5924)) {
                regen = ticks % 25;
            }
            int comfortSheen = ticks % 50;
            int comfortHeartFrame = comfortSheen % 2;
            int[] textureWidth = new int[]{5, 9};
            RenderSystem.setShaderTexture((int)0, (class_2960)MOD_ICONS_TEXTURE);
            RenderSystem.enableBlend();
            int healthMaxSingleRow = class_3532.method_15386((float)(Math.min(healthMax, 20.0f) / 2.0f));
            for (int i = 0; i < healthMaxSingleRow; ++i) {
                int column = i % 10;
                int x = left + column * 8;
                int y = top;
                Object object = FabricLoader.getInstance().getObjectShare().get("raised:distance");
                if (object instanceof Integer) {
                    Integer distance = (Integer)object;
                    y -= distance.intValue();
                }
                if (health <= 4) {
                    y += rand.nextInt(2);
                }
                if (i == regen) {
                    y -= 2;
                }
                if (column == comfortSheen / 2) {
                    mc.field_1705.method_25302(matrixStack, x, y, 0, 9, textureWidth[comfortHeartFrame], 9);
                }
                if (column != comfortSheen / 2 - 1 || comfortHeartFrame != 0) continue;
                mc.field_1705.method_25302(matrixStack, x + 5, y, 5, 9, 4, 9);
            }
        }
        RenderSystem.disableBlend();
        RenderSystem.setShaderTexture((int)0, (class_2960)class_332.field_22737);
    }

    static {
        MOD_ICONS_TEXTURE = new class_2960("farmersdelight", "textures/gui/fd_icons.png");
        healthIconsOffset = 39;
    }
}

