/*
 * Decompiled with CFR 0.152.
 */
package com.nhoryzon.mc.farmersdelight.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.nhoryzon.mc.farmersdelight.FarmersDelightMod;
import com.nhoryzon.mc.farmersdelight.block.SkilletBlock;
import com.nhoryzon.mc.farmersdelight.entity.block.SkilletBlockEntity;
import com.nhoryzon.mc.farmersdelight.item.ModItemSettings;
import com.nhoryzon.mc.farmersdelight.registry.BlocksRegistry;
import com.nhoryzon.mc.farmersdelight.registry.SoundsRegistry;
import com.nhoryzon.mc.farmersdelight.registry.TagsRegistry;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1277;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1834;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3920;
import net.minecraft.class_3956;
import net.minecraft.class_4538;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;

public class SkilletItem
extends class_1747 {
    public static final Set<class_1887> ALLOWED_ENCHANTMENTS = Set.of(class_1893.field_9109, class_1893.field_9118, class_1893.field_9123, class_1893.field_9112, class_1893.field_9121, class_1893.field_9124, class_1893.field_9110, class_1893.field_9101, class_1893.field_9119);
    public static final String TAG_KEY_SKILLET_COOK_TIME_HANDHELD = "CookTimeHandheld";
    public static final String TAG_KEY_SKILLET_COOKING = "Cooking";
    public static final class_1834 SKILLET_MATERIAL = class_1834.field_8923;
    private final Multimap<class_1320, class_1322> toolAttributes;

    public SkilletItem() {
        super(BlocksRegistry.SKILLET.get(), (class_1792.class_1793)new ModItemSettings().maxCount(1).maxDamageIfAbsent(SKILLET_MATERIAL.method_8025()));
        float attackDamage = 5.0f + SKILLET_MATERIAL.method_8028();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Tool modifier", (double)attackDamage, class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Tool modifier", (double)-3.1f, class_1322.class_1323.field_6328));
        this.toolAttributes = builder.build();
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        stack.method_7956(1, attacker, player -> player.method_20235(class_1304.field_6173));
        return true;
    }

    private static boolean isPlayerNearHeatSource(class_1657 player, class_4538 world) {
        if (player.method_5809()) {
            return true;
        }
        class_2338 pos = player.method_24515();
        for (class_2338 nearbyPos : class_2338.method_10097((class_2338)pos.method_10069(-1, -1, -1), (class_2338)pos.method_10069(1, 1, 1))) {
            if (!world.method_8320(nearbyPos).method_26164(TagsRegistry.HEAT_SOURCES)) continue;
            return true;
        }
        return false;
    }

    public int method_7881(class_1799 stack) {
        int fireAspectLevel = class_1890.method_8225((class_1887)class_1893.field_9124, (class_1799)stack);
        int cookingTime = stack.method_7948().method_10550(TAG_KEY_SKILLET_COOK_TIME_HANDHELD);
        return SkilletBlock.getSkilletCookingTime(cookingTime, fireAspectLevel);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 skilletStack = player.method_5998(hand);
        if (SkilletItem.isPlayerNearHeatSource(player, (class_4538)world)) {
            class_1268 otherHand = hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808;
            class_1799 cookingStack = player.method_5998(otherHand);
            if (skilletStack.method_7948().method_10545(TAG_KEY_SKILLET_COOKING)) {
                player.method_6019(hand);
                return class_1271.method_22430((Object)skilletStack);
            }
            Optional<class_3920> recipe = SkilletItem.getCookingRecipe(cookingStack, world);
            if (recipe.isPresent()) {
                class_1799 cookingStackCopy = cookingStack.method_7972();
                class_1799 cookingStackUnit = cookingStackCopy.method_7971(1);
                skilletStack.method_7948().method_10566(TAG_KEY_SKILLET_COOKING, (class_2520)cookingStackUnit.method_7953(new class_2487()));
                skilletStack.method_7948().method_10569(TAG_KEY_SKILLET_COOK_TIME_HANDHELD, recipe.get().method_8167());
                player.method_6019(hand);
                player.method_6122(otherHand, cookingStackCopy);
                return class_1271.method_22428((Object)skilletStack);
            }
            player.method_7353((class_2561)FarmersDelightMod.i18n("item.skillet.how_to_cook", new Object[0]), true);
        }
        return class_1271.method_22430((Object)skilletStack);
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            class_243 pos = player.method_19538();
            double x = pos.method_10216() + 0.5;
            double y = pos.method_10214();
            double z = pos.method_10215() + 0.5;
            if (world.field_9229.method_43048(50) == 0) {
                world.method_8486(x, y, z, SoundsRegistry.BLOCK_SKILLET_SIZZLE.get(), class_3419.field_15245, 0.4f, world.field_9229.method_43057() * 0.2f + 0.9f, false);
            }
        }
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (!(user instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)user;
        class_2487 tag = stack.method_7948();
        if (tag.method_10545(TAG_KEY_SKILLET_COOKING)) {
            class_1799 cookingStack = class_1799.method_7915((class_2487)tag.method_10562(TAG_KEY_SKILLET_COOKING));
            player.method_31548().method_7398(cookingStack);
            tag.method_10551(TAG_KEY_SKILLET_COOKING);
            tag.method_10551(TAG_KEY_SKILLET_COOK_TIME_HANDHELD);
        }
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        if (!(user instanceof class_1657)) {
            return stack;
        }
        class_1657 player = (class_1657)user;
        class_2487 tag = stack.method_7948();
        if (tag.method_10545(TAG_KEY_SKILLET_COOKING)) {
            class_1799 cookingStack = class_1799.method_7915((class_2487)tag.method_10562(TAG_KEY_SKILLET_COOKING));
            Optional<class_3920> recipe = SkilletItem.getCookingRecipe(cookingStack, world);
            recipe.ifPresent(campfireCookingRecipe -> {
                class_1799 resultStack = campfireCookingRecipe.method_8116((class_1263)new class_1277(new class_1799[0]));
                if (!player.method_31548().method_7394(resultStack)) {
                    player.method_7328(resultStack, false);
                }
                if (player instanceof class_3222) {
                    class_174.field_1198.method_8821((class_3222)player, stack);
                }
            });
            tag.method_10551(TAG_KEY_SKILLET_COOKING);
            tag.method_10551(TAG_KEY_SKILLET_COOK_TIME_HANDHELD);
        }
        return stack;
    }

    public static Optional<class_3920> getCookingRecipe(class_1799 stack, class_1937 world) {
        if (stack.method_7960()) {
            return Optional.empty();
        }
        return world.method_8433().method_8132(class_3956.field_17549, (class_1263)new class_1277(new class_1799[]{stack}), world);
    }

    protected boolean method_7710(class_2338 pos, class_1937 world, @Nullable class_1657 player, class_1799 stack, class_2680 state) {
        super.method_7710(pos, world, player, stack, state);
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof SkilletBlockEntity) {
            SkilletBlockEntity skilletBlockEntity = (SkilletBlockEntity)blockEntity;
            skilletBlockEntity.setSkilletItem(stack);
            return true;
        }
        return false;
    }

    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return SKILLET_MATERIAL.method_8023().method_8093(ingredient) || super.method_7878(stack, ingredient);
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        if (!world.method_8608() && state.method_26214((class_1922)world, pos) != 0.0f) {
            stack.method_7956(1, miner, entity -> entity.method_20235(class_1304.field_6173));
        }
        return true;
    }

    public class_1269 method_7712(class_1750 context) {
        class_1657 player = context.method_8036();
        if (player != null && player.method_5715()) {
            return super.method_7712(context);
        }
        return class_1269.field_5811;
    }

    public int method_7837() {
        return SKILLET_MATERIAL.method_8026();
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return slot == class_1304.field_6173 ? this.toolAttributes : super.method_7844(slot);
    }
}

