/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.blay09.mods.balm.mixin.ScreenAccessor;
import net.blay09.mods.farmingforblockheads.api.IMarketCategory;
import net.blay09.mods.farmingforblockheads.api.IMarketEntry;
import net.blay09.mods.farmingforblockheads.client.gui.widget.MarketFilterButton;
import net.blay09.mods.farmingforblockheads.menu.MarketClientMenu;
import net.blay09.mods.farmingforblockheads.menu.MarketMenu;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5250;

public class MarketScreen
extends class_465<MarketMenu> {
    private static final int SCROLLBAR_COLOR = -5592406;
    private static final int SCROLLBAR_Y = 8;
    private static final int SCROLLBAR_WIDTH = 7;
    private static final int SCROLLBAR_HEIGHT = 77;
    private static final int VISIBLE_ROWS = 4;
    private static final class_2960 TEXTURE = new class_2960("farmingforblockheads", "textures/gui/market.png");
    private final List<MarketFilterButton> filterButtons = Lists.newArrayList();
    private final MarketClientMenu clientContainer;
    private int scrollBarScaledHeight;
    private int scrollBarXPos;
    private int scrollBarYPos;
    private int currentOffset;
    private int mouseClickY = -1;
    private int indexWhenClicked;
    private int lastNumberOfMoves;
    private class_342 searchBar;

    public MarketScreen(MarketMenu container, class_1661 playerInventory, class_2561 displayName) {
        super((class_1703)container, playerInventory, displayName);
        this.clientContainer = (MarketClientMenu)container;
    }

    public void method_25426() {
        this.field_2779 = 174;
        super.method_25426();
        class_327 font = class_310.method_1551().field_1772;
        this.searchBar = new class_342(font, this.field_2776 + this.field_2792 - 78, this.field_2800 - 5, 70, 10, this.searchBar, (class_2561)class_2561.method_43473());
        this.method_20085((class_364)this.searchBar);
        this.method_37063((class_364)this.searchBar);
        this.updateCategoryFilters();
        this.recalculateScrollBar();
    }

    private void updateCategoryFilters() {
        IMarketCategory[] categories;
        for (MarketFilterButton filterButton : this.filterButtons) {
            ((ScreenAccessor)this).balm_getChildren().remove((Object)filterButton);
            ((ScreenAccessor)this).balm_getRenderables().remove((Object)filterButton);
            ((ScreenAccessor)this).balm_getNarratables().remove((Object)filterButton);
        }
        this.filterButtons.clear();
        int curY = -80;
        for (IMarketCategory category : categories = (IMarketCategory[])this.clientContainer.getCategories().stream().sorted().toArray(IMarketCategory[]::new)) {
            MarketFilterButton filterButton = new MarketFilterButton(this.field_22789 / 2 + 87, this.field_22790 / 2 + curY, this.clientContainer, category, button -> {
                if (this.clientContainer.getCurrentCategory() == category) {
                    this.clientContainer.setFilterCategory(null);
                } else {
                    this.clientContainer.setFilterCategory(category);
                }
                this.clientContainer.populateMarketSlots();
                this.setCurrentOffset(this.currentOffset);
            });
            this.method_37063((class_364)filterButton);
            this.filterButtons.add(filterButton);
            curY += 20;
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (Math.abs(delta) > 0.0) {
            this.setCurrentOffset(delta > 0.0 ? this.currentOffset - 1 : this.currentOffset + 1);
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button != -1 && this.mouseClickY != -1) {
            this.mouseClickY = -1;
            this.indexWhenClicked = 0;
            this.lastNumberOfMoves = 0;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 1 && mouseX >= (double)this.searchBar.field_22760 && mouseX < (double)(this.searchBar.field_22760 + this.searchBar.method_25368()) && mouseY >= (double)this.searchBar.field_22761 && mouseY < (double)(this.searchBar.field_22761 + this.searchBar.method_25364())) {
            this.searchBar.method_1852("");
            this.clientContainer.search(null);
            this.clientContainer.populateMarketSlots();
            this.setCurrentOffset(this.currentOffset);
            return true;
        }
        if (mouseX >= (double)this.scrollBarXPos && mouseX <= (double)(this.scrollBarXPos + 7) && mouseY >= (double)this.scrollBarYPos && mouseY <= (double)(this.scrollBarYPos + this.scrollBarScaledHeight)) {
            this.mouseClickY = (int)mouseY;
            this.indexWhenClicked = this.currentOffset;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25400(char c, int keyCode) {
        boolean result = super.method_25400(c, keyCode);
        this.clientContainer.search(this.searchBar.method_1882());
        this.clientContainer.populateMarketSlots();
        this.setCurrentOffset(this.currentOffset);
        return result;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.searchBar.method_25404(keyCode, scanCode, modifiers) || this.searchBar.method_25370()) {
            if (keyCode == 256) {
                this.field_22787.field_1724.method_7346();
            } else {
                this.clientContainer.search(this.searchBar.method_1882());
                this.clientContainer.populateMarketSlots();
                this.setCurrentOffset(this.currentOffset);
            }
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(poseStack);
        super.method_25394(poseStack, mouseX, mouseY, partialTicks);
        for (MarketFilterButton sortButton : this.filterButtons) {
            if (!sortButton.method_25405(mouseX, mouseY) || !sortButton.field_22763) continue;
            this.method_30901(poseStack, sortButton.getTooltipLines(), mouseX, mouseY);
        }
        this.method_2380(poseStack, mouseX, mouseY);
    }

    protected void method_2389(class_4587 poseStack, float partialTicks, int mouseX, int mouseY) {
        int numberOfFiltersMoved;
        float pixelsPerFilter;
        if (this.clientContainer.isDirty()) {
            this.updateCategoryFilters();
            this.recalculateScrollBar();
            this.clientContainer.setDirty(false);
        }
        class_327 font = this.field_22787.field_1772;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        this.method_25302(poseStack, this.field_2776, this.field_2800 - 10, 0, 0, this.field_2792, this.field_2779 + 10);
        if (((MarketMenu)this.field_2797).getSelectedEntry() != null && !((MarketMenu)this.field_2797).isReadyToBuy()) {
            this.method_25302(poseStack, this.field_2776 + 43, this.field_2800 + 40, 176, 0, 14, 14);
        }
        if (this.mouseClickY != -1 && (pixelsPerFilter = (float)(77 - this.scrollBarScaledHeight) / (float)Math.max(1, (int)Math.ceil((float)this.clientContainer.getFilteredListCount() / 3.0f) - 4)) != 0.0f && (numberOfFiltersMoved = (int)((float)(mouseY - this.mouseClickY) / pixelsPerFilter)) != this.lastNumberOfMoves) {
            this.setCurrentOffset(this.indexWhenClicked + numberOfFiltersMoved);
            this.lastNumberOfMoves = numberOfFiltersMoved;
        }
        font.method_1720(poseStack, class_1074.method_4662((String)"container.farmingforblockheads.market", (Object[])new Object[0]), (float)(this.field_2776 + 10), (float)(this.field_2800 + 10), 0xFFFFFF);
        if (((MarketMenu)this.field_2797).getSelectedEntry() == null) {
            MarketScreen.method_25300((class_4587)poseStack, (class_327)font, (String)class_1074.method_4662((String)"gui.farmingforblockheads:market.no_selection", (Object[])new Object[0]), (int)(this.field_2776 + 49), (int)(this.field_2800 + 65), (int)0xFFFFFF);
        } else {
            MarketScreen.method_27534((class_4587)poseStack, (class_327)font, (class_2561)MarketScreen.getPriceText(((MarketMenu)this.field_2797).getSelectedEntry()), (int)(this.field_2776 + 49), (int)(this.field_2800 + 65), (int)0xFFFFFF);
        }
        MarketScreen.method_25294((class_4587)poseStack, (int)this.scrollBarXPos, (int)this.scrollBarYPos, (int)(this.scrollBarXPos + 7), (int)(this.scrollBarYPos + this.scrollBarScaledHeight), (int)-5592406);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void method_2388(class_4587 poseStack, int x, int y) {
    }

    public Collection<MarketFilterButton> getFilterButtons() {
        return this.filterButtons;
    }

    private void recalculateScrollBar() {
        int scrollBarTotalHeight = 76;
        this.scrollBarScaledHeight = (int)((double)scrollBarTotalHeight * Math.min(1.0, 4.0 / Math.ceil((float)this.clientContainer.getFilteredListCount() / 3.0f)));
        this.scrollBarXPos = this.field_2776 + this.field_2792 - 7 - 9;
        this.scrollBarYPos = this.field_2800 + 8 + (scrollBarTotalHeight - this.scrollBarScaledHeight) * this.currentOffset / Math.max(1, (int)Math.ceil((float)this.clientContainer.getFilteredListCount() / 3.0f) - 4);
    }

    private void setCurrentOffset(int currentOffset) {
        this.currentOffset = Math.max(0, Math.min(currentOffset, (int)Math.ceil((float)this.clientContainer.getFilteredListCount() / 3.0f) - 4));
        this.clientContainer.setScrollOffset(this.currentOffset);
        this.recalculateScrollBar();
    }

    public static class_2561 getPriceText(IMarketEntry entry) {
        class_5250 textComponent = class_2561.method_43469((String)"gui.farmingforblockheads:market.cost", (Object[])new Object[]{entry.getCostItem().method_7947(), entry.getCostItem().method_7954()});
        textComponent.method_27692(MarketScreen.getPriceColor(entry));
        return textComponent;
    }

    public static class_124 getPriceColor(IMarketEntry entry) {
        class_124 color = class_124.field_1060;
        String unlocalizedName = entry.getCostItem().method_7922().toLowerCase(Locale.ENGLISH);
        if (unlocalizedName.contains("diamond")) {
            color = class_124.field_1075;
        } else if (unlocalizedName.contains("gold")) {
            color = class_124.field_1054;
        } else if (unlocalizedName.contains("iron")) {
            color = class_124.field_1068;
        }
        return color;
    }
}

