/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.menu;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.farmingforblockheads.api.IMarketCategory;
import net.blay09.mods.farmingforblockheads.api.IMarketEntry;
import net.blay09.mods.farmingforblockheads.menu.MarketFakeSlot;
import net.blay09.mods.farmingforblockheads.menu.MarketMenu;
import net.blay09.mods.farmingforblockheads.network.MarketSelectMessage;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_2338;
import org.jetbrains.annotations.Nullable;

public class MarketClientMenu
extends MarketMenu {
    private final List<IMarketCategory> categoryList = Lists.newArrayList();
    private final List<IMarketEntry> itemList = Lists.newArrayList();
    private final List<IMarketEntry> filteredItems = Lists.newArrayList();
    private final Comparator<IMarketEntry> comparator = Comparator.comparingInt(o -> o.getCategory().getSortIndex());
    private String currentSearch;
    private IMarketCategory currentCategory;
    private boolean isDirty;
    private int scrollOffset;

    public MarketClientMenu(int windowId, class_1661 playerInventory, class_2338 pos) {
        super(windowId, playerInventory, pos);
    }

    public void method_7593(int slotNumber, int dragType, class_1713 clickType, class_1657 player) {
        if (slotNumber >= 0 && slotNumber < this.field_7761.size()) {
            MarketFakeSlot marketSlot;
            IMarketEntry entry;
            class_1735 slot = (class_1735)this.field_7761.get(slotNumber);
            if (player.field_6002.field_9236 && slot instanceof MarketFakeSlot && (entry = (marketSlot = (MarketFakeSlot)slot).getEntry()) != null) {
                this.selectedEntry = entry;
                Balm.getNetworking().sendToServer((Object)new MarketSelectMessage(entry.getEntryId(), clickType == class_1713.field_7794));
            }
        }
    }

    public void search(@Nullable String term) {
        this.currentSearch = term;
        this.applyFilters();
    }

    public void setFilterCategory(@Nullable IMarketCategory category) {
        this.currentCategory = category;
        this.applyFilters();
    }

    private void applyFilters() {
        boolean hasSearchFilter;
        this.scrollOffset = 0;
        this.filteredItems.clear();
        boolean bl = hasSearchFilter = this.currentSearch != null && !this.currentSearch.trim().isEmpty();
        if (this.currentCategory == null && !hasSearchFilter) {
            this.filteredItems.addAll(this.itemList);
        } else {
            for (IMarketEntry entry : this.itemList) {
                String itemName = entry.getOutputItem().method_7954().getString();
                if (hasSearchFilter && !itemName.toLowerCase(Locale.ENGLISH).contains(this.currentSearch.toLowerCase()) || this.currentCategory != null && !this.currentCategory.passes(entry)) continue;
                this.filteredItems.add(entry);
            }
        }
        this.filteredItems.sort(this.comparator);
    }

    public int getFilteredListCount() {
        return this.filteredItems.size();
    }

    public void setScrollOffset(int scrollOffset) {
        this.scrollOffset = scrollOffset;
        this.populateMarketSlots();
    }

    public void populateMarketSlots() {
        int i = this.scrollOffset * 3;
        for (MarketFakeSlot slot : this.marketSlots) {
            if (i < this.filteredItems.size()) {
                slot.setEntry(this.filteredItems.get(i));
                ++i;
                continue;
            }
            slot.setEntry(null);
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public void setCategoryList(Collection<IMarketCategory> categoryList) {
        this.categoryList.clear();
        this.categoryList.addAll(categoryList);
        this.setDirty(true);
    }

    public void setEntryList(Collection<IMarketEntry> entryList) {
        this.itemList.clear();
        this.itemList.addAll(entryList);
        this.applyFilters();
        this.populateMarketSlots();
        this.setDirty(true);
    }

    @Override
    public boolean isReadyToBuy() {
        return this.canBuy.method_17407() == 1;
    }

    @Nullable
    public IMarketCategory getCurrentCategory() {
        return this.currentCategory;
    }

    public Collection<IMarketCategory> getCategories() {
        return this.categoryList;
    }
}

