/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientReloadShadersEvent;
import dev.architectury.event.events.client.ClientScreenInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.hooks.client.screen.ScreenAccess;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.platform.Platform;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.ftb.mods.ftbchunks.ColorMapLoader;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBChunksCommon;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.client.ChunkScreen;
import dev.ftb.mods.ftbchunks.client.EntityIcons;
import dev.ftb.mods.ftbchunks.client.EntityMapIcon;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import dev.ftb.mods.ftbchunks.client.FTBChunksRenderTypes;
import dev.ftb.mods.ftbchunks.client.LargeMapScreen;
import dev.ftb.mods.ftbchunks.client.MapIconComparator;
import dev.ftb.mods.ftbchunks.client.MapType;
import dev.ftb.mods.ftbchunks.client.MinimapBlurMode;
import dev.ftb.mods.ftbchunks.client.MinimapPosition;
import dev.ftb.mods.ftbchunks.client.VisibleClientPlayers;
import dev.ftb.mods.ftbchunks.client.WaypointEditorScreen;
import dev.ftb.mods.ftbchunks.client.WaypointMapIcon;
import dev.ftb.mods.ftbchunks.client.fabric.FTBChunksClientImpl;
import dev.ftb.mods.ftbchunks.client.map.ChunkUpdateTask;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.MapRegion;
import dev.ftb.mods.ftbchunks.client.map.MapRegionData;
import dev.ftb.mods.ftbchunks.client.map.MapTask;
import dev.ftb.mods.ftbchunks.client.map.RegionSyncKey;
import dev.ftb.mods.ftbchunks.client.map.UpdateChunkFromServerTask;
import dev.ftb.mods.ftbchunks.client.map.Waypoint;
import dev.ftb.mods.ftbchunks.client.map.WaypointManager;
import dev.ftb.mods.ftbchunks.client.map.WaypointType;
import dev.ftb.mods.ftbchunks.client.map.color.ColorUtils;
import dev.ftb.mods.ftbchunks.integration.InWorldMapIcon;
import dev.ftb.mods.ftbchunks.integration.MapIcon;
import dev.ftb.mods.ftbchunks.integration.MapIconEvent;
import dev.ftb.mods.ftbchunks.integration.RefreshMinimapIconsEvent;
import dev.ftb.mods.ftbchunks.integration.TrackedPlayerMapIcon;
import dev.ftb.mods.ftbchunks.net.LoginDataPacket;
import dev.ftb.mods.ftbchunks.net.PartialPackets;
import dev.ftb.mods.ftbchunks.net.PlayerDeathPacket;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftbchunks.net.SendManyChunksPacket;
import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigFromStringScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.FaceIcon;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.ui.CustomClickEvent;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.event.ClientTeamPropertiesChangedEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1011;
import net.minecraft.class_1041;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2626;
import net.minecraft.class_2637;
import net.minecraft.class_2672;
import net.minecraft.class_2680;
import net.minecraft.class_276;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_3264;
import net.minecraft.class_327;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_3965;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5321;
import net.minecraft.class_5481;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;

public class FTBChunksClient
extends FTBChunksCommon {
    private static final class_2960 BUTTON_ID_MAP = new class_2960("ftbchunks:open_gui");
    private static final class_2960 BUTTON_ID_CLAIM = new class_2960("ftbchunks:open_claim_gui");
    public static final class_2960 CIRCLE_MASK = new class_2960("ftbchunks:textures/circle_mask.png");
    public static final class_2960 CIRCLE_BORDER = new class_2960("ftbchunks:textures/circle_border.png");
    public static final class_2960 SQUARE_MASK = new class_2960("ftbchunks:textures/square_mask.png");
    public static final class_2960 SQUARE_BORDER = new class_2960("ftbchunks:textures/square_border.png");
    public static final class_2960 PLAYER = new class_2960("ftbchunks:textures/player.png");
    public static final class_2960[] COMPASS = new class_2960[]{new class_2960("ftbchunks:textures/compass_e.png"), new class_2960("ftbchunks:textures/compass_n.png"), new class_2960("ftbchunks:textures/compass_w.png"), new class_2960("ftbchunks:textures/compass_s.png")};
    private static final Map<UUID, TrackedPlayerMapIcon> longRangePlayerTracker = new HashMap<UUID, TrackedPlayerMapIcon>();
    private static final ArrayDeque<MapTask> taskQueue = new ArrayDeque();
    private static final Map<class_1923, IntOpenHashSet> rerenderCache = new HashMap<class_1923, IntOpenHashSet>();
    private static long taskQueueTicks = 0L;
    public static class_304 openMapKey;
    public static class_304 openClaimManagerKey;
    public static class_304 zoomInKey;
    public static class_304 zoomOutKey;
    public static class_304 addWaypointKey;
    public static class_304 waypointManagerKey;
    public static int minimapTextureId;
    private int currentPlayerChunkX;
    private int currentPlayerChunkZ;
    private double currentPlayerX;
    private double currentPlayerY;
    private double currentPlayerZ;
    private double prevPlayerX;
    private double prevPlayerY;
    private double prevPlayerZ;
    private static int renderedDebugCount;
    public static boolean updateMinimap;
    public static boolean alwaysRenderChunksOnMap;
    public static SendGeneralDataPacket generalData;
    private long nextRegionSave = 0L;
    private double prevZoom = (Double)FTBChunksClientConfig.MINIMAP_ZOOM.get();
    private long lastZoomTime = 0L;
    private final List<MapIcon> mapIcons = new ArrayList<MapIcon>();
    private final List<InWorldMapIcon> inWorldMapIcons = new ArrayList<InWorldMapIcon>();
    private long lastMapIconUpdate = 0L;
    private static class_1159 worldMatrix;
    private static class_243 cameraPos;

    @Override
    public void init() {
        if (class_310.method_1551() == null) {
            return;
        }
        FTBChunksClientConfig.init();
        FTBChunksClient.registerKeys();
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_3302)new EntityIcons());
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_3302)new ColorMapLoader());
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(this::loggedOut);
        CustomClickEvent.EVENT.register(this::customClick);
        ClientRawInputEvent.KEY_PRESSED.register(this::keyPressed);
        ClientScreenInputEvent.KEY_PRESSED_PRE.register(this::keyPressed);
        ClientGuiEvent.RENDER_HUD.register(this::renderHud);
        ClientGuiEvent.INIT_PRE.register(this::screenOpened);
        ClientTickEvent.CLIENT_PRE.register(this::clientTick);
        TeamEvent.CLIENT_PROPERTIES_CHANGED.register(this::teamPropertiesChanged);
        MapIconEvent.LARGE_MAP.register(this::mapIcons);
        MapIconEvent.MINIMAP.register(this::mapIcons);
        RefreshMinimapIconsEvent.EVENT.register(this::refreshMinimapIcons);
        ClientReloadShadersEvent.EVENT.register(this::reloadShaders);
        FTBChunksClient.registerPlatform();
    }

    private static void registerKeys() {
        openMapKey = new class_304("key.ftbchunks.map", class_3675.class_307.field_1668, 77, "key.categories.ftbchunks");
        KeyMappingRegistry.register((class_304)openMapKey);
        openClaimManagerKey = new class_304("key.ftbchunks.claim_manager", class_3675.class_307.field_1668, -1, "key.categories.ftbchunks");
        KeyMappingRegistry.register((class_304)openClaimManagerKey);
        zoomInKey = new class_304("key.ftbchunks.minimap.zoomIn", class_3675.class_307.field_1668, 61, "key.categories.ftbchunks");
        KeyMappingRegistry.register((class_304)zoomInKey);
        zoomOutKey = new class_304("key.ftbchunks.minimap.zoomOut", class_3675.class_307.field_1668, 45, "key.categories.ftbchunks");
        KeyMappingRegistry.register((class_304)zoomOutKey);
        addWaypointKey = new class_304("key.ftbchunks.add_waypoint", class_3675.class_307.field_1668, -1, "key.categories.ftbchunks");
        KeyMappingRegistry.register((class_304)addWaypointKey);
        waypointManagerKey = new class_304("key.ftbchunks.waypoint_manager", class_3675.class_307.field_1668, -1, "key.categories.ftbchunks");
        KeyMappingRegistry.register((class_304)waypointManagerKey);
    }

    public static Set<class_1923> getPendingRerender() {
        return rerenderCache.keySet();
    }

    public static void queue(MapTask task) {
        taskQueue.addLast(task);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerPlatform() {
        FTBChunksClientImpl.registerPlatform();
    }

    public static void openGui() {
        new LargeMapScreen().openGui();
    }

    public static void saveAllRegions() {
        if (MapManager.inst == null) {
            return;
        }
        for (MapDimension dimension : MapManager.inst.getDimensions().values()) {
            for (MapRegion region : dimension.getLoadedRegions()) {
                if (!region.saveData) continue;
                FTBChunksClient.queue(region);
                region.saveData = false;
            }
            if (!dimension.saveData) continue;
            FTBChunksClient.queue(dimension);
            dimension.saveData = false;
        }
        if (MapManager.inst.saveData) {
            FTBChunksClient.queue(MapManager.inst);
            MapManager.inst.saveData = false;
        }
    }

    @Override
    public void login(LoginDataPacket loginData) {
        FTBChunks.LOGGER.info("Loading FTB Chunks client data from world " + loginData.serverId);
        FTBChunksWorldConfig.CONFIG.read(loginData.config);
        Path dir = Platform.getGameFolder().resolve("local/ftbchunks/data/" + loginData.serverId);
        if (Files.notExists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        MapManager.inst = new MapManager(loginData.serverId, dir);
        updateMinimap = true;
        renderedDebugCount = 0;
        ChunkUpdateTask.debugLastTime = 0L;
    }

    public void loggedOut(@Nullable class_746 player) {
        MapManager manager = MapManager.inst;
        if (manager != null) {
            MapTask task;
            FTBChunksClient.saveAllRegions();
            while ((task = taskQueue.pollFirst()) != null) {
                try {
                    task.runMapTask();
                }
                catch (Exception ex) {
                    FTBChunks.LOGGER.error("Failed to run task " + task);
                    ex.printStackTrace();
                }
            }
            MapDimension.updateCurrent();
            manager.release();
        }
        MapManager.inst = null;
    }

    @Override
    public void updateGeneralData(SendGeneralDataPacket packet) {
        generalData = packet;
    }

    @Override
    public void updateChunk(SendChunkPacket packet) {
        if (MapManager.inst == null) {
            return;
        }
        MapDimension dimension = MapManager.inst.getDimension(packet.dimension);
        Date now = new Date();
        FTBChunksClient.queue(new UpdateChunkFromServerTask(dimension, packet.chunk, packet.teamId, now));
    }

    @Override
    public void updateAllChunks(SendManyChunksPacket packet) {
        if (MapManager.inst == null) {
            return;
        }
        MapDimension dimension = MapManager.inst.getDimension(packet.dimension);
        Date now = new Date();
        for (SendChunkPacket.SingleChunk c : packet.chunks) {
            FTBChunksClient.queue(new UpdateChunkFromServerTask(dimension, c, packet.teamId, now));
        }
    }

    @Override
    public void syncRegion(RegionSyncKey key, int offset, int total, byte[] data) {
        PartialPackets.REGION.read(key, offset, total, data);
    }

    @Override
    public void playerDeath(PlayerDeathPacket packet) {
        if (((Boolean)FTBChunksClientConfig.DEATH_WAYPOINTS.get()).booleanValue() && FTBChunksWorldConfig.playerHasMapStage((class_1657)class_310.method_1551().field_1724)) {
            MapDimension dimension = MapManager.inst.getDimension(packet.dimension);
            for (Waypoint w : dimension.getWaypointManager()) {
                if (w.type != WaypointType.DEATH) continue;
                w.hidden = true;
                w.update();
            }
            Waypoint w = new Waypoint(dimension, packet.x, packet.y, packet.z);
            w.name = "Death #" + packet.number;
            w.type = WaypointType.DEATH;
            w.color = 0xFF0000;
            dimension.getWaypointManager().add(w);
        }
    }

    @Override
    public int blockColor() {
        class_310 mc = class_310.method_1551();
        mc.method_20493(() -> {
            mc.method_1507(null);
            new Thread(() -> {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                mc.method_20493(() -> {
                    if (mc.field_1765 instanceof class_3965) {
                        class_2960 id = class_2378.field_11146.method_10221((Object)mc.field_1687.method_8320(((class_3965)mc.field_1765).method_17777()).method_26204());
                        class_1041 window = mc.method_22683();
                        try (class_1011 image = class_318.method_1663((class_276)mc.method_1522());){
                            int col = image.method_4315(image.method_4307() / 2 - (int)(2.0 * window.method_4495()), image.method_4323() / 2 - (int)(2.0 * window.method_4495()));
                            String s = String.format("\"%s\": \"#%06X\"", id.method_12832(), ColorUtils.convertFromNative(col) & 0xFFFFFF);
                            mc.field_1724.method_7353((class_2561)class_2561.method_43470((String)(id.method_12836() + " - " + s)).method_27696(class_2583.field_24360.method_27706(class_124.field_1065).method_10958(new class_2558(class_2558.class_2559.field_21462, s)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to copy")))), false);
                        }
                    }
                });
            }, "Color getter").start();
        });
        return 1;
    }

    @Override
    public void updateLoadedChunkView(class_5321<class_1937> dimension, Long2IntMap chunks) {
        MapDimension dim = MapManager.inst.getDimension(dimension);
        dim.loadedChunkView = chunks;
        MapManager.inst.updateAllRegions(false);
    }

    @Override
    public boolean skipBlock(class_2680 state) {
        class_2960 id = FTBChunks.BLOCK_REGISTRY.getId((Object)state.method_26204());
        return id == null || ColorMapLoader.getBlockColor(id).isIgnored();
    }

    @Override
    public void addWaypoint(class_1657 player, String name, class_2338 pos, int color) {
        MapDimension mapDimension = MapManager.inst.getDimension((class_5321<class_1937>)player.field_6002.method_27983());
        Waypoint w = new Waypoint(mapDimension, pos.method_10263(), pos.method_10264(), pos.method_10260());
        w.name = name;
        w.color = color;
        mapDimension.getWaypointManager().add(w);
    }

    public EventResult customClick(CustomClickEvent event) {
        if (event.id().equals((Object)BUTTON_ID_MAP)) {
            FTBChunksClient.openGui();
            return EventResult.interruptTrue();
        }
        if (event.id().equals((Object)BUTTON_ID_CLAIM)) {
            new ChunkScreen().openGui();
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    /*
     * Enabled aggressive block sorting
     */
    public EventResult keyPressed(class_310 client, int keyCode, int scanCode, int action, int modifiers) {
        if (action != 1) return EventResult.pass();
        if (client.field_1755 != null) return EventResult.pass();
        if (!FTBChunksWorldConfig.playerHasMapStage((class_1657)client.field_1724)) {
            return EventResult.pass();
        }
        if (openMapKey.method_1417(keyCode, scanCode)) {
            if (class_437.method_25441()) {
                SNBTCompoundTag tag = new SNBTCompoundTag();
                tag.method_10556(FTBChunksClientConfig.MINIMAP_ENABLED.key, (Boolean)FTBChunksClientConfig.MINIMAP_ENABLED.get() == false);
                FTBChunksClientConfig.MINIMAP_ENABLED.read(tag);
                FTBChunksClientConfig.saveConfig();
                return EventResult.pass();
            }
            if (((Boolean)FTBChunksClientConfig.DEBUG_INFO.get()).booleanValue() && class_437.method_25443()) {
                FTBChunks.LOGGER.info("=== Task Queue: " + taskQueue.size());
                Iterator<MapTask> iterator = taskQueue.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        FTBChunks.LOGGER.info("===");
                        return EventResult.pass();
                    }
                    MapTask task = iterator.next();
                    FTBChunks.LOGGER.info(task.toString());
                }
            }
            FTBChunksClient.openGui();
            return EventResult.interruptTrue();
        }
        if (openClaimManagerKey.method_1417(keyCode, scanCode)) {
            new ChunkScreen().openGui();
            return EventResult.interruptTrue();
        }
        if (zoomInKey.method_1417(keyCode, scanCode)) {
            return this.changeZoom(true);
        }
        if (zoomOutKey.method_1417(keyCode, scanCode)) {
            return this.changeZoom(false);
        }
        if (addWaypointKey.method_1417(keyCode, scanCode)) {
            return this.addQuickWaypoint();
        }
        if (!waypointManagerKey.method_1417(keyCode, scanCode)) return EventResult.pass();
        new WaypointEditorScreen().openGui();
        return EventResult.pass();
    }

    public EventResult keyPressed(class_310 client, class_437 screen, int keyCode, int scanCode, int modifiers) {
        LargeMapScreen gui;
        if (openMapKey.method_1417(keyCode, scanCode) && (gui = (LargeMapScreen)((Object)ClientUtils.getCurrentGuiAs(LargeMapScreen.class))) != null) {
            gui.closeGui(false);
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    private EventResult addQuickWaypoint() {
        StringConfig name = new StringConfig();
        class_746 player = class_310.method_1551().field_1724;
        if (player == null || MapManager.inst == null) {
            return EventResult.pass();
        }
        new EditConfigFromStringScreen((ConfigFromString)name, arg_0 -> FTBChunksClient.lambda$addQuickWaypoint$3(name, (class_1657)player, arg_0)).openGuiLater();
        return EventResult.interruptTrue();
    }

    private EventResult changeZoom(boolean zoomIn) {
        double zoomFactor;
        double zoom = this.prevZoom = ((Double)FTBChunksClientConfig.MINIMAP_ZOOM.get()).doubleValue();
        double d = zoomFactor = zoomIn ? 1.0 : -1.0;
        zoom = zoom + zoomFactor > 4.0 ? 4.0 : (zoom + zoomFactor < 1.0 ? 1.0 : (zoom += zoomFactor));
        this.lastZoomTime = System.currentTimeMillis();
        FTBChunksClientConfig.MINIMAP_ZOOM.set(Double.valueOf(zoom));
        return EventResult.interruptTrue();
    }

    public float getZoom() {
        double z = (Double)FTBChunksClientConfig.MINIMAP_ZOOM.get();
        if (this.prevZoom != z) {
            long max = (long)(400.0 / z);
            long t = class_3532.method_24156((long)(System.currentTimeMillis() - this.lastZoomTime), (long)0L, (long)max);
            if (t == max) {
                this.lastZoomTime = 0L;
                return (float)z;
            }
            return (float)class_3532.method_16436((double)((double)t / (double)max), (double)this.prevZoom, (double)z);
        }
        return (float)z;
    }

    public static int generateTextureId(int w, int h) {
        int textureId = GlStateManager._genTexture();
        RenderSystem.bindTextureForSetup((int)textureId);
        GlStateManager._texParameter((int)3553, (int)33085, (int)0);
        GlStateManager._texParameter((int)3553, (int)33082, (int)0);
        GlStateManager._texParameter((int)3553, (int)33083, (int)0);
        GlStateManager._texParameter((int)3553, (int)34049, (float)0.0f);
        GlStateManager._texImage2D((int)3553, (int)0, (int)class_1011.class_1013.field_5012.method_4341(), (int)w, (int)h, (int)0, (int)6408, (int)5121, null);
        return textureId;
    }

    public void renderHud(class_4587 matrixStack, float tickDelta) {
        List<class_2561> textList;
        float scale;
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || mc.field_1687 == null || MapManager.inst == null) {
            return;
        }
        double playerX = class_3532.method_16436((double)tickDelta, (double)this.prevPlayerX, (double)this.currentPlayerX);
        double playerY = class_3532.method_16436((double)tickDelta, (double)this.prevPlayerY, (double)this.currentPlayerY);
        double playerZ = class_3532.method_16436((double)tickDelta, (double)this.prevPlayerZ, (double)this.currentPlayerZ);
        double guiScale = mc.method_22683().method_4495();
        int scaledWidth = mc.method_22683().method_4486();
        int scaledHeight = mc.method_22683().method_4502();
        MapDimension dim = MapDimension.getCurrent();
        if (dim == null) {
            return;
        }
        if (dim.dimension != mc.field_1687.method_27983()) {
            MapDimension.updateCurrent();
            dim = MapDimension.getCurrent();
            longRangePlayerTracker.clear();
        }
        long now = System.currentTimeMillis();
        if (this.nextRegionSave == 0L || now >= this.nextRegionSave) {
            this.nextRegionSave = now + 60000L;
            FTBChunksClient.saveAllRegions();
        }
        if (minimapTextureId == -1) {
            minimapTextureId = FTBChunksClient.generateTextureId(240, 240);
            updateMinimap = true;
        }
        float zoom0 = this.getZoom();
        float zoom = zoom0 / 3.5f;
        MinimapBlurMode blurMode = (MinimapBlurMode)((Object)FTBChunksClientConfig.MINIMAP_BLUR_MODE.get());
        boolean minimapBlur = blurMode == MinimapBlurMode.AUTO ? zoom0 < 1.5f : blurMode == MinimapBlurMode.ON;
        int filter = minimapBlur ? 9729 : 9728;
        RenderSystem.enableTexture();
        RenderSystem.bindTextureForSetup((int)minimapTextureId);
        RenderSystem.texParameter((int)3553, (int)10241, (int)filter);
        RenderSystem.texParameter((int)3553, (int)10240, (int)filter);
        int cx = class_3532.method_15357((double)playerX) >> 4;
        int cz = class_3532.method_15357((double)playerZ) >> 4;
        if (cx != this.currentPlayerChunkX || cz != this.currentPlayerChunkZ) {
            updateMinimap = true;
        }
        if (updateMinimap) {
            updateMinimap = false;
            for (int mz = 0; mz < 15; ++mz) {
                for (int mx = 0; mx < 15; ++mx) {
                    int ox = cx + mx - 7;
                    int oz = cz + mz - 7;
                    MapRegion region = dim.getRegion(XZ.regionFromChunk((int)ox, (int)oz));
                    region.getRenderedMapImage().method_22619(0, mx * 16, mz * 16, (ox & 0x1F) * 16, (oz & 0x1F) * 16, 16, 16, minimapBlur, false, false, false);
                }
            }
            this.currentPlayerChunkX = cx;
            this.currentPlayerChunkZ = cz;
        }
        if (mc.field_1690.field_1866 || !((Boolean)FTBChunksClientConfig.MINIMAP_ENABLED.get()).booleanValue() || (Integer)FTBChunksClientConfig.MINIMAP_VISIBILITY.get() == 0 || !FTBChunksWorldConfig.shouldShowMinimap((class_1657)mc.field_1724)) {
            return;
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_PROPORTIONAL.get()).booleanValue()) {
            scale = (float)(4.0 / guiScale);
            scale = (float)((double)scale * ((double)((float)scaledWidth / 10.0f) / ((double)scale * 64.0) * (Double)FTBChunksClientConfig.MINIMAP_SCALE.get()));
        } else {
            scale = (float)((Double)FTBChunksClientConfig.MINIMAP_SCALE.get() * 4.0 / guiScale);
        }
        boolean rotationLocked = (Boolean)FTBChunksClientConfig.MINIMAP_LOCKED_NORTH.get() != false || (Boolean)FTBChunksClientConfig.SQUARE_MINIMAP.get() != false;
        float minimapRotation = (rotationLocked ? 180.0f : -mc.field_1724.method_36454()) % 360.0f;
        int size = (int)(64.0 * (double)scale);
        double halfSizeD = (double)size / 2.0;
        float halfSizeF = (float)size / 2.0f;
        MinimapPosition minimapPosition = (MinimapPosition)((Object)FTBChunksClientConfig.MINIMAP_POSITION.get());
        int x = minimapPosition.getX(scaledWidth, size);
        int y = minimapPosition.getY(scaledHeight, size);
        int z = 0;
        int offsetX = (Integer)FTBChunksClientConfig.MINIMAP_OFFSET_X.get();
        int offsetY = (Integer)FTBChunksClientConfig.MINIMAP_OFFSET_Y.get();
        MinimapPosition.MinimapOffsetConditional offsetConditional = (MinimapPosition.MinimapOffsetConditional)FTBChunksClientConfig.MINIMAP_POSITION_OFFSET_CONDITION.get();
        if (offsetConditional.test(minimapPosition)) {
            x += minimapPosition.posX == 0 ? offsetX : -offsetX;
            y -= minimapPosition.posY > 1 ? offsetY : -offsetY;
        }
        float border = 0.0f;
        int alpha = (Integer)FTBChunksClientConfig.MINIMAP_VISIBILITY.get();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableCull();
        RenderSystem.enableTexture();
        RenderSystem.enableDepthTest();
        matrixStack.method_22903();
        matrixStack.method_22904((double)x + halfSizeD, (double)y + halfSizeD, (double)(490 + z));
        class_1159 m = matrixStack.method_23760().method_23761();
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        RenderSystem.setShader(class_757::method_34541);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)((Boolean)FTBChunksClientConfig.SQUARE_MINIMAP.get() != false ? SQUARE_MASK : CIRCLE_MASK));
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
        buffer.method_22918(m, -halfSizeF + border, -halfSizeF + border, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_1344();
        buffer.method_22918(m, -halfSizeF + border, halfSizeF - border, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_1344();
        buffer.method_22918(m, halfSizeF - border, halfSizeF - border, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_1344();
        buffer.method_22918(m, halfSizeF - border, -halfSizeF + border, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_1344();
        tessellator.method_1350();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        matrixStack.method_22907(class_1160.field_20707.method_23214(minimapRotation + 180.0f));
        RenderSystem.depthFunc((int)518);
        float halfSizeBorderF = halfSizeF - border;
        float offX = 0.5f + (float)((MathUtils.mod((double)playerX, (double)16.0) / 16.0 - 0.5) / 15.0);
        float offZ = 0.5f + (float)((MathUtils.mod((double)playerZ, (double)16.0) / 16.0 - 0.5) / 15.0);
        float zws = 2.0f / (15.0f * zoom);
        RenderSystem.setShader(class_757::method_34541);
        RenderSystem.setShaderTexture((int)0, (int)minimapTextureId);
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
        buffer.method_22918(m, -halfSizeBorderF, -halfSizeBorderF, 0.0f).method_1336(255, 255, 255, alpha).method_22913(offX - zws, offZ - zws).method_1344();
        buffer.method_22918(m, -halfSizeBorderF, halfSizeBorderF, 0.0f).method_1336(255, 255, 255, alpha).method_22913(offX - zws, offZ + zws).method_1344();
        buffer.method_22918(m, halfSizeBorderF, halfSizeBorderF, 0.0f).method_1336(255, 255, 255, alpha).method_22913(offX + zws, offZ + zws).method_1344();
        buffer.method_22918(m, halfSizeBorderF, -halfSizeBorderF, 0.0f).method_1336(255, 255, 255, alpha).method_22913(offX + zws, offZ - zws).method_1344();
        tessellator.method_1350();
        RenderSystem.disableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34541);
        RenderSystem.setShaderTexture((int)0, (class_2960)((Boolean)FTBChunksClientConfig.SQUARE_MINIMAP.get() != false ? SQUARE_BORDER : CIRCLE_BORDER));
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
        buffer.method_22918(m, -halfSizeF, -halfSizeF, 0.0f).method_1336(255, 255, 255, alpha).method_22913(0.0f, 0.0f).method_1344();
        buffer.method_22918(m, -halfSizeF, halfSizeF, 0.0f).method_1336(255, 255, 255, alpha).method_22913(0.0f, 1.0f).method_1344();
        buffer.method_22918(m, halfSizeF, halfSizeF, 0.0f).method_1336(255, 255, 255, alpha).method_22913(1.0f, 1.0f).method_1344();
        buffer.method_22918(m, halfSizeF, -halfSizeF, 0.0f).method_1336(255, 255, 255, alpha).method_22913(1.0f, 0.0f).method_1344();
        tessellator.method_1350();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.disableTexture();
        buffer.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
        buffer.method_22918(m, -halfSizeF, 0.0f, 0.0f).method_1336(0, 0, 0, 30).method_1344();
        buffer.method_22918(m, halfSizeF, 0.0f, 0.0f).method_1336(0, 0, 0, 30).method_1344();
        buffer.method_22918(m, 0.0f, -halfSizeF, 0.0f).method_1336(0, 0, 0, 30).method_1344();
        buffer.method_22918(m, 0.0f, halfSizeF, 0.0f).method_1336(0, 0, 0, 30).method_1344();
        tessellator.method_1350();
        matrixStack.method_22909();
        m = matrixStack.method_23760().method_23761();
        RenderSystem.enableTexture();
        if (((Boolean)FTBChunksClientConfig.MINIMAP_COMPASS.get()).booleanValue()) {
            for (int face = 0; face < 4; ++face) {
                double d = (double)size / 2.2;
                double angle = ((double)minimapRotation + 180.0 - (double)face * 90.0) * Math.PI / 180.0;
                float wx = (float)((double)x + halfSizeD + Math.cos(angle) * d);
                float wy = (float)((double)y + halfSizeD + Math.sin(angle) * d);
                float ws = (float)size / 32.0f;
                RenderSystem.setShader(class_757::method_34541);
                RenderSystem.setShaderTexture((int)0, (class_2960)COMPASS[face]);
                buffer.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
                buffer.method_22918(m, wx - ws, wy - ws, (float)z).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_1344();
                buffer.method_22918(m, wx - ws, wy + ws, (float)z).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_1344();
                buffer.method_22918(m, wx + ws, wy + ws, (float)z).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_1344();
                buffer.method_22918(m, wx + ws, wy - ws, (float)z).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_1344();
                tessellator.method_1350();
            }
        }
        if (this.lastMapIconUpdate == 0L || now - this.lastMapIconUpdate >= (long)((Integer)FTBChunksClientConfig.MINIMAP_ICON_UPDATE_TIMER.get()).intValue()) {
            this.lastMapIconUpdate = now;
            this.mapIcons.clear();
            ((Consumer)MapIconEvent.MINIMAP.invoker()).accept(new MapIconEvent(mc, dim, this.mapIcons, MapType.MINIMAP));
            if (this.mapIcons.size() >= 2) {
                this.mapIcons.sort(new MapIconComparator(mc.field_1724.method_19538(), tickDelta));
            }
        }
        for (MapIcon icon : this.mapIcons) {
            double distance;
            class_243 pos = icon.getPos(tickDelta);
            double d = (distance = MathUtils.dist((double)playerX, (double)playerZ, (double)pos.field_1352, (double)pos.field_1350)) * (double)scale * (double)zoom;
            if (!icon.isVisible(MapType.MINIMAP, distance, d > halfSizeD)) continue;
            if (d > halfSizeD) {
                d = halfSizeD;
            }
            double angle = Math.atan2(playerZ - pos.field_1350, playerX - pos.field_1352) + (double)minimapRotation * Math.PI / 180.0;
            double ws = (double)size / (32.0 / icon.getIconScale(MapType.MINIMAP));
            double wx = (double)x + halfSizeD + Math.cos(angle) * d;
            double wy = (double)y + halfSizeD + Math.sin(angle) * d;
            float wsf = (float)(ws * 2.0);
            matrixStack.method_22903();
            matrixStack.method_22904(wx - ws, wy - ws - (icon.isIconOnEdge(MapType.MINIMAP, d >= halfSizeD) ? ws / 2.0 : 0.0), (double)z);
            matrixStack.method_22905(wsf, wsf, 1.0f);
            icon.draw(MapType.MINIMAP, matrixStack, 0, 0, 1, 1, d >= halfSizeD, 255);
            matrixStack.method_22909();
        }
        if (rotationLocked || ((Boolean)FTBChunksClientConfig.SHOW_PLAYER_WHEN_UNLOCKED.get()).booleanValue()) {
            RenderSystem.setShaderTexture((int)0, (class_2960)PLAYER);
            matrixStack.method_22903();
            matrixStack.method_22904((double)x + halfSizeD, (double)y + halfSizeD, (double)z);
            if (rotationLocked) {
                matrixStack.method_22907(class_1160.field_20707.method_23214(mc.field_1724.method_36454() + 180.0f));
            }
            matrixStack.method_22905((float)size / 16.0f, (float)size / 16.0f, 1.0f);
            m = matrixStack.method_23760().method_23761();
            RenderSystem.setShader(class_757::method_34541);
            buffer.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
            buffer.method_22918(m, -1.0f, -1.0f, 0.0f).method_1336(255, 255, 255, 200).method_22913(0.0f, 0.0f).method_1344();
            buffer.method_22918(m, -1.0f, 1.0f, 0.0f).method_1336(255, 255, 255, 200).method_22913(0.0f, 1.0f).method_1344();
            buffer.method_22918(m, 1.0f, 1.0f, 0.0f).method_1336(255, 255, 255, 200).method_22913(1.0f, 1.0f).method_1344();
            buffer.method_22918(m, 1.0f, -1.0f, 0.0f).method_1336(255, 255, 255, 200).method_22913(1.0f, 0.0f).method_1344();
            tessellator.method_1350();
            matrixStack.method_22909();
        }
        if (!(textList = this.buildMinimapTextData(mc, playerX, playerY, playerZ, dim)).isEmpty()) {
            float s1 = Math.max(1.0f, (float)Math.round(scale)) / 2.0f;
            Objects.requireNonNull(mc.field_1772);
            float textHeight = (float)((9 + 2) * textList.size()) * s1;
            float yOff = (float)(y + size) + textHeight >= (float)scaledHeight ? -textHeight : (float)size + 2.0f;
            matrixStack.method_22903();
            matrixStack.method_22904((double)x + halfSizeD, (double)((float)y + yOff), 0.0);
            matrixStack.method_22905(s1, s1, 1.0f);
            for (int i = 0; i < textList.size(); ++i) {
                class_5481 text = textList.get(i).method_30937();
                int textWidth = mc.field_1772.method_30880(text);
                class_327 class_3272 = mc.field_1772;
                float f = (float)(-textWidth) / 2.0f;
                Objects.requireNonNull(mc.field_1772);
                class_3272.method_27517(matrixStack, text, f, (float)(i * (9 + 2)), -1);
            }
            matrixStack.method_22909();
        }
        RenderSystem.enableDepthTest();
        if (worldMatrix != null && ((Boolean)FTBChunksClientConfig.IN_WORLD_WAYPOINTS.get()).booleanValue()) {
            this.drawInWorldIcons(mc, matrixStack, tickDelta, playerX, playerY, playerZ, scaledWidth, scaledHeight);
        }
    }

    private List<class_2561> buildMinimapTextData(class_310 mc, double playerX, double playerY, double playerZ, MapDimension dim) {
        ClientTeam team;
        MapRegionData data;
        ArrayList<class_2561> res = new ArrayList<class_2561>();
        if (((Boolean)FTBChunksClientConfig.MINIMAP_ZONE.get()).booleanValue() && (data = dim.getRegion(XZ.regionFromChunk((int)this.currentPlayerChunkX, (int)this.currentPlayerChunkZ)).getData()) != null && (team = data.getChunk(XZ.of((int)this.currentPlayerChunkX, (int)this.currentPlayerChunkZ)).getTeam()) != null) {
            res.add(team.getColoredName());
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_XYZ.get()).booleanValue()) {
            res.add((class_2561)class_2561.method_43470((String)(class_3532.method_15357((double)playerX) + " " + class_3532.method_15357((double)playerY) + " " + class_3532.method_15357((double)playerZ))));
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_BIOME.get()).booleanValue()) {
            class_6880 biome = mc.field_1687.method_23753(mc.field_1724.method_24515());
            biome.method_40230().ifPresent(e -> res.add((class_2561)class_2561.method_43471((String)("biome." + e.method_29177().method_12836() + "." + e.method_29177().method_12832()))));
        }
        if (((Boolean)FTBChunksClientConfig.DEBUG_INFO.get()).booleanValue()) {
            XZ playerXZ = XZ.regionFromChunk((int)this.currentPlayerChunkX, (int)this.currentPlayerChunkZ);
            long memory = MapManager.inst.estimateMemoryUsage();
            res.add((class_2561)class_2561.method_43470((String)("Queued tasks: " + taskQueue.size())));
            res.add((class_2561)class_2561.method_43470((String)("Region: " + playerXZ)));
            res.add((class_2561)class_2561.method_43470((String)("Est. Memory: " + StringUtils.formatDouble00((double)((double)memory / 1024.0 / 1024.0)) + " MB")));
            res.add((class_2561)class_2561.method_43470((String)("Total updates: " + renderedDebugCount)));
            if (ChunkUpdateTask.debugLastTime > 0L) {
                res.add((class_2561)class_2561.method_43470((String)String.format("LU: %,d ns", ChunkUpdateTask.debugLastTime)));
            }
        }
        return res;
    }

    private void drawInWorldIcons(class_310 mc, class_4587 matrixStack, float tickDelta, double playerX, double playerY, double playerZ, int scaledWidth, int scaledHeight) {
        GuiHelper.setupDrawing();
        float ww2 = (float)scaledWidth / 2.0f;
        float wh2 = (float)scaledHeight / 2.0f;
        InWorldMapIcon focusedIcon = null;
        for (MapIcon icon : this.mapIcons) {
            class_243 pos = icon.getPos(tickDelta);
            double playerDist = MathUtils.dist((double)pos.field_1352, (double)pos.field_1351, (double)pos.field_1350, (double)playerX, (double)playerY, (double)playerZ);
            if (!icon.isVisible(MapType.WORLD_ICON, playerDist, false)) continue;
            class_1162 v = new class_1162((float)(pos.field_1352 - FTBChunksClient.cameraPos.field_1352), (float)(pos.field_1351 - FTBChunksClient.cameraPos.field_1351), (float)(pos.field_1350 - FTBChunksClient.cameraPos.field_1350), 1.0f);
            double lookAngle = mc.field_1724.method_5720().method_1026(new class_243((double)v.method_4953(), (double)v.method_4956(), (double)v.method_4957()).method_1029());
            if (!(lookAngle > 0.0)) continue;
            v.method_22674(worldMatrix);
            v.method_23219();
            float ix = ww2 + v.method_4953() * ww2;
            float iy = wh2 - v.method_4956() * wh2;
            double mouseDist = MathUtils.dist((double)ix, (double)iy, (double)ww2, (double)wh2);
            InWorldMapIcon inWorldMapIcon = new InWorldMapIcon(icon, ix, iy, playerDist, mouseDist);
            if (mouseDist <= 5.0 && (focusedIcon == null || focusedIcon.distanceToMouse() > mouseDist)) {
                focusedIcon = inWorldMapIcon;
            }
            this.inWorldMapIcons.add(inWorldMapIcon);
        }
        double fadeStart = (Double)FTBChunksClientConfig.WAYPOINT_DOT_FADE_DISTANCE.get();
        double fadeMin = fadeStart * 2.0 / 3.0;
        for (InWorldMapIcon icon : this.inWorldMapIcons) {
            int iconAlpha;
            if (!(icon.distanceToPlayer() > fadeMin) || (iconAlpha = icon.distanceToPlayer() < fadeStart ? (int)(255.0 * ((icon.distanceToPlayer() - fadeMin) / (fadeStart - fadeMin))) : 255) <= 0) continue;
            float iconScale = class_3532.method_16439((float)((50.0f - Math.min((float)icon.distanceToMouse(), 50.0f)) / 50.0f), (float)0.25f, (float)0.5f);
            matrixStack.method_22903();
            matrixStack.method_22904((double)icon.x(), (double)icon.y(), icon == focusedIcon ? 50.0 : -100.0);
            matrixStack.method_22905(iconScale, iconScale, 1.0f);
            icon.icon().draw(MapType.WORLD_ICON, matrixStack, -8, -8, 16, 16, icon != focusedIcon, iconAlpha);
            matrixStack.method_22909();
        }
        this.inWorldMapIcons.clear();
    }

    public void renderWorldLast(class_4587 poseStack, class_1159 projectionMatrix, class_4184 camera, float tickDelta) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1690.field_1842 || MapManager.inst == null || mc.field_1687 == null || mc.field_1724 == null || MapDimension.getCurrent() == null || !FTBChunksWorldConfig.playerHasMapStage((class_1657)mc.field_1724)) {
            return;
        }
        worldMatrix = projectionMatrix.method_22673();
        worldMatrix.method_22672(poseStack.method_23760().method_23761());
        cameraPos = camera.method_19326();
        if (!((Boolean)FTBChunksClientConfig.IN_WORLD_WAYPOINTS.get()).booleanValue()) {
            return;
        }
        List<WaypointMapIcon> visibleWaypoints = this.findVisibleWaypoints(MapDimension.getCurrent(), (class_1657)mc.field_1724, tickDelta);
        if (visibleWaypoints.isEmpty()) {
            return;
        }
        class_243 cameraPos = camera.method_19326();
        poseStack.method_22903();
        poseStack.method_22904(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
        class_4588 depthBuffer = mc.method_22940().method_23000().getBuffer(FTBChunksRenderTypes.WAYPOINTS_DEPTH);
        float y1 = (float)(cameraPos.field_1351 + 30.0);
        float y2 = y1 + 70.0f;
        int yMin = mc.field_1687.method_31607();
        for (WaypointMapIcon waypoint : visibleWaypoints) {
            double angle = Math.atan2(cameraPos.field_1350 - waypoint.pos.field_1350, cameraPos.field_1352 - waypoint.pos.field_1352) * 180.0 / Math.PI;
            int r = waypoint.waypoint.color >> 16 & 0xFF;
            int g = waypoint.waypoint.color >> 8 & 0xFF;
            int b = waypoint.waypoint.color >> 0 & 0xFF;
            poseStack.method_22903();
            poseStack.method_22904(waypoint.pos.field_1352, 0.0, waypoint.pos.field_1350);
            poseStack.method_22907(class_1160.field_20705.method_23214((float)(-angle - 135.0)));
            float s = 0.6f;
            class_1159 m = poseStack.method_23760().method_23761();
            depthBuffer.method_22918(m, -s, (float)yMin, s).method_1336(r, g, b, waypoint.alpha).method_22913(0.0f, 1.0f).method_1344();
            depthBuffer.method_22918(m, -s, y1, s).method_1336(r, g, b, waypoint.alpha).method_22913(0.0f, 0.0f).method_1344();
            depthBuffer.method_22918(m, s, y1, -s).method_1336(r, g, b, waypoint.alpha).method_22913(1.0f, 0.0f).method_1344();
            depthBuffer.method_22918(m, s, (float)yMin, -s).method_1336(r, g, b, waypoint.alpha).method_22913(1.0f, 1.0f).method_1344();
            depthBuffer.method_22918(m, -s, y1, s).method_1336(r, g, b, waypoint.alpha).method_22913(0.0f, 1.0f).method_1344();
            depthBuffer.method_22918(m, -s, y2, s).method_1336(r, g, b, 0).method_22913(0.0f, 0.0f).method_1344();
            depthBuffer.method_22918(m, s, y2, -s).method_1336(r, g, b, 0).method_22913(1.0f, 0.0f).method_1344();
            depthBuffer.method_22918(m, s, y1, -s).method_1336(r, g, b, waypoint.alpha).method_22913(1.0f, 1.0f).method_1344();
            poseStack.method_22909();
        }
        poseStack.method_22909();
        mc.method_22940().method_23000().method_22994(FTBChunksRenderTypes.WAYPOINTS_DEPTH);
    }

    private List<WaypointMapIcon> findVisibleWaypoints(MapDimension dim, class_1657 player, float tickDelta) {
        ArrayList<WaypointMapIcon> visibleWaypoints = new ArrayList<WaypointMapIcon>();
        double fadeOutDistance = (Double)FTBChunksClientConfig.WAYPOINT_BEACON_FADE_DISTANCE.get();
        double fadeOutDistanceP = fadeOutDistance * 2.0 / 3.0;
        for (Waypoint waypoint : dim.getWaypointManager()) {
            double distance;
            if (waypoint.hidden || !((distance = MathUtils.dist((double)player.method_23317(), (double)player.method_23321(), (double)((double)waypoint.x + 0.5), (double)((double)waypoint.z + 0.5))) > fadeOutDistanceP) || !(distance <= (Double)FTBChunksClientConfig.WAYPOINT_MAX_DISTANCE.get())) continue;
            int alpha = 150;
            if (distance < fadeOutDistance) {
                alpha = (int)((double)alpha * ((distance - fadeOutDistanceP) / (fadeOutDistance - fadeOutDistanceP)));
            }
            if (alpha <= 0) continue;
            waypoint.mapIcon.distance = distance;
            waypoint.mapIcon.alpha = alpha;
            visibleWaypoints.add(waypoint.mapIcon);
        }
        visibleWaypoints.sort(new MapIconComparator(player.method_19538(), tickDelta));
        return visibleWaypoints;
    }

    private EventResult screenOpened(class_437 screen, ScreenAccess access) {
        if (screen instanceof class_433) {
            this.nextRegionSave = System.currentTimeMillis() + 60000L;
            FTBChunksClient.saveAllRegions();
        }
        return EventResult.pass();
    }

    private void clientTick(class_310 mc) {
        MapManager manager = MapManager.inst;
        if (manager != null && mc.field_1687 != null) {
            int releaseInterval;
            if (mc.field_1724 != null) {
                this.prevPlayerX = this.currentPlayerX;
                this.prevPlayerY = this.currentPlayerY;
                this.prevPlayerZ = this.currentPlayerZ;
                this.currentPlayerX = mc.field_1724.method_23317();
                this.currentPlayerY = mc.field_1724.method_23318();
                this.currentPlayerZ = mc.field_1724.method_23321();
            }
            class_1937 level = (class_1937)Objects.requireNonNull(mc.field_1687);
            if (taskQueueTicks % (long)((Integer)FTBChunksClientConfig.RERENDER_QUEUE_TICKS.get()).intValue() == 0L) {
                FTBChunksClient.runRerenderTasks(level, manager);
            }
            if (taskQueueTicks % (long)((Integer)FTBChunksClientConfig.TASK_QUEUE_TICKS.get()).intValue() == 0L) {
                FTBChunksClient.runQueuedTasks();
            }
            if ((releaseInterval = ((Integer)FTBChunksClientConfig.REGION_RELEASE_TIME.get()).intValue()) > 0 && level.method_8510() % ((long)releaseInterval * 20L) == 0L) {
                manager.releaseStaleRegionData((long)releaseInterval * 1000L);
            }
            if (mc.field_1755 == null) {
                manager.checkForRegionPurge();
            }
            ++taskQueueTicks;
        }
    }

    private static void runRerenderTasks(class_1937 level, MapManager manager) {
        if (!rerenderCache.isEmpty()) {
            long biomeZoomSeed = level.method_22385().field_20641;
            rerenderCache.forEach((chunkPos, blocks) -> {
                class_2791 chunkAccess = level.method_8402(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_12803, false);
                if (chunkAccess != null) {
                    FTBChunksClient.queueOrExecute(new ChunkUpdateTask(manager, level, chunkAccess, (class_1923)chunkPos, biomeZoomSeed, blocks.toIntArray()));
                }
            });
            rerenderCache.clear();
        }
    }

    private static void runQueuedTasks() {
        int nTasks = Math.min(taskQueue.size(), (Integer)FTBChunksClientConfig.TASK_QUEUE_MAX.get());
        if (nTasks > 0) {
            MapTask[] tasks = new MapTask[nTasks];
            for (int i = 0; i < nTasks; ++i) {
                tasks[i] = taskQueue.pollFirst();
                if (tasks[i] == null || tasks[i].cancelOtherTasks()) break;
            }
            for (MapTask task : tasks) {
                if (task == null) continue;
                try {
                    task.runMapTask();
                }
                catch (Exception ex) {
                    FTBChunks.LOGGER.error("Failed to run task " + task);
                    ex.printStackTrace();
                }
            }
        }
    }

    private void teamPropertiesChanged(ClientTeamPropertiesChangedEvent event) {
        if (MapManager.inst != null) {
            MapManager.inst.updateAllRegions(false);
        }
    }

    private void mapIcons(MapIconEvent event) {
        class_310 mc = event.mc;
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_WAYPOINTS.get()).booleanValue()) {
            for (Waypoint w : event.mapDimension.getWaypointManager()) {
                if (w.hidden && event.mapType.isMinimap()) continue;
                event.add(w.mapIcon);
            }
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_ENTITIES.get()).booleanValue()) {
            for (class_1297 entity : mc.field_1687.method_18112()) {
                Icon icon2;
                if (entity instanceof class_742 || entity.method_5864().method_5891() == class_1311.field_17715 || entity.method_5756((class_1657)mc.field_1724) || (icon2 = EntityIcons.get(entity)) == Color4I.EMPTY) continue;
                if (((Boolean)FTBChunksClientConfig.ONLY_SURFACE_ENTITIES.get()).booleanValue() && !mc.field_1687.method_8597().comp_643()) {
                    int z;
                    int x = class_3532.method_15357((double)entity.method_23317());
                    MapRegion region = event.mapDimension.getRegion(XZ.regionFromBlock((int)x, (int)(z = class_3532.method_15357((double)entity.method_23321()))));
                    MapRegionData data = region.getData();
                    if (data == null) continue;
                    short y = data.height[(x & 0x1FF) + (z & 0x1FF) * 512];
                    if (!(entity.method_23318() >= (double)(y - 10))) continue;
                    event.add(new EntityMapIcon(entity, icon2));
                    continue;
                }
                event.add(new EntityMapIcon(entity, icon2));
            }
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_PLAYER_HEADS.get()).booleanValue()) {
            if (mc.field_1687.method_18456().size() > 1) {
                for (class_742 player : mc.field_1687.method_18456()) {
                    if (player == mc.field_1724 || player.method_5756((class_1657)mc.field_1724) || !VisibleClientPlayers.isPlayerVisible((class_1657)player)) continue;
                    if (longRangePlayerTracker.remove(player.method_5667()) != null) {
                        LargeMapScreen.refreshIconsIfOpen();
                    }
                    event.add(new EntityMapIcon((class_1297)player, (Icon)FaceIcon.getFace((GameProfile)player.method_7334())));
                }
            }
            longRangePlayerTracker.forEach((id, icon) -> event.add((MapIcon)icon));
        }
        if (!event.mapType.isMinimap()) {
            event.add(new EntityMapIcon((class_1297)mc.field_1724, (Icon)FaceIcon.getFace((GameProfile)mc.field_1724.method_7334())));
        }
    }

    public void refreshMinimapIcons() {
        this.lastMapIconUpdate = 0L;
    }

    private void reloadShaders(class_3300 resourceManager, ClientReloadShadersEvent.ShadersSink sink) {
    }

    public static void rerender(class_2338 pos) {
        class_1923 chunkPos = new class_1923(pos);
        IntOpenHashSet set = rerenderCache.get(chunkPos);
        if (set == null) {
            set = new IntOpenHashSet();
            rerenderCache.put(chunkPos, set);
        }
        if (set.add((pos.method_10263() & 0xF) + (pos.method_10260() & 0xF) * 16) && ((Boolean)FTBChunksClientConfig.DEBUG_INFO.get()).booleanValue()) {
            ++renderedDebugCount;
        }
    }

    public static void handlePacket(class_2637 p) {
        short[] positions;
        class_4076 sectionPos = p.field_26345;
        for (short position : positions = p.field_26346) {
            FTBChunksClient.rerender(sectionPos.method_30557(position));
        }
    }

    public static void handlePacket(class_2672 p) {
        class_2791 chunkAccess;
        MapManager manager = MapManager.inst;
        class_638 level = class_310.method_1551().field_1687;
        if (level != null && (chunkAccess = level.method_8402(p.method_11523(), p.method_11524(), class_2806.field_12803, false)) != null) {
            long biomeZoomSeed = level.method_22385().field_20641;
            FTBChunksClient.queueOrExecute(new ChunkUpdateTask(manager, (class_1937)level, chunkAccess, new class_1923(p.method_11523(), p.method_11524()), biomeZoomSeed, ChunkUpdateTask.ALL_BLOCKS));
        }
    }

    public static void queueOrExecute(MapTask task) {
        FTBChunks.EXECUTOR.execute(task);
    }

    public static void handlePacket(class_2626 p) {
        FTBChunksClient.rerender(p.method_11309());
    }

    @Override
    public void maybeClearDeathpoint(class_1657 player) {
        int maxDist = (Integer)FTBChunksClientConfig.DEATH_WAYPOINT_AUTOREMOVE_DISTANCE.get();
        if (MapManager.inst != null && maxDist > 0 && class_310.method_1551().field_1755 == null) {
            WaypointManager wpm = MapManager.inst.getDimension((class_5321<class_1937>)player.field_6002.method_27983()).getWaypointManager();
            wpm.getNearestDeathpoint(player).ifPresent(wp -> {
                if (player.method_5649((double)wp.x, (double)wp.y, (double)wp.z) < (double)(maxDist * maxDist)) {
                    wpm.remove((Waypoint)wp);
                    wpm.getNearestDeathpoint(player).ifPresent(wp1 -> {
                        wp1.hidden = false;
                    });
                    player.method_7353((class_2561)class_2561.method_43469((String)"ftbchunks.deathpoint_removed", (Object[])new Object[]{wp.name}).method_27692(class_124.field_1054), true);
                }
            });
        }
    }

    @Override
    public void updateTrackedPlayerPos(GameProfile profile, class_2338 pos, boolean valid) {
        boolean changed = false;
        if (!valid) {
            changed = longRangePlayerTracker.remove(profile.getId()) != null;
        } else {
            TrackedPlayerMapIcon icon = longRangePlayerTracker.get(profile.getId());
            if (icon == null) {
                longRangePlayerTracker.put(profile.getId(), new TrackedPlayerMapIcon(profile, class_243.method_24953((class_2382)pos), FaceIcon.getFace((GameProfile)profile)));
                changed = true;
            } else {
                icon.setPos(class_243.method_24953((class_2382)pos));
            }
        }
        if (changed) {
            LargeMapScreen.refreshIconsIfOpen();
        }
    }

    private static /* synthetic */ void lambda$addQuickWaypoint$3(StringConfig name, class_1657 player, boolean set) {
        if (set && !((String)name.value).isEmpty()) {
            MapDimension mapDimension = MapManager.inst.getDimension((class_5321<class_1937>)player.field_6002.method_27983());
            Waypoint w = new Waypoint(mapDimension, player.method_31477(), player.method_31478(), player.method_31479());
            w.name = (String)name.value;
            w.color = Color4I.hsb((float)MathUtils.RAND.nextFloat(), (float)1.0f, (float)1.0f).rgba();
            mapDimension.getWaypointManager().add(w);
        }
        FTBChunksClient.openGui();
    }

    static {
        minimapTextureId = -1;
        renderedDebugCount = 0;
        updateMinimap = false;
        alwaysRenderChunksOnMap = false;
    }
}

