/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import dev.ftb.mods.ftbchunks.client.LargeMapScreen;
import dev.ftb.mods.ftbchunks.client.MapIconComparator;
import dev.ftb.mods.ftbchunks.client.MapIconWidget;
import dev.ftb.mods.ftbchunks.client.MapType;
import dev.ftb.mods.ftbchunks.client.RegionMapButton;
import dev.ftb.mods.ftbchunks.client.map.MapChunk;
import dev.ftb.mods.ftbchunks.client.map.MapRegion;
import dev.ftb.mods.ftbchunks.client.map.MapRegionData;
import dev.ftb.mods.ftbchunks.integration.MapIcon;
import dev.ftb.mods.ftbchunks.integration.MapIconEvent;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_768;

public class RegionMapPanel
extends Panel {
    public final LargeMapScreen largeMap;
    public double regionX = 0.0;
    public double regionZ = 0.0;
    public int regionMinX;
    public int regionMinZ;
    public int regionMaxX;
    public int regionMaxZ;
    public int blockX = 0;
    public int blockY = -32767;
    public int blockZ = 0;
    public int blockIndex = 0;
    public class_768 visibleArea = new class_768(0, 0, 0, 0);
    public final List<MapIcon> mapIcons;

    public RegionMapPanel(LargeMapScreen panel) {
        super((Panel)panel);
        this.largeMap = panel;
        this.mapIcons = new ArrayList<MapIcon>();
    }

    public void updateMinMax() {
        this.regionMinX = Integer.MAX_VALUE;
        this.regionMinZ = Integer.MAX_VALUE;
        this.regionMaxX = Integer.MIN_VALUE;
        this.regionMaxZ = Integer.MIN_VALUE;
        for (Widget w : this.widgets) {
            if (!(w instanceof RegionMapButton)) continue;
            int qx = ((RegionMapButton)w).region.pos.x;
            int qy = ((RegionMapButton)w).region.pos.z;
            this.regionMinX = Math.min(this.regionMinX, qx);
            this.regionMinZ = Math.min(this.regionMinZ, qy);
            this.regionMaxX = Math.max(this.regionMaxX, qx);
            this.regionMaxZ = Math.max(this.regionMaxZ, qy);
        }
        if (this.regionMinX == Integer.MAX_VALUE) {
            this.regionMaxZ = 0;
            this.regionMaxX = 0;
            this.regionMinZ = 0;
            this.regionMinX = 0;
        }
        this.regionMinX -= 100;
        this.regionMinZ -= 100;
        this.regionMaxX += 101;
        this.regionMaxZ += 101;
    }

    public void scrollTo(double x, double y) {
        this.updateMinMax();
        double dx = this.regionMaxX - this.regionMinX;
        double dy = this.regionMaxZ - this.regionMinZ;
        this.setScrollX((x - (double)this.regionMinX) / dx * (double)this.largeMap.scrollWidth - (double)this.width / 2.0);
        this.setScrollY((y - (double)this.regionMinZ) / dy * (double)this.largeMap.scrollHeight - (double)this.height / 2.0);
    }

    public void resetScroll() {
        this.alignWidgets();
        this.setScrollX((double)(this.largeMap.scrollWidth - this.width) / 2.0);
        this.setScrollY((double)(this.largeMap.scrollHeight - this.height) / 2.0);
    }

    public void addWidgets() {
        for (MapRegion region : this.largeMap.dimension.getRegions().values()) {
            this.add(new RegionMapButton(this, region));
        }
        class_310 mc = class_310.method_1551();
        this.mapIcons.clear();
        ((Consumer)MapIconEvent.LARGE_MAP.invoker()).accept(new MapIconEvent(mc, this.largeMap.dimension, this.mapIcons, MapType.LARGE_MAP));
        if (this.mapIcons.size() >= 2) {
            this.mapIcons.sort(new MapIconComparator(mc.field_1724.method_19538(), 1.0f));
        }
        for (MapIcon icon : this.mapIcons) {
            if (!icon.isVisible(MapType.LARGE_MAP, MathUtils.dist((double)mc.field_1724.method_23317(), (double)mc.field_1724.method_23321(), (double)icon.getPos((float)1.0f).field_1352, (double)icon.getPos((float)1.0f).field_1350), false)) continue;
            this.add(new MapIconWidget(this, icon));
        }
        this.alignWidgets();
    }

    public void alignWidgets() {
        this.largeMap.scrollWidth = 0;
        this.largeMap.scrollHeight = 0;
        this.updateMinMax();
        int z = this.largeMap.getRegionButtonSize();
        this.largeMap.scrollWidth = (this.regionMaxX - this.regionMinX) * z;
        this.largeMap.scrollHeight = (this.regionMaxZ - this.regionMinZ) * z;
        for (Widget w : this.widgets) {
            if (w instanceof RegionMapButton) {
                double qx = ((RegionMapButton)w).region.pos.x;
                double qy = ((RegionMapButton)w).region.pos.z;
                double qw = 1.0;
                double qh = 1.0;
                double x = (qx - (double)this.regionMinX) * (double)z;
                double y = (qy - (double)this.regionMinZ) * (double)z;
                w.setPosAndSize((int)x, (int)y, (int)((double)z * qw), (int)((double)z * qh));
                continue;
            }
            if (!(w instanceof MapIconWidget)) continue;
            MapIconWidget i = (MapIconWidget)w;
            double s = Math.max(i.mapIcon.isZoomDependant(MapType.LARGE_MAP) ? 0.0 : 6.0, (double)z / 128.0 * i.mapIcon.getIconScale(MapType.LARGE_MAP));
            if (s <= 1.0) {
                w.setSize(0, 0);
                continue;
            }
            w.setSize(class_3532.method_15384((double)s), class_3532.method_15384((double)s));
            ((MapIconWidget)w).updatePosition(1.0f);
        }
        this.setPosAndSize(0, 0, this.parent.width, this.parent.height);
    }

    public void draw(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        MapRegionData data;
        super.draw(matrixStack, theme, x, y, w, h);
        int dx = this.regionMaxX - this.regionMinX;
        int dy = this.regionMaxZ - this.regionMinZ;
        double px = this.getScrollX() - (double)this.getX();
        double py = this.getScrollY() - (double)this.getY();
        int topBlockX = class_3532.method_15357((double)((px / (double)this.largeMap.scrollWidth * (double)dx + (double)this.regionMinX) * 512.0));
        int topBlockZ = class_3532.method_15357((double)((py / (double)this.largeMap.scrollHeight * (double)dy + (double)this.regionMinZ) * 512.0));
        int bottomBlockX = class_3532.method_15357((double)(((px + (double)w) / (double)this.largeMap.scrollWidth * (double)dx + (double)this.regionMinX) * 512.0));
        int bottomBlockZ = class_3532.method_15357((double)(((py + (double)h) / (double)this.largeMap.scrollHeight * (double)dy + (double)this.regionMinZ) * 512.0));
        this.visibleArea = new class_768(topBlockX, topBlockZ, bottomBlockX - topBlockX + 1, bottomBlockZ - topBlockZ + 1);
        this.regionX = ((double)this.parent.getMouseX() + px) / (double)this.largeMap.scrollWidth * (double)dx + (double)this.regionMinX;
        this.regionZ = ((double)this.parent.getMouseY() + py) / (double)this.largeMap.scrollHeight * (double)dy + (double)this.regionMinZ;
        this.blockX = class_3532.method_15357((double)(this.regionX * 512.0));
        this.blockZ = class_3532.method_15357((double)(this.regionZ * 512.0));
        this.blockIndex = (this.blockX & 0x1FF) + (this.blockZ & 0x1FF) * 512;
        this.blockY = -32767;
        MapRegion r = this.largeMap.dimension.getRegions().get(XZ.regionFromBlock((int)this.blockX, (int)this.blockZ));
        if (r != null && (data = r.getData()) != null) {
            this.blockY = data.height[this.blockIndex];
        }
    }

    public void addMouseOverText(TooltipList list) {
        MapRegionData data;
        super.addMouseOverText(list);
        MapRegion r = this.largeMap.dimension.getRegions().get(XZ.regionFromBlock((int)this.blockX, (int)this.blockZ));
        if (r != null && (data = r.getData()) != null) {
            ClientTeam team;
            MapChunk c = r.getMapChunk(XZ.of((int)(this.blockX >> 4 & 0x1F), (int)(this.blockZ >> 4 & 0x1F)));
            ClientTeam clientTeam = team = c == null ? null : c.getTeam();
            if (team != null) {
                list.add(team.getName());
            }
        }
    }

    public boolean mousePressed(MouseButton button) {
        if (super.mousePressed(button)) {
            return true;
        }
        if (button.isLeft() && this.isMouseOver()) {
            this.largeMap.prevMouseX = this.getMouseX();
            this.largeMap.prevMouseY = this.getMouseY();
            this.largeMap.grabbed = 1;
            return true;
        }
        return false;
    }

    public void mouseReleased(MouseButton button) {
        super.mouseReleased(button);
        this.largeMap.grabbed = 0;
    }

    public boolean scrollPanel(double scroll) {
        if (this.isMouseOver()) {
            this.largeMap.addZoom(scroll);
            return true;
        }
        return false;
    }
}

