/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials;

import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.ChatEvent;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbessentials.command.FTBEssentialsCommands;
import dev.ftb.mods.ftbessentials.command.TPACommands;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.FTBEWorldData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import dev.ftb.mods.ftbessentials.util.WarmupCooldownTeleporter;
import dev.ftb.mods.ftblibrary.util.TimeUtils;
import java.nio.file.Path;
import java.util.Iterator;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1656;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class FTBEEventHandler {
    public static final class_5218 CONFIG_FILE = new class_5218("serverconfig/ftbessentials.snbt");
    private static final String[] DEFAULT_CONFIG = new String[]{"Default config file that will be copied to world's serverconfig/ftbessentials.snbt location", "Copy values you wish to override in here", "Example:", "", "{", "\tmisc: {", "\t\tenderchest: {", "\t\t\tenabled: false", "\t\t}", "\t}", "}"};

    public static void init() {
        LifecycleEvent.SERVER_BEFORE_START.register(FTBEEventHandler::serverAboutToStart);
        LifecycleEvent.SERVER_STOPPED.register(FTBEEventHandler::serverStopped);
        LifecycleEvent.SERVER_LEVEL_SAVE.register(FTBEEventHandler::levelSave);
        TickEvent.SERVER_POST.register(FTBEEventHandler::serverTickPost);
        TickEvent.PLAYER_POST.register(FTBEEventHandler::playerTickPost);
        CommandRegistrationEvent.EVENT.register(FTBEEventHandler::registerCommands);
        PlayerEvent.PLAYER_JOIN.register(FTBEEventHandler::playerLoggedIn);
        PlayerEvent.PLAYER_QUIT.register(FTBEEventHandler::playerLoggedOut);
        PlayerEvent.PLAYER_CLONE.register(FTBEEventHandler::onPlayerDeath);
        PlayerEvent.CHANGE_DIMENSION.register(FTBEEventHandler::playerChangedDimension);
        EntityEvent.LIVING_HURT.register(FTBEEventHandler::playerHurt);
        ChatEvent.RECEIVED.register(FTBEEventHandler::playerChat);
    }

    private static void serverAboutToStart(MinecraftServer minecraftServer) {
        Path configFilePath = minecraftServer.method_27050(CONFIG_FILE);
        Path defaultConfigFilePath = Platform.getConfigFolder().resolve("../defaultconfigs/ftbessentials-server.snbt");
        FTBEConfig.CONFIG.load(configFilePath, defaultConfigFilePath, () -> DEFAULT_CONFIG);
        FTBEPlayerData.MAP.clear();
        FTBEWorldData.instance = new FTBEWorldData(minecraftServer);
        FTBEWorldData.instance.load();
    }

    private static void serverStopped(MinecraftServer minecraftServer) {
        FTBEWorldData.instance = null;
        TPACommands.REQUESTS.clear();
    }

    private static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext, class_2170.class_5364 commandSelection) {
        FTBEssentialsCommands.registerCommands(dispatcher);
    }

    private static void levelSave(class_3218 serverLevel) {
        if (FTBEWorldData.instance != null) {
            FTBEWorldData.instance.saveNow();
            FTBEPlayerData.MAP.values().forEach(FTBEPlayerData::saveNow);
        }
    }

    private static void playerLoggedIn(class_3222 serverPlayer) {
        FTBEPlayerData data = FTBEPlayerData.get((class_1657)serverPlayer);
        if (data != null) {
            data.load();
            data.lastSeen = new TeleportPos((class_1297)serverPlayer);
            data.markDirty();
            for (FTBEPlayerData d : FTBEPlayerData.MAP.values()) {
                d.sendTabName(serverPlayer);
            }
        }
    }

    private static void playerLoggedOut(class_3222 serverPlayer) {
        FTBEPlayerData data = FTBEPlayerData.get((class_1657)serverPlayer);
        if (data != null) {
            data.lastSeen = new TeleportPos((class_1297)serverPlayer);
            data.markDirty();
        }
    }

    private static void playerTickPost(class_1657 player) {
        if (!player.field_6002.field_9236) {
            FTBEPlayerData data = FTBEPlayerData.get(player);
            class_1656 abilities = player.method_31549();
            if (data == null) {
                return;
            }
            if (data.god && !abilities.field_7480) {
                abilities.field_7480 = true;
                player.method_7355();
            }
            if (data.fly && !abilities.field_7478) {
                abilities.field_7478 = true;
                player.method_7355();
            }
        }
    }

    private static void serverTickPost(MinecraftServer server) {
        long now = System.currentTimeMillis();
        Iterator<TPACommands.TPARequest> iterator = TPACommands.REQUESTS.values().iterator();
        while (iterator.hasNext()) {
            TPACommands.TPARequest r = iterator.next();
            if (now <= r.created() + 60000L) continue;
            class_3222 source = server.method_3760().method_14602(r.source().uuid);
            class_3222 target = server.method_3760().method_14602(r.target().uuid);
            if (source != null) {
                source.method_43496((class_2561)class_2561.method_43470((String)"TPA request expired!"));
            }
            if (target != null) {
                target.method_43496((class_2561)class_2561.method_43470((String)"TPA request expired!"));
            }
            iterator.remove();
        }
        if (server.method_3780() % 20 == 0) {
            WarmupCooldownTeleporter.tickWarmups(server);
            FTBEWorldData.instance.tickMuteTimeouts(server);
        }
    }

    private static EventResult playerChat(@Nullable class_3222 serverPlayer, class_2561 component) {
        FTBEPlayerData data;
        if (serverPlayer != null && (data = FTBEPlayerData.get((class_1657)serverPlayer)) != null && data.muted) {
            serverPlayer.method_7353((class_2561)class_2561.method_43470((String)"You can't use chat, you've been muted by an admin!").method_27692(class_124.field_1061), false);
            FTBEWorldData.instance.getMuteTimeout(serverPlayer).ifPresent(expiry -> {
                long left = (expiry - System.currentTimeMillis()) / 1000L;
                serverPlayer.method_7353((class_2561)class_2561.method_43470((String)("Mute expiry in: " + TimeUtils.prettyTimeString((long)left))).method_27692(class_124.field_1061), false);
            });
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static void onPlayerDeath(class_3222 oldPlayer, class_3222 newPlayer, boolean wonGame) {
        if (!wonGame) {
            if (newPlayer.method_5805()) {
                oldPlayer.method_43122().ifPresent(loc -> FTBEPlayerData.addTeleportHistory(oldPlayer));
            } else if (oldPlayer.method_5805()) {
                newPlayer.method_43122().ifPresent(loc -> FTBEPlayerData.addTeleportHistory(newPlayer));
            }
        }
    }

    private static EventResult playerHurt(class_1309 livingEntity, class_1282 damageSource, float amount) {
        if (livingEntity instanceof class_3222) {
            class_3222 sp = (class_3222)livingEntity;
            if (amount > 0.0f) {
                WarmupCooldownTeleporter.cancelWarmup(sp);
            }
        }
        return EventResult.pass();
    }

    private static void playerChangedDimension(class_3222 serverPlayer, class_5321<class_1937> oldDimension, class_5321<class_1937> newDimension) {
        WarmupCooldownTeleporter.cancelWarmup(serverPlayer);
    }
}

