/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.mixin.PlayerListAccess;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.FTBEWorldData;
import dev.ftb.mods.ftbessentials.util.Leaderboard;
import dev.ftb.mods.ftblibrary.util.PlayerDisplayNameUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3442;
import net.minecraft.class_3908;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_747;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class MiscCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        if (FTBEConfig.KICKME.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"kickme").requires((Predicate)FTBEConfig.KICKME)).executes(context -> MiscCommands.kickme(((class_2168)context.getSource()).method_9207())));
        }
        if (FTBEConfig.TRASHCAN.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"trashcan").requires((Predicate)FTBEConfig.TRASHCAN)).executes(context -> MiscCommands.trashcan(((class_2168)context.getSource()).method_9207())));
        }
        if (FTBEConfig.ENDER_CHEST.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"enderchest").requires((Predicate)FTBEConfig.ENDER_CHEST)).executes(context -> MiscCommands.enderChest(((class_2168)context.getSource()).method_9207(), null))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(source -> source.method_9259(2))).executes(context -> MiscCommands.enderChest(((class_2168)context.getSource()).method_9207(), class_2186.method_9315((CommandContext)context, (String)"player")))));
        }
        LiteralArgumentBuilder leaderboardCommand = class_2170.method_9247((String)"leaderboard");
        for (Leaderboard<?> leaderboard : Leaderboard.MAP.values()) {
            leaderboardCommand = (LiteralArgumentBuilder)leaderboardCommand.then(class_2170.method_9247((String)leaderboard.name).executes(context -> MiscCommands.leaderboard((class_2168)context.getSource(), leaderboard, false)));
        }
        dispatcher.register(leaderboardCommand);
        if (FTBEConfig.REC.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"recording").requires((Predicate)FTBEConfig.REC)).executes(context -> MiscCommands.recording(((class_2168)context.getSource()).method_9207())));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"streaming").requires((Predicate)FTBEConfig.REC)).executes(context -> MiscCommands.streaming(((class_2168)context.getSource()).method_9207())));
        }
        if (FTBEConfig.HAT.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"hat").requires(FTBEConfig.HAT.enabledAndOp())).executes(context -> MiscCommands.hat(((class_2168)context.getSource()).method_9207())));
        }
        if (FTBEConfig.NICK.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"nickname").requires((Predicate)FTBEConfig.NICK)).executes(context -> MiscCommands.nickname(((class_2168)context.getSource()).method_9207(), ""))).then(class_2170.method_9244((String)"nickname", (ArgumentType)StringArgumentType.greedyString()).executes(context -> MiscCommands.nickname(((class_2168)context.getSource()).method_9207(), StringArgumentType.getString((CommandContext)context, (String)"nickname")))));
        }
    }

    private static int enderChest(class_3222 player, @Nullable class_3222 target) {
        class_5250 title = class_2561.method_43471((String)"container.enderchest");
        if (target != null) {
            title.method_27693(" \u00d7 ").method_10852(target.method_5476());
        }
        class_3222 t = target == null ? player : target;
        player.method_17355((class_3908)new class_747((i, inv, p) -> class_1707.method_19245((int)i, (class_1661)inv, (class_1263)t.method_7274()), (class_2561)title));
        return 1;
    }

    public static int kickme(class_3222 player) {
        player.field_13987.method_14367((class_2561)class_2561.method_43470((String)"You kicked yourself!"));
        return 1;
    }

    public static int trashcan(class_3222 player) {
        player.method_17355(new class_3908(){

            public class_2561 method_5476() {
                return class_2561.method_43470((String)"Trash Can");
            }

            public class_1703 createMenu(int id, class_1661 playerInventory, class_1657 player) {
                return class_1707.method_19249((int)id, (class_1661)playerInventory);
            }
        });
        return 1;
    }

    public static <T extends Number> int leaderboard(class_2168 source, Leaderboard<T> leaderboard, boolean reverse) {
        try (Stream<Path> stream = Files.list(FTBEWorldData.instance.mkdirs("playerdata"));){
            stream.filter(path -> path.toString().endsWith(".json")).map(Path::getFileName).map(path -> new GameProfile(UUID.fromString(path.toString().replace(".json", "")), null)).filter(profile -> !FTBEPlayerData.MAP.containsKey(profile.getId())).map(FTBEPlayerData::get).filter(Objects::nonNull).forEach(FTBEPlayerData::load);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ArrayList<Pair> list = new ArrayList<Pair>();
        int self = -1;
        for (FTBEPlayerData playerData : FTBEPlayerData.MAP.values()) {
            class_3442 stats = MiscCommands.getPlayerStats(source.method_9211(), playerData.uuid);
            Number num = (Number)leaderboard.valueGetter.apply(stats);
            if (!leaderboard.filter.test(num)) continue;
            list.add(Pair.of((Object)playerData, (Object)num));
        }
        if (reverse) {
            list.sort(Comparator.comparingDouble(pair -> ((Number)pair.getRight()).doubleValue()));
        } else {
            list.sort((pair1, pair2) -> Double.compare(((Number)pair2.getRight()).doubleValue(), ((Number)pair1.getRight()).doubleValue()));
        }
        if (source.method_9228() instanceof class_3222) {
            for (int i = 0; i < list.size(); ++i) {
                if (!((FTBEPlayerData)((Pair)list.get((int)i)).getLeft()).uuid.equals(source.method_9228().method_5667())) continue;
                self = list.size();
                break;
            }
        }
        source.method_9226((class_2561)class_2561.method_43470((String)("== Leaderboard [" + leaderboard.name + "] ==")).method_27692(class_124.field_1077), false);
        if (list.isEmpty()) {
            source.method_9226((class_2561)class_2561.method_43470((String)"No data!").method_27692(class_124.field_1080), false);
            return 1;
        }
        for (int i = 0; i < Math.min(20, list.size()); ++i) {
            Pair pair3 = (Pair)list.get(i);
            Object num = String.valueOf(i + 1);
            if (i < 10) {
                num = "0" + (String)num;
            }
            class_5250 component = class_2561.method_43470((String)"");
            component.method_27692(class_124.field_1080);
            if (i == 0) {
                component.method_10852((class_2561)class_2561.method_43470((String)("#" + (String)num + " ")).method_27696(class_2583.field_24360.method_27703(class_5251.method_27717((int)13938487))));
            } else if (i == 1) {
                component.method_10852((class_2561)class_2561.method_43470((String)("#" + (String)num + " ")).method_27696(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xC0C0C0))));
            } else if (i == 2) {
                component.method_10852((class_2561)class_2561.method_43470((String)("#" + (String)num + " ")).method_27696(class_2583.field_24360.method_27703(class_5251.method_27717((int)10451508))));
            } else {
                component.method_10852((class_2561)class_2561.method_43470((String)("#" + (String)num + " ")));
            }
            component.method_10852((class_2561)class_2561.method_43470((String)((FTBEPlayerData)pair3.getLeft()).name).method_27692(i == self ? class_124.field_1060 : class_124.field_1054));
            component.method_10852((class_2561)class_2561.method_43470((String)": "));
            component.method_10852((class_2561)class_2561.method_43470((String)leaderboard.stringGetter.apply((Number)pair3.getRight())));
            source.method_9226((class_2561)component, false);
        }
        return 1;
    }

    public static int recording(class_3222 player) {
        FTBEPlayerData data = FTBEPlayerData.get((class_1657)player);
        if (data == null) {
            return 0;
        }
        data.recording = data.recording == 1 ? 0 : 1;
        data.markDirty();
        PlayerDisplayNameUtil.refreshDisplayName((class_1657)player);
        if (data.recording == 1) {
            player.field_13995.method_3760().method_43514((class_2561)player.method_5476().method_27661().method_27692(class_124.field_1054).method_27693(" is now recording!"), false);
        } else {
            player.field_13995.method_3760().method_43514((class_2561)player.method_5476().method_27661().method_27692(class_124.field_1054).method_27693(" is no longer recording!"), false);
        }
        data.sendTabName(player.field_13995);
        return 1;
    }

    public static int streaming(class_3222 player) {
        FTBEPlayerData data = FTBEPlayerData.get((class_1657)player);
        if (data == null) {
            return 0;
        }
        data.recording = data.recording == 2 ? 0 : 2;
        data.markDirty();
        PlayerDisplayNameUtil.refreshDisplayName((class_1657)player);
        if (data.recording == 2) {
            player.field_13995.method_3760().method_43514((class_2561)player.method_5476().method_27661().method_27692(class_124.field_1054).method_27693(" is now streaming!"), false);
        } else {
            player.field_13995.method_3760().method_43514((class_2561)player.method_5476().method_27661().method_27692(class_124.field_1054).method_27693(" is no longer streaming!"), false);
        }
        data.sendTabName(player.field_13995);
        return 1;
    }

    public static int hat(class_3222 player) {
        class_1799 hstack = player.method_6118(class_1304.field_6169);
        class_1799 istack = player.method_6118(class_1304.field_6173);
        player.method_5673(class_1304.field_6169, istack);
        player.method_5673(class_1304.field_6173, hstack);
        player.field_7498.method_7623();
        return 1;
    }

    public static int nickname(class_3222 player, String nick) {
        if (nick.length() > 30) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Nickname too long!"), false);
            return 0;
        }
        FTBEPlayerData data = FTBEPlayerData.get((class_1657)player);
        if (data == null) {
            return 0;
        }
        data.nick = nick.trim();
        data.markDirty();
        PlayerDisplayNameUtil.refreshDisplayName((class_1657)player);
        if (data.nick.isEmpty()) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Nickname reset!"), false);
        } else {
            player.method_7353((class_2561)class_2561.method_43470((String)("Nickname changed to '" + data.nick + "'")), false);
        }
        data.sendTabName(player.field_13995);
        return 1;
    }

    private static class_3442 getPlayerStats(MinecraftServer server, UUID playerId) {
        Map<UUID, class_3442> stats = ((PlayerListAccess)server.method_3760()).getStats();
        return stats.computeIfAbsent(playerId, k -> {
            File file1 = server.method_27050(class_5218.field_24181).toFile();
            File file2 = new File(file1, playerId + ".json");
            return new class_3442(server, file2);
        });
    }
}

