/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import java.util.HashMap;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class TPACommands {
    public static final HashMap<String, TPARequest> REQUESTS = new HashMap();

    public static TPARequest create(FTBEPlayerData source, FTBEPlayerData target, boolean here) {
        String key;
        while (REQUESTS.containsKey(key = String.format("%08X", new Random().nextInt()))) {
        }
        TPARequest r = new TPARequest(key, source, target, here, System.currentTimeMillis());
        REQUESTS.put(key, r);
        return r;
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        if (FTBEConfig.TPA.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpa").requires((Predicate)FTBEConfig.TPA)).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(context -> TPACommands.tpa(((class_2168)context.getSource()).method_9207(), class_2186.method_9315((CommandContext)context, (String)"target"), false))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpahere").requires((Predicate)FTBEConfig.TPA)).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(context -> TPACommands.tpa(((class_2168)context.getSource()).method_9207(), class_2186.method_9315((CommandContext)context, (String)"target"), true))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpaccept").requires((Predicate)FTBEConfig.TPA)).then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).executes(context -> TPACommands.tpaccept(((class_2168)context.getSource()).method_9207(), StringArgumentType.getString((CommandContext)context, (String)"id")))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpdeny").requires((Predicate)FTBEConfig.TPA)).then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).executes(context -> TPACommands.tpdeny(((class_2168)context.getSource()).method_9207(), StringArgumentType.getString((CommandContext)context, (String)"id")))));
        }
    }

    public static int tpa(class_3222 player, class_3222 target, boolean here) {
        TeleportPos.TeleportResult result;
        FTBEPlayerData dataSource = FTBEPlayerData.get((class_1657)player);
        FTBEPlayerData dataTarget = FTBEPlayerData.get((class_1657)target);
        if (dataSource == null || dataTarget == null) {
            return 0;
        }
        if (REQUESTS.values().stream().anyMatch(r -> r.source == dataSource && r.target == dataTarget)) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Request already sent!"), false);
            return 0;
        }
        TeleportPos.TeleportResult teleportResult = result = here ? dataTarget.tpaTeleporter.checkCooldown() : dataSource.tpaTeleporter.checkCooldown();
        if (!result.isSuccess()) {
            return result.runCommand(player);
        }
        TPARequest request = TPACommands.create(dataSource, dataTarget, here);
        class_5250 component = class_2561.method_43470((String)"TPA request! [ ");
        component.method_10852((class_2561)(here ? target : player).method_5476().method_27661().method_27692(class_124.field_1054));
        component.method_27693(" \u27a1 ");
        component.method_10852((class_2561)(here ? player : target).method_5476().method_27661().method_27692(class_124.field_1054));
        component.method_27693(" ]");
        class_5250 component2 = class_2561.method_43470((String)"Click one of these: ");
        component2.method_10852((class_2561)class_2561.method_43470((String)"Accept \u2714").method_10862(class_2583.field_24360.method_27706(class_124.field_1060).method_10982(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, "/tpaccept " + request.id)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to Accept")))));
        component2.method_27693(" | ");
        component2.method_10852((class_2561)class_2561.method_43470((String)"Deny \u274c").method_10862(class_2583.field_24360.method_27706(class_124.field_1061).method_10982(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, "/tpdeny " + request.id)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to Deny")))));
        component2.method_27693(" |");
        target.method_7353((class_2561)component, false);
        target.method_7353((class_2561)component2, false);
        player.method_7353((class_2561)class_2561.method_43470((String)"Request sent!"), false);
        return 1;
    }

    public static int tpaccept(class_3222 player, String id) {
        TeleportPos.TeleportResult result;
        TPARequest request = REQUESTS.get(id);
        if (request == null) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Invalid request!"), false);
            return 0;
        }
        class_3222 sourcePlayer = player.field_13995.method_3760().method_14602(request.source.uuid);
        if (sourcePlayer == null) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Player has gone offline!"), false);
            return 0;
        }
        TeleportPos.TeleportResult teleportResult = result = request.here ? request.target.tpaTeleporter.teleport(player, p -> new TeleportPos((class_1297)sourcePlayer)) : request.source.tpaTeleporter.teleport(sourcePlayer, p -> new TeleportPos((class_1297)player));
        if (result.isSuccess()) {
            REQUESTS.remove(request.id);
        }
        return result.runCommand(player);
    }

    public static int tpdeny(class_3222 player, String id) {
        TPARequest request = REQUESTS.get(id);
        if (request == null) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Invalid request!"), false);
            return 0;
        }
        REQUESTS.remove(request.id);
        player.method_7353((class_2561)class_2561.method_43470((String)"Request denied!"), false);
        class_3222 player2 = player.field_13995.method_3760().method_14602(request.target.uuid);
        if (player2 != null) {
            player2.method_7353((class_2561)class_2561.method_43470((String)"Request denied!"), false);
        }
        return 1;
    }

    public record TPARequest(String id, FTBEPlayerData source, FTBEPlayerData target, boolean here, long created) {
    }
}

