/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.event.EventResult;
import dev.ftb.mods.ftbessentials.FTBEssentialsEvents;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.DimensionFilter;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2191;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2784;
import net.minecraft.class_2806;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6908;

public class TeleportCommands {
    public static final class_6862<class_2248> IGNORE_RTP = class_6862.method_40092((class_5321)class_2378.field_25105, (class_2960)new class_2960("ftbessentials", "ignore_rtp"));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        if (FTBEConfig.BACK.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"back").requires((Predicate)FTBEConfig.BACK)).executes(context -> TeleportCommands.back(((class_2168)context.getSource()).method_9207())));
        }
        if (FTBEConfig.SPAWN.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"spawn").requires((Predicate)FTBEConfig.SPAWN)).executes(context -> TeleportCommands.spawn(((class_2168)context.getSource()).method_9207())));
        }
        if (FTBEConfig.RTP.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rtp").requires((Predicate)FTBEConfig.RTP)).executes(context -> TeleportCommands.rtp(((class_2168)context.getSource()).method_9207())));
        }
        if (FTBEConfig.TPL.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"teleport_last").requires(FTBEConfig.TPL.enabledAndOp())).then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).executes(context -> TeleportCommands.tpLast(((class_2168)context.getSource()).method_9207(), (GameProfile)class_2191.method_9330((CommandContext)context, (String)"player").iterator().next()))));
        }
        if (FTBEConfig.TPX.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpx").requires(FTBEConfig.TPX.enabledAndOp())).then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(context -> TeleportCommands.tpx(((class_2168)context.getSource()).method_9207(), class_2181.method_9289((CommandContext)context, (String)"dimension")))));
        }
    }

    public static int back(class_3222 player) {
        FTBEPlayerData data = FTBEPlayerData.get((class_1657)player);
        if (data.teleportHistory.isEmpty()) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Teleportation history is empty!").method_27692(class_124.field_1061), false);
            return 0;
        }
        if (data.backTeleporter.teleport(player, serverPlayerEntity -> data.teleportHistory.getLast()).runCommand(player) != 0) {
            data.markDirty();
            return 1;
        }
        return 0;
    }

    public static int spawn(class_3222 player) {
        FTBEPlayerData data = FTBEPlayerData.get((class_1657)player);
        class_3218 w = player.field_13995.method_3847(class_1937.field_25179);
        if (w == null) {
            return 0;
        }
        return data.spawnTeleporter.teleport(player, p -> new TeleportPos((class_1937)w, w.method_43126(), Float.valueOf(w.method_43127()), Float.valueOf(0.0f))).runCommand(player);
    }

    public static int rtp(class_3222 player) {
        if (!player.method_5687(2) && !DimensionFilter.isDimensionOK((class_5321<class_1937>)player.method_14220().method_27983())) {
            player.method_7353((class_2561)class_2561.method_43470((String)"You may not use /rtp in this dimension!").method_27692(class_124.field_1061), false);
            return 0;
        }
        FTBEPlayerData data = FTBEPlayerData.get((class_1657)player);
        return data.rtpTeleporter.teleport(player, p -> {
            p.method_7353((class_2561)class_2561.method_43470((String)"Looking for random location..."), false);
            return TeleportCommands.findBlockPos(player.method_14220(), p, 1);
        }).runCommand(player);
    }

    private static TeleportPos findBlockPos(class_3218 world, class_3222 player, int attempt) {
        if (attempt > (Integer)FTBEConfig.RTP_MAX_TRIES.get()) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Could not find a valid location to teleport to!").method_27692(class_124.field_1061), false);
            return new TeleportPos((class_1297)player);
        }
        double dist = (double)((Integer)FTBEConfig.RTP_MIN_DISTANCE.get()).intValue() + world.field_9229.method_43058() * (double)((Integer)FTBEConfig.RTP_MAX_DISTANCE.get() - (Integer)FTBEConfig.RTP_MIN_DISTANCE.get());
        double angle = world.field_9229.method_43058() * Math.PI * 2.0;
        int x = class_3532.method_15357((double)(Math.cos(angle) * dist));
        int y = 256;
        int z = class_3532.method_15357((double)(Math.sin(angle) * dist));
        class_2338 currentPos = new class_2338(x, y, z);
        class_2784 border = world.method_8621();
        if (!border.method_11952(currentPos)) {
            return TeleportCommands.findBlockPos(world, player, attempt + 1);
        }
        if (world.method_23753(currentPos).method_40220(class_6908.field_36509)) {
            return TeleportCommands.findBlockPos(world, player, attempt + 1);
        }
        EventResult res = ((FTBEssentialsEvents.RTP)FTBEssentialsEvents.RTP_EVENT.invoker()).teleport(world, player, currentPos, attempt);
        if (res.isFalse()) {
            return TeleportCommands.findBlockPos(world, player, attempt + 1);
        }
        world.method_22342(currentPos.method_10263() >> 4, currentPos.method_10260() >> 4, class_2806.field_12800);
        class_2338 hmPos = world.method_8598(class_2902.class_2903.field_13203, currentPos);
        if (hmPos.method_10264() > 0) {
            if (hmPos.method_10264() >= world.method_32819()) {
                for (class_2338 newPos : class_2338.method_30512((class_2338)new class_2338(hmPos.method_10263(), world.method_8615(), hmPos.method_10264()), (int)16, (class_2350)class_2350.field_11034, (class_2350)class_2350.field_11035)) {
                    class_2680 bs = world.method_8320(newPos);
                    if (!bs.method_26207().method_15804() || bs.method_26164(IGNORE_RTP) || !world.method_22347(newPos.method_10086(1)) || !world.method_22347(newPos.method_10086(2)) || !world.method_22347(newPos.method_10086(3))) continue;
                    player.method_7353((class_2561)class_2561.method_43470((String)String.format("Found good location after %d " + (attempt == 1 ? "attempt" : "attempts") + " @ [x %d, z %d]", attempt, newPos.method_10263(), newPos.method_10260())), false);
                    return new TeleportPos((class_5321<class_1937>)world.method_27983(), newPos.method_10084());
                }
            } else {
                player.method_7353((class_2561)class_2561.method_43470((String)String.format("Found good location after %d " + (attempt == 1 ? "attempt" : "attempts") + " @ [x %d, z %d]", attempt, hmPos.method_10263(), hmPos.method_10260())), false);
                return new TeleportPos((class_5321<class_1937>)world.method_27983(), hmPos.method_10084());
            }
        }
        return TeleportCommands.findBlockPos(world, player, attempt + 1);
    }

    public static int tpLast(class_3222 player, GameProfile to) {
        class_3222 p = player.field_13995.method_3760().method_14602(to.getId());
        if (p != null) {
            FTBEPlayerData.addTeleportHistory(player);
            new TeleportPos((class_1297)p).teleport(player);
            return 1;
        }
        FTBEPlayerData dataTo = FTBEPlayerData.get(to);
        if (dataTo == null) {
            return 0;
        }
        FTBEPlayerData.addTeleportHistory(player);
        dataTo.lastSeen.teleport(player);
        return 1;
    }

    public static int tpx(class_3222 player, class_3218 to) {
        player.method_14251(to, player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
        return 1;
    }
}

