/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.FTBEWorldData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class WarpCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        if (FTBEConfig.WARP.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"warp").requires((Predicate)FTBEConfig.WARP)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(WarpCommands.getWarpSuggestions((CommandContext<class_2168>)context), (SuggestionsBuilder)builder)).executes(context -> WarpCommands.warp(((class_2168)context.getSource()).method_9207(), StringArgumentType.getString((CommandContext)context, (String)"name")))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"setwarp").requires(FTBEConfig.WARP.enabledAndOp())).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> WarpCommands.setwarp(((class_2168)context.getSource()).method_9207(), StringArgumentType.getString((CommandContext)context, (String)"name")))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"delwarp").requires(FTBEConfig.WARP.enabledAndOp())).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(WarpCommands.getWarpSuggestions((CommandContext<class_2168>)context), (SuggestionsBuilder)builder)).executes(context -> WarpCommands.delwarp(((class_2168)context.getSource()).method_9207(), StringArgumentType.getString((CommandContext)context, (String)"name")))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"listwarps").requires((Predicate)FTBEConfig.WARP)).executes(context -> WarpCommands.listwarps((class_2168)context.getSource())));
        }
    }

    public static Set<String> getWarpSuggestions(CommandContext<class_2168> context) {
        return FTBEWorldData.instance.warps.keySet();
    }

    public static int warp(class_3222 player, String name) {
        FTBEPlayerData data = FTBEPlayerData.get((class_1657)player);
        TeleportPos pos = FTBEWorldData.instance.warps.get(name.toLowerCase());
        if (pos == null) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Warp not found!"), false);
            return 0;
        }
        return data.warpTeleporter.teleport(player, p -> pos).runCommand(player);
    }

    public static int setwarp(class_3222 player, String name) {
        FTBEWorldData.instance.warps.put(name.toLowerCase(), new TeleportPos((class_1297)player));
        FTBEWorldData.instance.markDirty();
        player.method_7353((class_2561)class_2561.method_43470((String)"Warp set!"), false);
        return 1;
    }

    public static int delwarp(class_3222 player, String name) {
        if (FTBEWorldData.instance.warps.remove(name.toLowerCase()) != null) {
            FTBEWorldData.instance.markDirty();
            player.method_7353((class_2561)class_2561.method_43470((String)"Warp deleted!"), false);
            return 1;
        }
        player.method_7353((class_2561)class_2561.method_43470((String)"Warp not found!"), false);
        return 0;
    }

    public static int listwarps(class_2168 source) {
        if (FTBEWorldData.instance.warps.isEmpty()) {
            source.method_9226((class_2561)class_2561.method_43470((String)"None"), false);
            return 1;
        }
        TeleportPos origin = new TeleportPos((class_5321<class_1937>)source.method_9225().method_27983(), new class_2338(source.method_9222()));
        for (Map.Entry<String, TeleportPos> entry : FTBEWorldData.instance.warps.entrySet()) {
            source.method_9226((class_2561)class_2561.method_43470((String)(entry.getKey() + ": " + entry.getValue().distanceString(origin))), false);
        }
        return 1;
    }
}

