/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_156;
import net.minecraft.class_3442;
import net.minecraft.class_3468;

public class Leaderboard<N extends Number> {
    public static final DecimalFormat DECIMAL_FORMAT = (DecimalFormat)class_156.method_654((Object)new DecimalFormat("########0.00"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    public static final Map<String, Leaderboard<?>> MAP = new LinkedHashMap();
    public final String name;
    public final N defaultValue;
    public Function<class_3442, N> valueGetter;
    public Predicate<N> filter;
    public Function<N, String> stringGetter;

    public static <T extends Number> Leaderboard<T> add(String name, T defaultValue) {
        Leaderboard<T> leaderboard = new Leaderboard<T>(name, defaultValue);
        MAP.put(name, leaderboard);
        return leaderboard;
    }

    public Leaderboard(String n, N def) {
        this.name = n;
        this.defaultValue = def;
        this.valueGetter = stats -> this.defaultValue;
        this.filter = num -> !num.equals(this.defaultValue);
        this.stringGetter = num -> NumberFormat.getIntegerInstance(Locale.US).format(num.intValue());
    }

    public Leaderboard<N> value(Function<class_3442, N> v) {
        this.valueGetter = v;
        return this;
    }

    public Leaderboard<N> filter(Predicate<N> f) {
        this.filter = f;
        return this;
    }

    public Leaderboard<N> string(Function<N, String> s) {
        this.stringGetter = s;
        return this;
    }

    public Leaderboard<N> formatDivideByTen() {
        return this.string(value -> DECIMAL_FORMAT.format(value.doubleValue() * 0.1));
    }

    public Leaderboard<N> formatDistance() {
        return this.string(value -> {
            double d0 = value.doubleValue() / 100.0;
            double d1 = d0 / 1000.0;
            if (d1 > 0.5) {
                return DECIMAL_FORMAT.format(d1) + " km";
            }
            return d0 > 0.5 ? DECIMAL_FORMAT.format(d0) + " m" : value + " cm";
        });
    }

    public Leaderboard<N> formatTime() {
        return this.string(value -> {
            double d0 = value.doubleValue() / 20.0;
            double d1 = d0 / 60.0;
            double d2 = d1 / 60.0;
            double d3 = d2 / 24.0;
            double d4 = d3 / 365.0;
            if (d4 > 0.5) {
                return DECIMAL_FORMAT.format(d4) + " y";
            }
            if (d3 > 0.5) {
                return DECIMAL_FORMAT.format(d3) + " d";
            }
            if (d2 > 0.5) {
                return DECIMAL_FORMAT.format(d2) + " h";
            }
            return d1 > 0.5 ? DECIMAL_FORMAT.format(d1) + " m" : d0 + " s";
        });
    }

    static {
        Leaderboard.add("deaths", 0).value(stats -> stats.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15421)));
        Leaderboard.add("time_played", 0).value(stats -> stats.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15417))).formatTime();
        Leaderboard.add("deaths_per_hour", 0.0).value(stats -> {
            int d = stats.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15421));
            int t = stats.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15417));
            return d <= 0 || t < 72000 ? 0.0 : (double)d * 72000.0 / (double)t;
        }).string(value -> DECIMAL_FORMAT.format((double)value));
        Leaderboard.add("player_kills", 0).value(stats -> stats.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15404)));
        Leaderboard.add("mob_kills", 0).value(stats -> stats.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15414)));
        Leaderboard.add("damage_dealt", 0).value(stats -> stats.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15399))).formatDivideByTen();
        Leaderboard.add("jumps", 0).value(stats -> stats.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15428)));
        Leaderboard.add("distance_walked", 0).value(stats -> stats.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15377))).formatDistance();
        Leaderboard.add("time_since_death", 0).value(stats -> stats.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15400))).formatTime();
    }
}

