/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary;

import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientTextureStitchEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.hooks.client.screen.ScreenAccess;
import dev.architectury.platform.Platform;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.ftb.mods.ftblibrary.FTBLibraryCommon;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ImageConfig;
import dev.ftb.mods.ftblibrary.config.IntConfig;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.AtlasSpriteIcon;
import dev.ftb.mods.ftblibrary.icon.IconPresets;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonManager;
import dev.ftb.mods.ftblibrary.sidebar.SidebarGroupGuiButton;
import dev.ftb.mods.ftblibrary.ui.CursorType;
import dev.ftb.mods.ftblibrary.ui.IScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.misc.SelectImageScreen;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import me.shedaniel.rei.api.client.config.ConfigObject;
import net.minecraft.class_1059;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_485;
import org.jetbrains.annotations.Nullable;

public class FTBLibraryClient
extends FTBLibraryCommon {
    public static int showButtons = 1;
    public CursorType lastCursorType = null;

    @Override
    public void init() {
        if (Platform.isModLoaded((String)"roughlyenoughitems")) {
            showButtons = 3;
        }
        if (class_310.method_1551() == null) {
            return;
        }
        ClientTextureStitchEvent.PRE.register(this::textureStitch);
        ClientGuiEvent.INIT_POST.register(this::guiInit);
        ClientTickEvent.CLIENT_POST.register(this::clientTick);
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_3302)SidebarButtonManager.INSTANCE);
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_3302)SelectImageScreen.ResourceListener.INSTANCE);
    }

    private void textureStitch(class_1059 atlas, Consumer<class_2960> addSprite) {
        if (!atlas.method_24106().equals((Object)class_1723.field_21668)) {
            return;
        }
        try {
            for (Field field : Icons.class.getDeclaredFields()) {
                field.setAccessible(true);
                Object o = field.get(null);
                if (!(o instanceof AtlasSpriteIcon)) continue;
                AtlasSpriteIcon a = (AtlasSpriteIcon)o;
                addSprite.accept(a.id);
                IconPresets.MAP.put(a.id.toString(), a);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void guiInit(class_437 screen, ScreenAccess access) {
        if (FTBLibraryClient.areButtonsVisible(screen)) {
            SidebarGroupGuiButton group = new SidebarGroupGuiButton((class_465)screen);
            access.addRenderableWidget((class_339)group);
        }
    }

    private void clientTick(class_310 client) {
        CursorType t;
        CursorType cursorType = t = client.field_1755 instanceof IScreenWrapper ? ((IScreenWrapper)client.field_1755).getGui().getCursor() : null;
        if (this.lastCursorType != t) {
            this.lastCursorType = t;
            CursorType.set(t);
        }
        if (!ClientUtils.RUN_LATER.isEmpty()) {
            for (Runnable runnable : new ArrayList<Runnable>(ClientUtils.RUN_LATER)) {
                runnable.run();
            }
            ClientUtils.RUN_LATER.clear();
        }
    }

    public static boolean areButtonsVisible(@Nullable class_437 gui) {
        if (class_310.method_1551().field_1687 == null || class_310.method_1551().field_1724 == null) {
            return false;
        }
        if (showButtons == 0 || showButtons == 2 && !(gui instanceof class_485)) {
            return false;
        }
        if (showButtons == 3 && Platform.isModLoaded((String)"roughlyenoughitems") && ConfigObject.getInstance().isFavoritesEnabled()) {
            return false;
        }
        return gui instanceof class_465 && !SidebarButtonManager.INSTANCE.groups.isEmpty();
    }

    @Override
    public void testScreen() {
        ConfigGroup group = new ConfigGroup("test");
        group.add("image", new ImageConfig(), "", v -> {}, "");
        group.addItemStack("item", class_1799.field_8037, v -> {}, class_1799.field_8037, false, true);
        ConfigGroup grp1 = group.getGroup("group1");
        grp1.addInt("integer", 1, v -> {}, 0, 0, 10);
        grp1.addBool("bool", true, v -> {}, false);
        ConfigGroup grp2 = grp1.getGroup("subgroup1");
        grp2.addEnum("enum", class_2350.field_11036, v -> {}, NameMap.of(class_2350.field_11036, class_2350.values()).create());
        ArrayList<Integer> integers = new ArrayList<Integer>(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)));
        grp2.addList("list", integers, new IntConfig(0, 10), 1);
        new EditConfigScreen(group).openGuiLater();
    }
}

