/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.icon;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.util.UUIDTypeAdapter;
import dev.ftb.mods.ftblibrary.icon.ImageIcon;
import dev.ftb.mods.ftblibrary.math.PixelBuffer;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1044;
import net.minecraft.class_1046;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class URLImageIcon
extends ImageIcon {
    public final URI uri;
    private final String url;

    public URLImageIcon(class_2960 tex, URI _uri) {
        super(tex);
        this.uri = _uri;
        this.url = this.uri.toString();
    }

    public URLImageIcon(URI uri) {
        this(new class_2960("remote_image:" + UUIDTypeAdapter.fromUUID((UUID)UUID.nameUUIDFromBytes(uri.toString().getBytes(StandardCharsets.UTF_8)))), uri);
    }

    @Override
    public URLImageIcon copy() {
        URLImageIcon icon = new URLImageIcon(this.texture, this.uri);
        icon.minU = this.minU;
        icon.minV = this.minV;
        icon.maxU = this.maxU;
        icon.maxV = this.maxV;
        icon.tileSize = this.tileSize;
        return icon;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void bindTexture() {
        class_1060 manager = class_310.method_1551().method_1531();
        class_1044 img = manager.method_4619(this.texture);
        if (img == null) {
            if (this.uri.getScheme().equals("http") || this.uri.getScheme().equals("https")) {
                img = new class_1046(null, this.url, MISSING_IMAGE, false, null);
            } else {
                File file = null;
                if (this.uri.getScheme().equals("file")) {
                    try {
                        file = new File(this.uri.getPath());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (file == null) {
                    file = new File(this.uri);
                }
                img = new class_1046(file, this.url, MISSING_IMAGE, false, null);
            }
            manager.method_4616(this.texture, img);
        }
        RenderSystem.bindTexture((int)img.method_4624());
    }

    @Override
    public String toString() {
        return this.url;
    }

    @Override
    public PixelBuffer createPixelBuffer() {
        PixelBuffer pixelBuffer;
        block8: {
            InputStream stream = this.uri.toURL().openConnection(class_310.method_1551().method_1487()).getInputStream();
            try {
                pixelBuffer = PixelBuffer.from(ImageIO.read(stream));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    return null;
                }
            }
            stream.close();
        }
        return pixelBuffer;
    }
}

