/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.math;

import dev.ftb.mods.ftblibrary.math.XZ;
import java.util.Random;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class MathUtils {
    public static final Random RAND = new Random();
    public static final float[] NORMALS_X = new float[]{0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 1.0f};
    public static final float[] NORMALS_Y = new float[]{-1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    public static final float[] NORMALS_Z = new float[]{0.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f};
    public static final int[] ROTATION_X = new int[]{90, 270, 0, 0, 0, 0};
    public static final int[] ROTATION_Y = new int[]{0, 0, 180, 0, 90, 270};
    private static final int CACHED_SPIRAL_POINTS_SIZE = 81;
    private static XZ[] CACHED_SPIRAL_POINTS = null;

    public static double sq(double value) {
        return value * value;
    }

    public static double sqrt(double value) {
        return value == 0.0 || value == 1.0 ? value : Math.sqrt(value);
    }

    public static double sqrt2sq(double x, double y) {
        return MathUtils.sqrt(MathUtils.sq(x) + MathUtils.sq(y));
    }

    public static double sqrt3sq(double x, double y, double z) {
        return MathUtils.sqrt(MathUtils.sq(x) + MathUtils.sq(y) + MathUtils.sq(z));
    }

    public static double distSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        return x1 == x2 && y1 == y2 && z1 == z2 ? 0.0 : MathUtils.sq(x2 - x1) + MathUtils.sq(y2 - y1) + MathUtils.sq(z2 - z1);
    }

    public static double dist(double x1, double y1, double z1, double x2, double y2, double z2) {
        return MathUtils.sqrt(MathUtils.distSq(x1, y1, z1, x2, y2, z2));
    }

    public static double distSq(double x1, double y1, double x2, double y2) {
        return MathUtils.sq(x2 - x1) + MathUtils.sq(y2 - y1);
    }

    public static double dist(double x1, double y1, double x2, double y2) {
        return MathUtils.sqrt(MathUtils.distSq(x1, y1, x2, y2));
    }

    public static int chunk(int i) {
        return i >> 4;
    }

    public static int chunk(double d) {
        return MathUtils.chunk(class_3532.method_15357((double)d));
    }

    public static boolean canParseInt(@Nullable String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean canParseDouble(@Nullable String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static float lerp(float min, float max, float value) {
        return min + (max - min) * value;
    }

    public static double lerp(double min, double max, double value) {
        return min + (max - min) * value;
    }

    public static class_243 lerp(double x1, double y1, double z1, double x2, double y2, double z2, double value) {
        return new class_243(MathUtils.lerp(x1, x2, value), MathUtils.lerp(y1, y2, value), MathUtils.lerp(z1, z2, value));
    }

    public static class_243 lerp(class_243 v1, class_243 v2, double value) {
        return MathUtils.lerp(v1.field_1352, v1.field_1351, v1.field_1350, v2.field_1352, v2.field_1351, v2.field_1350, value);
    }

    public static double map(double min1, double max1, double min2, double max2, double value) {
        return MathUtils.lerp(min2, max2, (value - min1) / (max1 - min1));
    }

    public static double mod(double i, double n) {
        return (i %= n) < 0.0 ? i + n : i;
    }

    public static int mod(int i, int n) {
        return (i %= n) < 0 ? i + n : i;
    }

    public static XZ getSpiralPoint(int index) {
        if (index < 0) {
            index = 0;
        }
        if (index < 81) {
            if (CACHED_SPIRAL_POINTS == null) {
                CACHED_SPIRAL_POINTS = new XZ[81];
                for (int i = 0; i < 81; ++i) {
                    MathUtils.CACHED_SPIRAL_POINTS[i] = MathUtils.getSpiralPoint0(i);
                }
            }
            return CACHED_SPIRAL_POINTS[index];
        }
        return MathUtils.getSpiralPoint0(index);
    }

    public static XZ getSpiralPoint0(int index) {
        if (index <= 0) {
            return XZ.of(0, 0);
        }
        int x = 0;
        int z = 0;
        int dx = 0;
        int dz = 1;
        int segmentLength = 1;
        int segmentPassed = 0;
        for (int n = 0; n < index; ++n) {
            x += dx;
            z += dz;
            if (++segmentPassed != segmentLength) continue;
            segmentPassed = 0;
            int buffer = dz;
            dz = -dx;
            dx = buffer;
            if (dx != 0) continue;
            ++segmentLength;
        }
        return XZ.of(x, z);
    }
}

