/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.block.entity;

import dev.ftb.mods.ftblibrary.config.BooleanConfig;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ItemStackConfig;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.block.FTBQuestsBlocks;
import dev.ftb.mods.ftbquests.block.TaskScreenBlock;
import dev.ftb.mods.ftbquests.block.entity.FTBQuestsBlockEntities;
import dev.ftb.mods.ftbquests.block.entity.ITaskScreen;
import dev.ftb.mods.ftbquests.net.TaskScreenConfigResponse;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.util.ConfigQuestObject;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.class_156;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;

public class TaskScreenBlockEntity
extends class_2586
implements ITaskScreen {
    private long taskId = 0L;
    private Task task = null;
    private boolean indestructible = false;
    private boolean inputOnly = false;
    private boolean textShadow = false;
    private class_1799 inputModeIcon = class_1799.field_8037;
    private class_1799 skin = class_1799.field_8037;
    @Nonnull
    private UUID teamId = class_156.field_25140;
    public float[] fakeTextureUV = null;
    private TeamData cachedTeamData = null;

    public TaskScreenBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)FTBQuestsBlockEntities.CORE_TASK_SCREEN.get(), blockPos, blockState);
    }

    public Task getTask() {
        if (this.task == null && this.taskId != 0L || this.task != null && this.task.id != this.taskId) {
            this.task = FTBQuests.PROXY.getQuestFile(this.field_11863.field_9236).getTask(this.taskId);
        }
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
        this.taskId = task == null ? 0L : task.id;
        this.method_5431();
    }

    @Override
    public boolean isInputOnly() {
        return this.inputOnly;
    }

    public void setInputOnly(boolean inputOnly) {
        this.inputOnly = inputOnly;
        this.method_5431();
    }

    public class_1799 getInputModeIcon() {
        return this.inputModeIcon;
    }

    public void setInputModeIcon(class_1799 inputModeIcon) {
        this.inputModeIcon = inputModeIcon;
        this.method_5431();
    }

    @Override
    public boolean isIndestructible() {
        return this.indestructible;
    }

    public void setIndestructible(boolean indestructible) {
        this.indestructible = indestructible;
        this.method_5431();
    }

    @Override
    public class_1799 getSkin() {
        return this.skin;
    }

    public void setSkin(class_1799 skin) {
        this.skin = skin;
        this.fakeTextureUV = null;
    }

    public boolean isTextShadow() {
        return this.textShadow;
    }

    public void setTextShadow(boolean textShadow) {
        this.textShadow = textShadow;
    }

    public void setTeamId(@Nonnull UUID teamId) {
        this.teamId = teamId;
        this.cachedTeamData = null;
    }

    @Override
    @Nonnull
    public UUID getTeamId() {
        return this.teamId;
    }

    public TeamData getCachedTeamData() {
        if (this.cachedTeamData == null) {
            QuestFile f = FTBQuests.PROXY.getQuestFile(this.field_11863.field_9236);
            this.cachedTeamData = f.getNullableTeamData(this.getTeamId());
        }
        return this.cachedTeamData;
    }

    @Override
    public Optional<TaskScreenBlockEntity> getCoreScreen() {
        return Optional.of(this);
    }

    public void removeAllAuxScreens() {
        class_2248 class_22482;
        if (this.field_11863 != null && (class_22482 = this.method_11010().method_26204()) instanceof TaskScreenBlock) {
            TaskScreenBlock tsb = (TaskScreenBlock)class_22482;
            class_2338.method_29715((class_238)TaskScreenBlock.getMultiblockBounds(this.method_11016(), tsb.getSize(), (class_2350)this.method_11010().method_11654((class_2769)TaskScreenBlock.FACING))).forEach(pos -> {
                if (this.field_11863.method_8320(pos).method_26204() == FTBQuestsBlocks.AUX_SCREEN.get()) {
                    this.field_11863.method_8650(pos, false);
                }
            });
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public void method_11014(class_2487 compoundTag) {
        super.method_11014(compoundTag);
        this.teamId = compoundTag.method_25928("TeamID") ? compoundTag.method_25926("TeamID") : class_156.field_25140;
        this.taskId = compoundTag.method_10537("TaskID");
        this.skin = compoundTag.method_10545("Skin") ? class_1799.method_7915((class_2487)compoundTag.method_10562("Skin")) : class_1799.field_8037;
        this.indestructible = compoundTag.method_10577("Indestructible");
        this.inputOnly = compoundTag.method_10577("InputOnly");
        this.inputModeIcon = compoundTag.method_10545("InputModeIcon") ? class_1799.method_7915((class_2487)compoundTag.method_10562("InputModeIcon")) : class_1799.field_8037;
        this.textShadow = compoundTag.method_10577("TextShadow");
        this.task = null;
        this.fakeTextureUV = null;
    }

    protected void method_11007(class_2487 compoundTag) {
        super.method_11007(compoundTag);
        if (this.teamId != class_156.field_25140) {
            compoundTag.method_25927("TeamID", this.teamId);
        }
        if (this.taskId != 0L) {
            compoundTag.method_10544("TaskID", this.taskId);
        }
        if (!this.skin.method_7960()) {
            compoundTag.method_10566("Skin", (class_2520)this.skin.method_7953(new class_2487()));
        }
        if (this.indestructible) {
            compoundTag.method_10556("Indestructible", true);
        }
        if (this.inputOnly) {
            compoundTag.method_10556("InputOnly", true);
        }
        if (!this.inputModeIcon.method_7960()) {
            compoundTag.method_10566("InputModeIcon", (class_2520)this.inputModeIcon.method_7953(new class_2487()));
        }
        if (this.textShadow) {
            compoundTag.method_10556("TextShadow", true);
        }
    }

    public ConfigGroup getConfigGroup(TeamData data) {
        ConfigGroup cg0 = new ConfigGroup("task_screen");
        cg0.setNameKey(this.method_11010().method_26204().method_9539());
        ConfigGroup cg = cg0.getGroup("screen");
        ((ConfigQuestObject)cg.add("task", new ConfigQuestObject(o -> this.isSuitableTask(data, (QuestObjectBase)o)), (Object)this.getTask(), this::setTask, null)).setNameKey("ftbquests.task");
        ((ItemStackConfig)cg.add("skin", (ConfigValue)new ItemStackConfig(true, true), (Object)this.getSkin(), this::setSkin, (Object)class_1799.field_8037)).setNameKey("block.ftbquests.screen.skin");
        ((BooleanConfig)cg.add("text_shadow", (ConfigValue)new BooleanConfig(), (Object)this.isTextShadow(), this::setTextShadow, (Object)false)).setNameKey("block.ftbquests.screen.text_shadow");
        ((BooleanConfig)cg.add("indestructible", (ConfigValue)new BooleanConfig(), (Object)this.isIndestructible(), this::setIndestructible, (Object)false)).setNameKey("block.ftbquests.screen.indestructible");
        ((BooleanConfig)cg.add("input_only", (ConfigValue)new BooleanConfig(), (Object)this.isInputOnly(), this::setInputOnly, (Object)false)).setNameKey("block.ftbquests.screen.input_only");
        ((ItemStackConfig)cg.add("input_icon", (ConfigValue)new ItemStackConfig(true, true), (Object)this.getInputModeIcon(), this::setInputModeIcon, (Object)class_1799.field_8037)).setNameKey("block.ftbquests.screen.input_mode_icon");
        cg0.savedCallback = accepted -> {
            if (accepted) {
                new TaskScreenConfigResponse(this).sendToServer();
            }
        };
        return cg0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSuitableTask(TeamData data, QuestObjectBase o) {
        if (!(o instanceof Task)) return false;
        Task t = (Task)o;
        if (!data.getCanEdit(FTBQuests.PROXY.getClientPlayer())) {
            if (!data.canStartTasks(t.quest)) return false;
        }
        if (!t.consumesResources()) return false;
        return true;
    }

    public float[] getFakeTextureUV() {
        if (this.fakeTextureUV == null) {
            class_1792 class_17922;
            if (!this.skin.method_7960() && (class_17922 = this.skin.method_7909()) instanceof class_1747) {
                class_1747 bi = (class_1747)class_17922;
                class_2680 state = bi.method_7711().method_9564();
                class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)TaskScreenBlock.FACING);
                if (state.method_28498((class_2769)class_2741.field_12481)) {
                    state = (class_2680)state.method_11657((class_2769)class_2741.field_12481, (Comparable)facing);
                } else if (state.method_28498((class_2769)class_2741.field_12525)) {
                    state = (class_2680)state.method_11657((class_2769)class_2741.field_12525, (Comparable)facing);
                }
                this.fakeTextureUV = FTBQuests.PROXY.getTextureUV(state, facing);
            } else {
                this.fakeTextureUV = new float[0];
            }
        }
        return this.fakeTextureUV;
    }
}

