/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui;

import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.DoubleConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigFromStringScreen;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.VerticalSpaceWidget;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.ButtonListBaseScreen;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.gui.FTBQuestsTheme;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class EditRewardTableScreen
extends ButtonListBaseScreen {
    private final RewardTable originalTable;
    private final RewardTable rewardTable;
    private final Runnable callback;

    public EditRewardTableScreen(RewardTable r, Runnable c) {
        this.originalTable = r;
        this.rewardTable = new RewardTable(this.originalTable.file);
        class_2487 nbt = new class_2487();
        this.originalTable.writeData(nbt);
        this.rewardTable.readData(nbt);
        this.callback = c;
        this.setTitle((class_2561)class_2561.method_43471((String)"ftbquests.reward_table").method_27693(": " + this.rewardTable.title));
        this.setBorder(1, 1, 1);
    }

    public void addButtons(Panel panel) {
        panel.add((Widget)new RewardTableSettingsButton(panel));
        panel.add((Widget)new SaveRewardTableButton(panel));
        panel.add((Widget)new AddWeightedRewardButton(panel));
        panel.add((Widget)new VerticalSpaceWidget(panel, 1));
        for (WeightedReward r : this.rewardTable.rewards) {
            panel.add((Widget)new WeightedRewardButton(panel, r));
        }
    }

    public void alignWidgets() {
        this.width = 186;
        super.alignWidgets();
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    public boolean keyPressed(Key key) {
        if (key.esc()) {
            this.onBack();
            return true;
        }
        return super.keyPressed(key);
    }

    private class RewardTableSettingsButton
    extends SimpleTextButton {
        private RewardTableSettingsButton(Panel panel) {
            super(panel, (class_2561)class_2561.method_43471((String)"gui.settings"), Icons.SETTINGS);
            this.setHeight(12);
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            ConfigGroup group = new ConfigGroup("ftbquests");
            EditRewardTableScreen.this.rewardTable.getConfig(EditRewardTableScreen.this.rewardTable.createSubGroup(group));
            group.savedCallback = accepted -> this.run();
            new EditConfigScreen(group).openGui();
        }
    }

    private class SaveRewardTableButton
    extends SimpleTextButton {
        private SaveRewardTableButton(Panel panel) {
            super(panel, (class_2561)class_2561.method_43471((String)"gui.accept"), Icons.ACCEPT);
            this.setHeight(12);
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            this.closeGui();
            class_2487 nbt = new class_2487();
            EditRewardTableScreen.this.rewardTable.writeData(nbt);
            EditRewardTableScreen.this.originalTable.readData(nbt);
            EditRewardTableScreen.this.callback.run();
        }
    }

    private class AddWeightedRewardButton
    extends SimpleTextButton {
        private AddWeightedRewardButton(Panel panel) {
            super(panel, (class_2561)class_2561.method_43471((String)"gui.add"), Icons.ADD);
            this.setHeight(12);
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            for (RewardType type : RewardTypes.TYPES.values()) {
                if (type.getExcludeFromListRewards()) continue;
                contextMenu.add(new ContextMenuItem(type.getDisplayName(), type.getIcon(), () -> {
                    this.playClickSound();
                    type.getGuiProvider().openCreationGui((Runnable)((Object)this), EditRewardTableScreen.this.rewardTable.fakeQuest, reward -> {
                        EditRewardTableScreen.this.rewardTable.rewards.add(new WeightedReward((Reward)reward, 1.0f));
                        this.openGui();
                    });
                }));
            }
            this.getGui().openContextMenu(contextMenu);
        }
    }

    private class WeightedRewardButton
    extends SimpleTextButton {
        private final WeightedReward reward;

        private WeightedRewardButton(Panel panel, WeightedReward r) {
            super(panel, r.reward.getTitle(), r.reward.getIcon());
            this.reward = r;
        }

        public void addMouseOverText(TooltipList list) {
            super.addMouseOverText(list);
            this.reward.reward.addMouseOverText(list);
            String w = String.format("%.2f", Float.valueOf(this.reward.weight));
            list.add((class_2561)class_2561.method_43471((String)"ftbquests.reward_table.weight").method_27693(": " + w).method_10852((class_2561)class_2561.method_43470((String)(" [" + WeightedReward.chanceString(this.reward.weight, EditRewardTableScreen.this.rewardTable.getTotalWeight(true)) + "]")).method_27692(class_124.field_1063)));
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"selectServer.edit"), Icons.SETTINGS, () -> {
                ConfigGroup group = new ConfigGroup("ftbquests");
                this.reward.reward.getConfig(this.reward.reward.createSubGroup(group));
                group.savedCallback = accepted -> this.run();
                new EditConfigScreen(group).openGui();
            }));
            contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.reward_table.set_weight"), Icons.SETTINGS, () -> {
                DoubleConfig c = new DoubleConfig(0.0, Double.POSITIVE_INFINITY);
                EditConfigFromStringScreen.open((ConfigFromString)c, (Object)this.reward.weight, (Object)1.0, accepted -> {
                    if (accepted) {
                        this.reward.weight = ((Double)c.value).floatValue();
                    }
                    this.run();
                });
            }));
            contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"selectServer.delete"), Icons.REMOVE, () -> {
                EditRewardTableScreen.this.rewardTable.rewards.remove(this.reward);
                EditRewardTableScreen.this.refreshWidgets();
            }).setYesNo((class_2561)class_2561.method_43469((String)"delete_item", (Object[])new Object[]{this.reward.reward.getTitle()})));
            EditRewardTableScreen.this.openContextMenu(contextMenu);
        }

        @Nullable
        public Object getIngredientUnderMouse() {
            return this.reward.reward.getIngredient();
        }
    }
}

