/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui;

import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.ButtonListBaseScreen;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.gui.FTBQuestsTheme;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestLink;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.util.ConfigQuestObject;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class SelectQuestObjectScreen<T extends QuestObjectBase>
extends ButtonListBaseScreen {
    private final ConfigQuestObject<T> config;
    private final ConfigCallback callback;

    public SelectQuestObjectScreen(ConfigQuestObject<T> c, ConfigCallback cb) {
        this.setTitle((class_2561)class_2561.method_43471((String)"ftbquests.gui.select_quest_object"));
        this.setHasSearchBox(true);
        this.focus();
        this.setBorder(1, 1, 1);
        this.config = c;
        this.callback = cb;
    }

    public boolean keyPressed(Key key) {
        if (key.esc()) {
            this.onBack();
            return true;
        }
        return super.keyPressed(key);
    }

    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.callback.save(false);
            return false;
        }
        return false;
    }

    public void addButtons(Panel panel) {
        ArrayList<QuestObjectBase> list = new ArrayList<QuestObjectBase>();
        ClientQuestFile file = ClientQuestFile.INSTANCE;
        for (QuestObjectBase objectBase : file.getAllObjects()) {
            QuestObject qo;
            if (!this.config.predicate.test(objectBase) || !file.canEdit() && objectBase instanceof QuestObject && !(qo = (QuestObject)objectBase).isVisible(file.self)) continue;
            list.add(objectBase);
        }
        list.sort((o1, o2) -> {
            int i = Integer.compare(o1.getObjectType().ordinal(), o2.getObjectType().ordinal());
            return i == 0 ? o1.getTitle().getString().compareToIgnoreCase(o2.getTitle().getString()) : i;
        });
        if (this.config.predicate.test(null)) {
            panel.add((Widget)new QuestObjectButton(this, panel, null));
        }
        for (QuestObjectBase objectBase : list) {
            panel.add((Widget)new QuestObjectButton(this, panel, objectBase));
        }
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    private static class QuestObjectButton
    extends SimpleTextButton {
        public final T object;
        final /* synthetic */ SelectQuestObjectScreen this$0;

        public QuestObjectButton(@Nullable Panel panel, T o) {
            this.this$0 = var1_1;
            super(panel, (class_2561)(o == null ? class_2561.method_43471((String)"ftbquests.null") : ((QuestObjectBase)o).getMutableTitle().method_27692(((QuestObjectBase)o).getObjectType().getColor())), (Icon)(o == null ? Color4I.EMPTY : ((QuestObjectBase)o).getIcon()));
            this.object = o;
            this.setSize(200, 14);
        }

        private void addObject(TooltipList list, QuestObjectBase o) {
            list.add((class_2561)QuestObjectType.NAME_MAP.getDisplayName((Object)o.getObjectType()).method_27661().method_27692(class_124.field_1080).method_27693(": ").method_10852((class_2561)o.getMutableTitle().method_27692(o.getObjectType().getColor())));
        }

        public void addMouseOverText(TooltipList list) {
            if (this.object == null) {
                return;
            }
            list.add(((QuestObjectBase)this.object).getTitle());
            list.add((class_2561)class_2561.method_43470((String)"ID: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)((QuestObjectBase)this.object).toString()).method_27692(class_124.field_1063)));
            list.add((class_2561)class_2561.method_43470((String)"Type: ").method_27692(class_124.field_1080).method_10852((class_2561)QuestObjectType.NAME_MAP.getDisplayName((Object)((QuestObjectBase)this.object).getObjectType()).method_27661().method_27692(((QuestObjectBase)this.object).getObjectType().getColor())));
            Object object = this.object;
            if (object instanceof Quest) {
                Quest quest2 = (Quest)object;
                this.addObject(list, quest2.chapter);
                if (quest2.rewards.size() == 1) {
                    this.addObject(list, quest2.rewards.get(0));
                } else if (!quest2.rewards.isEmpty()) {
                    list.add((class_2561)class_2561.method_43471((String)"ftbquests.rewards").method_27692(class_124.field_1080));
                    for (Reward reward : quest2.rewards) {
                        list.add((class_2561)class_2561.method_43470((String)"  ").method_10852((class_2561)reward.getMutableTitle().method_27692(QuestObjectType.REWARD.getColor())));
                    }
                }
            } else {
                object = this.object;
                if (object instanceof QuestLink) {
                    QuestLink link = (QuestLink)object;
                    link.getQuest().ifPresent(quest -> {
                        this.addObject(list, link.getChapter());
                        list.add((class_2561)class_2561.method_43469((String)"ftbquests.gui.linked_quest_id", (Object[])new Object[]{class_2561.method_43470((String)quest.getCodeString()).method_27692(class_124.field_1063)}).method_27692(class_124.field_1080));
                        this.addObject(list, quest.chapter);
                    });
                } else {
                    object = this.object;
                    if (object instanceof Task) {
                        Task task = (Task)object;
                        quest = task.quest;
                        this.addObject(list, ((Quest)quest).chapter);
                        this.addObject(list, (QuestObjectBase)quest);
                        if (((Quest)quest).rewards.size() == 1) {
                            this.addObject(list, ((Quest)quest).rewards.get(0));
                        } else if (!((Quest)quest).rewards.isEmpty()) {
                            list.add((class_2561)class_2561.method_43471((String)"ftbquests.rewards").method_27692(class_124.field_1080));
                            for (Reward reward : ((Quest)quest).rewards) {
                                list.add((class_2561)class_2561.method_43470((String)"  ").method_10852((class_2561)reward.getMutableTitle().method_27692(QuestObjectType.REWARD.getColor())));
                            }
                        }
                    } else {
                        quest = this.object;
                        if (quest instanceof Reward) {
                            Reward reward = (Reward)quest;
                            quest = reward.quest;
                            this.addObject(list, ((Quest)quest).chapter);
                            this.addObject(list, (QuestObjectBase)quest);
                        } else {
                            object = this.object;
                            if (object instanceof RewardTable) {
                                RewardTable rewardTable = (RewardTable)object;
                                rewardTable.addMouseOverText(list, true, true);
                            }
                        }
                    }
                }
            }
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            this.this$0.config.setCurrentValue(this.object);
            this.this$0.callback.save(true);
        }
    }
}

