/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui.quests;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.gui.quests.QuestPositionableButton;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.ChapterImage;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import dev.ftb.mods.ftbquests.util.TextUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1160;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_4587;

public class ChapterImageButton
extends Button
implements QuestPositionableButton {
    private static WeakReference<ChapterImage> clipboard = new WeakReference<Object>(null);
    public QuestScreen questScreen;
    public ChapterImage chapterImage;

    public static Optional<ChapterImage> getClipboard() {
        ChapterImage img = (ChapterImage)clipboard.get();
        if (img != null) {
            if (!img.chapter.invalid) {
                return Optional.of(img);
            }
            clipboard = new WeakReference<Object>(null);
        }
        return Optional.empty();
    }

    public ChapterImageButton(Panel panel, ChapterImage i) {
        super(panel, (class_2561)class_2561.method_43473(), i.getImage());
        this.questScreen = (QuestScreen)panel.getGui();
        this.setSize(20, 20);
        this.chapterImage = i;
    }

    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver() && (!this.chapterImage.click.isEmpty() || this.questScreen.file.canEdit() && !button.isLeft())) {
            this.onClicked(button);
            return true;
        }
        return false;
    }

    public boolean checkMouseOver(int mouseX, int mouseY) {
        if (this.questScreen.questPanel.mouseOverQuest != null || this.questScreen.movingObjects || this.questScreen.viewQuestPanel.isMouseOver() || this.questScreen.chapterPanel.isMouseOver()) {
            return false;
        }
        if (this.chapterImage.click.isEmpty() && !this.questScreen.file.canEdit()) {
            return false;
        }
        return super.checkMouseOver(mouseX, mouseY);
    }

    public void onClicked(MouseButton button) {
        if (this.questScreen.file.canEdit() && button.isRight()) {
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"selectServer.edit"), (Icon)ThemeProperties.EDIT_ICON.get(), () -> {
                String name = this.chapterImage.getImage() instanceof Color4I ? this.chapterImage.getColor().toString() : this.chapterImage.getImage().toString();
                ConfigGroup group = new ConfigGroup("ftbquests").setNameKey("Img: " + name);
                this.chapterImage.getConfig(group.getGroup("chapter").getGroup("image"));
                group.savedCallback = accepted -> {
                    if (accepted) {
                        new EditObjectMessage(this.chapterImage.chapter).sendToServer();
                    }
                    this.run();
                };
                new EditConfigScreen(group).openGui();
            }));
            contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"gui.move"), (Icon)ThemeProperties.MOVE_UP_ICON.get(this.chapterImage.chapter), () -> {
                this.questScreen.movingObjects = true;
                this.questScreen.selectedObjects.clear();
                this.questScreen.toggleSelected(this.chapterImage);
            }){

                public void addMouseOverText(TooltipList list) {
                    list.add((class_2561)class_2561.method_43471((String)"ftbquests.gui.move_tooltip").method_27692(class_124.field_1063));
                }
            });
            contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"gui.copy"), Icons.INFO, () -> {
                clipboard = new WeakReference<ChapterImage>(this.chapterImage);
            }){

                public void addMouseOverText(TooltipList list) {
                    list.add((class_2561)class_2561.method_43470((String)ChapterImageButton.this.chapterImage.getImage().toString()).method_27692(class_124.field_1063));
                }
            });
            if (this.chapterImage.isAspectRatioOff()) {
                contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.gui.fix_aspect_ratio_w"), Icons.ART, () -> this.chapterImage.fixupAspectRatio(true)));
                contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.gui.fix_aspect_ratio_h"), Icons.ART, () -> this.chapterImage.fixupAspectRatio(false)));
            }
            contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"selectServer.delete"), (Icon)ThemeProperties.DELETE_ICON.get(), () -> {
                this.chapterImage.chapter.images.remove(this.chapterImage);
                new EditObjectMessage(this.chapterImage.chapter).sendToServer();
            }).setYesNo((class_2561)class_2561.method_43469((String)"delete_item", (Object[])new Object[]{this.chapterImage.getImage().toString()})));
            this.getGui().openContextMenu(contextMenu);
        } else if (button.isLeft()) {
            if (!this.chapterImage.click.isEmpty()) {
                this.playClickSound();
                this.handleClick(this.chapterImage.click);
            }
        } else if (this.questScreen.file.canEdit() && button.isMiddle()) {
            if (!this.questScreen.selectedObjects.contains(this.chapterImage)) {
                this.questScreen.toggleSelected(this.chapterImage);
            }
            this.questScreen.movingObjects = true;
        }
    }

    public void addMouseOverText(TooltipList list) {
        for (String s : this.chapterImage.hover) {
            list.add(TextUtils.parseRawText(s));
        }
    }

    public boolean shouldDraw() {
        return false;
    }

    public void draw(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        boolean transparent;
        Icon image = this.chapterImage.getImage();
        boolean bl = transparent = this.chapterImage.dependency != null && !this.questScreen.file.self.isCompleted(this.chapterImage.dependency);
        if (transparent) {
            image = image.withColor(Color4I.WHITE.withAlpha(100));
        } else if (!this.chapterImage.getColor().equals((Object)Color4I.WHITE) || this.chapterImage.getAlpha() < 255) {
            image = image.withColor(this.chapterImage.getColor().withAlpha(this.chapterImage.getAlpha()));
        }
        GuiHelper.setupDrawing();
        matrixStack.method_22903();
        if (this.chapterImage.corner) {
            matrixStack.method_22904((double)x, (double)y, 0.0);
            matrixStack.method_22907(class_1160.field_20707.method_23214((float)this.chapterImage.rotation));
            matrixStack.method_22905((float)w, (float)h, 1.0f);
            image.draw(matrixStack, 0, 0, 1, 1);
        } else {
            matrixStack.method_22904((double)((int)((double)x + (double)w / 2.0)), (double)((int)((double)y + (double)h / 2.0)), 0.0);
            matrixStack.method_22907(class_1160.field_20707.method_23214((float)this.chapterImage.rotation));
            matrixStack.method_22905((float)w / 2.0f, (float)h / 2.0f, 1.0f);
            image.draw(matrixStack, -1, -1, 2, 2);
        }
        matrixStack.method_22909();
    }

    @Override
    public QuestPositionableButton.Position getPosition() {
        return new QuestPositionableButton.Position(this.chapterImage.x, this.chapterImage.y, this.chapterImage.width, this.chapterImage.height);
    }
}

