/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbquests.util.ConfigQuestObject;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class RandomReward
extends Reward {
    public RewardTable table = null;

    public RandomReward(Quest parent) {
        super(parent);
    }

    @Override
    public RewardType getType() {
        return RewardTypes.RANDOM;
    }

    @Override
    public void writeData(class_2487 nbt) {
        super.writeData(nbt);
        if (this.getTable() != null) {
            nbt.method_10544("table_id", this.table.id);
            if (this.table.id == -1L) {
                SNBTCompoundTag tag = new SNBTCompoundTag();
                this.table.writeData((class_2487)tag);
                nbt.method_10566("table_data", (class_2520)tag);
            }
        }
    }

    @Override
    public void readData(class_2487 nbt) {
        super.readData(nbt);
        this.table = null;
        QuestFile file = this.getQuestFile();
        long id = nbt.method_10537("table_id");
        if (id != 0L) {
            this.table = file.getRewardTable(id);
        } else {
            int index;
            int n = index = nbt.method_10545("table") ? nbt.method_10550("table") : -1;
            if (index >= 0 && index < file.rewardTables.size()) {
                this.table = file.rewardTables.get(index);
            }
        }
        if (this.table == null && nbt.method_10545("table_data")) {
            this.table = new RewardTable(file);
            this.table.readData(nbt.method_10562("table_data"));
            this.table.id = -1L;
            this.table.title = "Internal";
        }
    }

    @Nullable
    public RewardTable getTable() {
        if (this.table != null && this.table.invalid) {
            this.table = null;
        }
        return this.table;
    }

    @Override
    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        RewardTable table = this.getTable();
        buffer.writeLong(table == null ? 0L : table.id);
        if (table != null && table.id == -1L) {
            table.writeNetData(buffer);
        }
    }

    @Override
    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        QuestFile file = this.getQuestFile();
        long t = buffer.readLong();
        if (t == -1L) {
            this.table = new RewardTable(file);
            this.table.readNetData(buffer);
            this.table.id = -1L;
            this.table.title = "Internal";
        } else {
            this.table = file.getRewardTable(t);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        ((ConfigQuestObject)config.add("table", new ConfigQuestObject(QuestObjectType.REWARD_TABLE), (Object)this.table, v -> {
            this.table = v;
        }, (Object)this.getTable())).setNameKey("ftbquests.reward_table");
    }

    @Override
    public void claim(class_3222 player, boolean notify) {
        RewardTable table = this.getTable();
        if (table != null) {
            for (WeightedReward reward : table.generateWeightedRandomRewards(player.method_6051(), 1, false)) {
                reward.reward.claim(player, notify);
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_2561 getAltTitle() {
        return this.getTable() == null ? super.getAltTitle() : (this.getTable().useTitle ? this.getTable().getTitle() : super.getAltTitle());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public Icon getAltIcon() {
        return this.getTable() == null ? super.getAltIcon() : this.getTable().getIcon();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addMouseOverText(TooltipList list) {
        if (this.getTable() != null) {
            this.getTable().addMouseOverText(list, true, false);
        }
    }

    @Override
    public boolean getExcludeFromClaimAll() {
        return false;
    }

    @Override
    public boolean isClaimAllHardcoded() {
        return true;
    }

    @Override
    @Nullable
    @Environment(value=EnvType.CLIENT)
    public Object getIngredient() {
        return this.getTable() != null && this.getTable().lootCrate != null ? this.getTable().lootCrate.createStack() : null;
    }

    @Override
    public boolean automatedClaimPre(class_2586 blockEntity, List<class_1799> items, class_5819 random, UUID playerId, @Nullable class_3222 player) {
        return false;
    }

    @Override
    public void automatedClaimPost(class_2586 blockEntity, UUID playerId, @Nullable class_3222 player) {
    }
}

