/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.BooleanTask;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5321;

public class LocationTask
extends BooleanTask {
    public class_5321<class_1937> dimension = class_1937.field_25179;
    public boolean ignoreDimension = false;
    public int x = 0;
    public int y = 0;
    public int z = 0;
    public int w = 1;
    public int h = 1;
    public int d = 1;

    public LocationTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.LOCATION;
    }

    @Override
    public void writeData(class_2487 nbt) {
        super.writeData(nbt);
        nbt.method_10582("dimension", this.dimension.method_29177().toString());
        nbt.method_10556("ignore_dimension", this.ignoreDimension);
        nbt.method_10539("position", new int[]{this.x, this.y, this.z});
        nbt.method_10539("size", new int[]{this.w, this.h, this.d});
    }

    @Override
    public void readData(class_2487 nbt) {
        super.readData(nbt);
        this.dimension = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960(nbt.method_10558("dimension")));
        this.ignoreDimension = nbt.method_10577("ignore_dimension");
        int[] pos = nbt.method_10561("position");
        if (pos.length == 3) {
            this.x = pos[0];
            this.y = pos[1];
            this.z = pos[2];
        }
        int[] size = nbt.method_10561("size");
        if (pos.length == 3) {
            this.w = size[0];
            this.h = size[1];
            this.d = size[2];
        }
    }

    @Override
    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        buffer.method_10812(this.dimension.method_29177());
        buffer.writeBoolean(this.ignoreDimension);
        buffer.method_10804(this.x);
        buffer.method_10804(this.y);
        buffer.method_10804(this.z);
        buffer.method_10804(this.w);
        buffer.method_10804(this.h);
        buffer.method_10804(this.d);
    }

    @Override
    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        this.dimension = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)buffer.method_10810());
        this.ignoreDimension = buffer.readBoolean();
        this.x = buffer.method_10816();
        this.y = buffer.method_10816();
        this.z = buffer.method_10816();
        this.w = buffer.method_10816();
        this.h = buffer.method_10816();
        this.d = buffer.method_10816();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("dim", this.dimension.method_29177().toString(), v -> {
            this.dimension = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960(v));
        }, "minecraft:overworld");
        config.addBool("ignore_dim", this.ignoreDimension, v -> {
            this.ignoreDimension = v;
        }, false);
        config.addInt("x", this.x, v -> {
            this.x = v;
        }, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        config.addInt("y", this.y, v -> {
            this.y = v;
        }, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        config.addInt("z", this.z, v -> {
            this.z = v;
        }, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        config.addInt("w", this.w, v -> {
            this.w = v;
        }, 1, 1, Integer.MAX_VALUE);
        config.addInt("h", this.h, v -> {
            this.h = v;
        }, 1, 1, Integer.MAX_VALUE);
        config.addInt("d", this.d, v -> {
            this.d = v;
        }, 1, 1, Integer.MAX_VALUE);
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return 3;
    }

    @Override
    public boolean canSubmit(TeamData teamData, class_3222 player) {
        int px;
        int py;
        if ((this.ignoreDimension || this.dimension == player.field_6002.method_27983()) && (py = class_3532.method_15357((double)player.method_23318())) >= this.y && py < this.y + this.h && (px = class_3532.method_15357((double)player.method_23317())) >= this.x && px < this.x + this.w) {
            int pz = class_3532.method_15357((double)player.method_23321());
            return pz >= this.z && pz < this.z + this.d;
        }
        return false;
    }
}

