/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelio.loader;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.creeperhost.levelio.Utils;
import net.creeperhost.levelio.data.Player;
import net.creeperhost.levelio.lib.nbt.ICompoundTag;
import net.creeperhost.levelio.lib.nbt.NBTHandler;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlayerLoader.class);
    private final NBTHandler nbtHandler;
    private Map<UUID, Player> players = new HashMap<UUID, Player>();

    public PlayerLoader(ICompoundTag levelData, Path worldFolder, NBTHandler nbtHandler) {
        Path playerdata;
        Path players;
        Player player;
        this.nbtHandler = nbtHandler;
        if (levelData != null && levelData.contains("Player") && (player = PlayerLoader.fromPlayerTag(levelData.getCompound("Player"), null)) != null) {
            this.players.put(player.uuid, player);
        }
        if (Files.isDirectory(players = worldFolder.resolve("players"), new LinkOption[0])) {
            this.loadPlayersFromFolder(players, true);
        }
        if (Files.isDirectory(playerdata = worldFolder.resolve("playerdata"), new LinkOption[0])) {
            this.loadPlayersFromFolder(playerdata, false);
        }
    }

    private void loadPlayersFromFolder(Path path, boolean legacy) {
        List<Path> files = Utils.getFilesInFolder(path, e -> e.getFileName().toString().endsWith(".dat"));
        for (Path file : files) {
            String name = file.getFileName().toString().replace(".dat", "");
            if (!legacy) {
                if (name.length() != 36) continue;
                try {
                    UUID.fromString(name);
                }
                catch (Throwable ignored) {
                    continue;
                }
            }
            try {
                ICompoundTag tag = this.nbtHandler.read(file);
                Player player = PlayerLoader.fromPlayerTag(tag, legacy ? name : null);
                if (player == null) continue;
                this.players.put(player.uuid, player);
            }
            catch (Throwable e2) {
                LOGGER.error("An error occurred while trying to read player dat file {}", (Object)file.toAbsolutePath(), (Object)e2);
            }
        }
    }

    @Nullable
    public static Player fromPlayerTag(ICompoundTag tag, @Nullable String playerName) {
        UUID uuid = Utils.getUUID(tag, "UUID");
        if (uuid == null) {
            LOGGER.warn("Player data does not contain a UUID, How old is this world???");
            if (playerName == null) {
                LOGGER.warn("Player name not available for fallback.");
                return null;
            }
            LOGGER.warn("Using offline UUID for player {}", (Object)playerName);
            uuid = UUID.nameUUIDFromBytes(("OfflinePlayer:" + playerName).getBytes(StandardCharsets.UTF_8));
        }
        return new Player(uuid, tag);
    }

    public Map<UUID, Player> getPlayers() {
        return this.players;
    }
}

