/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.geocluster.api.deposits;

import dev.sterner.geocluster.api.DepositUtils;
import dev.sterner.geocluster.common.blocks.SampleBlock;
import dev.sterner.geocluster.common.components.IWorldChunkComponent;
import dev.sterner.geocluster.common.components.IWorldDepositComponent;
import dev.sterner.geocluster.common.utils.FeatureUtils;
import dev.sterner.geocluster.common.utils.SampleUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_5281;

public abstract class Deposit {
    public static void validateFormat(HashMap<String, HashMap<class_2680, Float>> oreToWeightMap, HashMap<String, Float> cumulativeOreWeightMap, HashMap<class_2680, Float> sampleToWeightMap, float sumWeightSamples) {
        if (!oreToWeightMap.containsKey("default")) {
            throw new RuntimeException("Cluster blocks should always have a default key");
        }
        for (Map.Entry<String, HashMap<class_2680, Float>> entry : oreToWeightMap.entrySet()) {
            if (!cumulativeOreWeightMap.containsKey(entry.getKey())) {
                cumulativeOreWeightMap.put(entry.getKey(), Float.valueOf(0.0f));
            }
            for (Map.Entry<class_2680, Float> j : entry.getValue().entrySet()) {
                float v = cumulativeOreWeightMap.get(entry.getKey()).floatValue();
                cumulativeOreWeightMap.put(entry.getKey(), Float.valueOf(v + j.getValue().floatValue()));
            }
            if (DepositUtils.nearlyEquals(cumulativeOreWeightMap.get(entry.getKey()).floatValue(), 1.0f)) continue;
            throw new RuntimeException("Sum of weights for cluster blocks should equal 1.0, is " + cumulativeOreWeightMap.get(entry.getKey()));
        }
        for (Map.Entry<String, Serializable> entry : sampleToWeightMap.entrySet()) {
            sumWeightSamples += ((Float)entry.getValue()).floatValue();
        }
        if (!DepositUtils.nearlyEquals(sumWeightSamples, 1.0f)) {
            throw new RuntimeException("Sum of weights for cluster samples should equal 1.0, is " + sumWeightSamples);
        }
    }

    public static void findAndPlaceSample(int maxSampleCnt, class_2680 sampleState, class_5281 world, class_2338 pos, IWorldDepositComponent deposits, IWorldChunkComponent chunksGenerated) {
        for (int i = 0; i < maxSampleCnt; ++i) {
            class_2338 samplePos;
            class_2680 tmp = sampleState;
            if (tmp == null || (samplePos = SampleUtils.getSamplePosition(world, new class_1923(pos), pos)) == null || SampleUtils.inNonWaterFluid(world, samplePos)) continue;
            if (SampleUtils.isInWater(world, samplePos) && tmp.method_28498((class_2769)class_2741.field_12508)) {
                tmp = (class_2680)tmp.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.TRUE);
            }
            if (tmp.method_28498((class_2769)SampleBlock.FACING)) {
                tmp = (class_2680)tmp.method_11657((class_2769)SampleBlock.FACING, (Comparable)class_2350.method_10139((int)world.method_8409().method_39332(0, 3)));
            }
            FeatureUtils.enqueueBlockPlacement(world, samplePos, tmp, deposits, chunksGenerated);
            FeatureUtils.fixSnowyBlock(world, samplePos);
        }
    }
}

