/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.geocluster.api.deposits;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.sterner.geocluster.Geocluster;
import dev.sterner.geocluster.GeoclusterConfig;
import dev.sterner.geocluster.api.DepositUtils;
import dev.sterner.geocluster.api.IDeposit;
import dev.sterner.geocluster.api.deposits.Deposit;
import dev.sterner.geocluster.common.components.IWorldChunkComponent;
import dev.sterner.geocluster.common.components.IWorldDepositComponent;
import dev.sterner.geocluster.common.utils.FeatureUtils;
import dev.sterner.geocluster.common.utils.GeoclusterUtils;
import dev.sterner.geocluster.common.utils.SerializerUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class SparseDeposit
extends Deposit
implements IDeposit {
    public static final String JSON_TYPE = "geocluster:deposit_sparse";
    public final HashMap<String, HashMap<class_2680, Float>> oreToWeightMap;
    public final HashMap<class_2680, Float> sampleToWeightMap;
    public final HashMap<String, Float> cumulativeOreWeightMap = new HashMap();
    public float sumWeightSamples = 0.0f;
    private final int yMin;
    private final int yMax;
    private final int size;
    private final int spread;
    private final int weight;
    private final HashSet<class_2680> blockStateMatchers;
    private final class_6862<class_1959> biomeTag;

    public SparseDeposit(HashMap<String, HashMap<class_2680, Float>> oreBlocks, HashMap<class_2680, Float> sampleBlocks, int yMin, int yMax, int size, int spread, int weight, class_6862<class_1959> biomeTag, HashSet<class_2680> blockStateMatchers) {
        this.oreToWeightMap = oreBlocks;
        this.sampleToWeightMap = sampleBlocks;
        this.yMin = yMin;
        this.yMax = yMax;
        this.size = size;
        this.spread = spread;
        this.weight = weight;
        this.biomeTag = biomeTag;
        this.blockStateMatchers = blockStateMatchers;
        SparseDeposit.validateFormat(this.oreToWeightMap, this.cumulativeOreWeightMap, this.sampleToWeightMap, this.sumWeightSamples);
    }

    @Nullable
    public class_2680 getOre(class_2680 currentState, class_5819 rand) {
        String res = GeoclusterUtils.getRegistryName(currentState);
        if (this.oreToWeightMap.containsKey(res)) {
            HashMap<class_2680, Float> mp = this.oreToWeightMap.get(res);
            return DepositUtils.pick(mp, rand);
        }
        return DepositUtils.pick(this.oreToWeightMap.get("default"), rand);
    }

    @Nullable
    public class_2680 getSample(class_5819 rand) {
        return DepositUtils.pick(this.sampleToWeightMap, rand);
    }

    @Override
    @Nullable
    public HashSet<class_2680> getAllOres() {
        HashSet<class_2680> ret = new HashSet<class_2680>();
        this.oreToWeightMap.values().forEach(x -> ret.addAll(x.keySet()));
        ret.remove(class_2246.field_10124.method_9564());
        return ret.isEmpty() ? null : ret;
    }

    @Override
    public boolean canPlaceInBiome(class_6880<class_1959> b) {
        return b.method_40220(this.biomeTag);
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    public String toString() {
        return "Sparse deposit with Blocks=" + this.getAllOres() + ", Samples=" + Arrays.toString(this.sampleToWeightMap.keySet().toArray()) + ", Y Range=[" + this.yMin + "," + this.yMax + "], Size of deposit =" + this.size + ", Spread=" + this.spread;
    }

    @Override
    public int generate(class_5281 world, class_2338 pos, IWorldDepositComponent deposits, IWorldChunkComponent chunksGenerated) {
        int max;
        if (!this.canPlaceInBiome((class_6880<class_1959>)world.method_23753(pos))) {
            return 0;
        }
        int totlPlaced = 0;
        int totlPnding = 0;
        int randY = this.yMin + world.method_8409().method_43048(this.yMax - this.yMin);
        if (randY > (max = GeoclusterUtils.getTopSolidBlock((class_4538)world, pos).method_10264())) {
            randY = Math.max(this.yMin, max);
        }
        float ranFlt = world.method_8409().method_43057() * (float)Math.PI;
        double x1 = (float)(pos.method_10263() + 8) + class_3532.method_15374((float)ranFlt) * (float)this.size / 8.0f;
        double x2 = (float)(pos.method_10263() + 8) - class_3532.method_15374((float)ranFlt) * (float)this.size / 8.0f;
        double z1 = (float)(pos.method_10260() + 8) + class_3532.method_15362((float)ranFlt) * (float)this.size / 8.0f;
        double z2 = (float)(pos.method_10260() + 8) - class_3532.method_15362((float)ranFlt) * (float)this.size / 8.0f;
        double y1 = randY + world.method_8409().method_43048(3) - 2;
        double y2 = randY + world.method_8409().method_43048(3) - 2;
        for (int i = 0; i < this.size; ++i) {
            float radScl = (float)i / (float)this.size;
            double xn = x1 + (x2 - x1) * (double)radScl;
            double yn = y1 + (y2 - y1) * (double)radScl;
            double zn = z1 + (z2 - z1) * (double)radScl;
            double noise = world.method_8409().method_43058() * (double)this.size / 16.0;
            double radius = (double)(class_3532.method_15374((float)((float)Math.PI * radScl)) + 1.0f) * noise + 1.0;
            int xmin = class_3532.method_15357((double)(xn - radius / 2.0));
            int ymin = class_3532.method_15357((double)(yn - radius / 2.0));
            int zmin = class_3532.method_15357((double)(zn - radius / 2.0));
            int xmax = class_3532.method_15357((double)(xn + radius / 2.0));
            int ymax = class_3532.method_15357((double)(yn + radius / 2.0));
            int zmax = class_3532.method_15357((double)(zn + radius / 2.0));
            for (int x = xmin; x <= xmax; ++x) {
                double layerRadX = ((double)x + 0.5 - xn) / (radius / 2.0);
                if (!(layerRadX * layerRadX < 1.0)) continue;
                for (int y = ymin; y <= ymax; ++y) {
                    double layerRadY = ((double)y + 0.5 - yn) / (radius / 2.0);
                    if (!(layerRadX * layerRadX + layerRadY * layerRadY < 1.0)) continue;
                    for (int z = zmin; z <= zmax; ++z) {
                        int zSpread;
                        int xSpread;
                        class_2338 placePos;
                        class_2680 current;
                        class_2680 tmp;
                        double layerRadZ = ((double)z + 0.5 - zn) / (radius / 2.0);
                        if (!(layerRadX * layerRadX + layerRadY * layerRadY + layerRadZ * layerRadZ < 1.0) || (tmp = this.getOre(current = world.method_8320(placePos = new class_2338(x + (xSpread = world.method_8409().method_43048(this.spread) * (world.method_8409().method_43056() ? 1 : -1)), y, z + (zSpread = world.method_8409().method_43048(this.spread) * (world.method_8409().method_43056() ? 1 : -1)))), world.method_8409())) == null || !this.getBlockStateMatchers().contains(current) && !this.oreToWeightMap.containsKey(GeoclusterUtils.getRegistryName(current))) continue;
                        if (FeatureUtils.enqueueBlockPlacement(world, placePos, tmp, deposits, chunksGenerated)) {
                            ++totlPlaced;
                            continue;
                        }
                        ++totlPnding;
                    }
                }
            }
        }
        return totlPlaced + totlPnding;
    }

    @Override
    public void generatePost(class_5281 world, class_2338 pos, IWorldDepositComponent deposits, IWorldChunkComponent chunksGenerated) {
        if (GeoclusterConfig.DEBUG_WORLD_GEN) {
            Geocluster.LOGGER.info("Generated {} in Chunk {} (Pos [{} {} {}])", new Object[]{this, new class_1923(pos), pos.method_10263(), pos.method_10264(), pos.method_10260()});
        }
        int maxSampleCnt = (int)((float)Math.min(GeoclusterConfig.MAX_SAMPLES_PER_CHUNK, this.size / GeoclusterConfig.MAX_SAMPLES_PER_CHUNK + this.size % GeoclusterConfig.MAX_SAMPLES_PER_CHUNK));
        Deposit.findAndPlaceSample(maxSampleCnt, this.getSample(world.method_8409()), world, pos, deposits, chunksGenerated);
    }

    @Override
    public HashSet<class_2680> getBlockStateMatchers() {
        return this.blockStateMatchers == null ? DepositUtils.getDefaultMatchers() : this.blockStateMatchers;
    }

    public static SparseDeposit deserialize(JsonObject json) {
        if (json == null) {
            return null;
        }
        try {
            HashMap<String, HashMap<class_2680, Float>> oreBlocks = SerializerUtils.buildMultiBlockMatcherMap(json.get("blocks").getAsJsonObject());
            HashMap<class_2680, Float> sampleBlocks = SerializerUtils.buildMultiBlockMap(json.get("samples").getAsJsonArray());
            int yMin = json.get("yMin").getAsInt();
            int yMax = json.get("yMax").getAsInt();
            int spread = json.get("spread").getAsInt();
            int size = json.get("size").getAsInt();
            int genWt = json.get("generationWeight").getAsInt();
            class_6862 biomeTag = class_6862.method_40092((class_5321)class_2378.field_25114, (class_2960)new class_2960(json.get("biomeTag").getAsString().replace("#", "")));
            HashSet<class_2680> blockStateMatchers = DepositUtils.getDefaultMatchers();
            if (json.has("blockStateMatchers")) {
                blockStateMatchers = SerializerUtils.toBlockStateList(json.get("blockStateMatchers").getAsJsonArray());
            }
            return new SparseDeposit(oreBlocks, sampleBlocks, yMin, yMax, size, spread, genWt, (class_6862<class_1959>)biomeTag, blockStateMatchers);
        }
        catch (Exception e) {
            Geocluster.LOGGER.error("Failed to parse: {}", (Object)e.getMessage());
            return null;
        }
    }

    public JsonElement serialize() {
        JsonObject json = new JsonObject();
        JsonObject config = new JsonObject();
        config.add("blocks", (JsonElement)SerializerUtils.deconstructMultiBlockMatcherMap(this.oreToWeightMap));
        config.add("samples", (JsonElement)SerializerUtils.deconstructMultiBlockMap(this.sampleToWeightMap));
        config.addProperty("yMin", (Number)this.yMin);
        config.addProperty("yMax", (Number)this.yMax);
        config.addProperty("size", (Number)this.size);
        config.addProperty("spread", (Number)this.spread);
        config.addProperty("generationWeight", (Number)this.getWeight());
        config.addProperty("biomeTag", this.biomeTag.comp_327().toString());
        json.addProperty("type", JSON_TYPE);
        json.add("config", (JsonElement)config);
        return json;
    }
}

